/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import uk.ac.reload.diva.util.FilePath;
import uk.ac.reload.diva.util.GeneralUtils;

public final class NativeLauncher {
    private NativeLauncher() {
    }

    public static void launchFile(File file) {
        FilePath filePath = new FilePath(file);
        NativeLauncher.launchURL(filePath.getURL());
    }

    public static void launchURL(String url) {
        int OS = GeneralUtils.getOS();
        switch (OS) {
            case 1: 
            case 3: 
            case 4: {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "start", "\"\"", '\"' + url + '\"'});
                    process.waitFor();
                    process.exitValue();
                }
                catch (Exception ex) {}
                break;
            }
            case 2: {
                try {
                    Process process = Runtime.getRuntime().exec("start \"" + url + '\"');
                    process.waitFor();
                    process.exitValue();
                }
                catch (Exception ex) {}
                break;
            }
            case 0: {
                try {
                    Class<?> targetClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    Method openURL = targetClass.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url);
                }
                catch (Exception ex) {}
                break;
            }
            case 99: {
                try {
                    Process process = Runtime.getRuntime().exec("mozilla " + url);
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    public static void showFileInFileSystem(String path) {
        path = NativeLauncher.normalizePath(path);
        switch (GeneralUtils.getOS()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 99: {
                NativeLauncher.launchURL(path);
                break;
            }
            case 0: {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{"open", path});
                    process.waitFor();
                    process.exitValue();
                }
                catch (InterruptedException ex) {
                }
                catch (IOException iOException) {}
                break;
            }
        }
    }

    private static String normalizePath(String path) {
        return new File(path).getAbsolutePath();
    }
}

