/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import uk.ac.reload.dweezil.gui.ReloadFileChooser;
import uk.ac.reload.dweezil.gui.ReloadProgressMonitor;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;

public final class ReloadUtils {
    public static final int MACINTOSH = 0;
    public static final int WINDOWS_XP = 1;
    public static final int WINDOWS_9x = 2;
    public static final int WINDOWS_NT = 3;
    public static final int WINDOWS_2000 = 4;
    public static final int UNIX = 99;

    private ReloadUtils() {
    }

    public static int getOS() {
        String osName = System.getProperty("os.name");
        if ((osName = osName.toLowerCase()).equalsIgnoreCase("windows xp")) {
            return 1;
        }
        if (osName.equalsIgnoreCase("windows 2000")) {
            return 4;
        }
        if (osName.equalsIgnoreCase("windows nt")) {
            return 3;
        }
        if (osName.startsWith("mac os")) {
            return 0;
        }
        if (osName.startsWith("windows")) {
            return 2;
        }
        return 99;
    }

    public static String getJavaVersion() {
        return System.getProperties().getProperty("java.version");
    }

    public static boolean isJava14() {
        return ReloadUtils.getJavaVersion().startsWith("1.4");
    }

    public static String parseDate(Date date) {
        if (date == null) {
            return "";
        }
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        return df.format(date);
    }

    public static Date getNow() {
        Calendar c = Calendar.getInstance();
        return c.getTime();
    }

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return fileName.substring(i + 1).toLowerCase();
        }
        return "";
    }

    public static String getFileNameWithoutExtension(File file) {
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return fileName.substring(0, i);
        }
        return fileName;
    }

    public static boolean copyFolder(File srcFolder, File destFolder, ReloadProgressMonitor progressMonitor) throws IOException {
        if (srcFolder != null || destFolder != null && srcFolder.exists() && destFolder.exists()) {
            destFolder.mkdirs();
            File[] srcFiles = srcFolder.listFiles();
            for (int i = 0; i < srcFiles.length; ++i) {
                File srcFile = srcFiles[i];
                if (progressMonitor != null) {
                    progressMonitor.setNote(srcFile.getName());
                    if (progressMonitor.isCanceled()) {
                        return false;
                    }
                }
                if (srcFile.isDirectory()) {
                    ReloadUtils.copyFolder(srcFile, new File(destFolder, srcFile.getName()), progressMonitor);
                    continue;
                }
                ReloadUtils.copyFile(srcFile, new File(destFolder, srcFile.getName()));
            }
            return true;
        }
        return false;
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (srcFile != null || destFile != null && srcFile.exists()) {
            int size;
            int bufSize = 512;
            byte[] buf = new byte[bufSize];
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(srcFile), bufSize);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile), bufSize);
            while ((size = bis.read(buf)) != -1) {
                bos.write(buf, 0, size);
            }
            bos.flush();
            bos.close();
            bis.close();
        }
    }

    public static void moveFile(File srcFile, File destFile) throws IOException {
        if (srcFile == null || destFile == null) {
            return;
        }
        if (!srcFile.exists() || destFile.exists()) {
            return;
        }
        ReloadUtils.copyFile(srcFile, destFile);
        srcFile.delete();
    }

    public static void deleteFolder(File afolder) throws IOException {
        if (afolder != null) {
            File parent = afolder.getParentFile();
            if (parent == null) {
                throw new IOException("Cannot delete root folder");
            }
            FileSystemView view = FileSystemView.getFileSystemView();
            if (view.isRoot(afolder)) {
                throw new IOException("Cannot delete root folder");
            }
            if (afolder.exists() && afolder.isDirectory()) {
                for (File f : afolder.listFiles()) {
                    if (f.isFile()) {
                        f.delete();
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    ReloadUtils.deleteFolder(f);
                }
                afolder.delete();
            }
        }
    }

    public static int countFiles(File folder) {
        int count = 1;
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (files[i].isDirectory()) {
                count += ReloadUtils.countFiles(files[i]);
                continue;
            }
            ++count;
        }
        return count;
    }

    public static void centreWindowProportional(Window window, double width, double height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenSize.width / 2;
        int screenHeight = screenSize.height / 2;
        int newWidth = (int)((double)screenSize.width * width);
        int newHeight = (int)((double)screenSize.height * height);
        window.setSize(newWidth, newHeight);
        window.setLocation(screenWidth - newWidth / 2, screenHeight - newHeight / 2);
    }

    public static void centreWindow(Window window, int width, int height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenSize.width / 2;
        int screenHeight = screenSize.height / 2;
        window.setSize(width, height);
        window.setLocation(screenWidth - width / 2, screenHeight - height / 2);
    }

    public static int getScreenWidth() {
        return Toolkit.getDefaultToolkit().getScreenSize().width;
    }

    public static int getScreenHeight() {
        return Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    public static URL getResourceURL(String fileName) {
        return fileName == null ? null : fileName.getClass().getResource(fileName);
    }

    public static Class getClassFromJar(String className, File jarFile) {
        try {
            URL url = jarFile.toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url});
            return loader.loadClass(className);
        }
        catch (Exception ex) {
            System.out.println("Could not create class: " + className + " " + ex);
            return null;
        }
    }

    public static Object getClassInstanceFromJar(String className, File jarFile) {
        Object o = null;
        try {
            Class c = ReloadUtils.getClassFromJar(className, jarFile);
            if (c != null) {
                o = c.newInstance();
            }
        }
        catch (Exception ex) {
            System.out.println("Could not create class instance: " + className + " " + ex);
            return null;
        }
        return o;
    }

    public static String getRelativePath(File rootFolder, File file) {
        URI uriFile;
        URI uriRoot = rootFolder.toURI();
        URI result = uriRoot.relativize(uriFile = file.toURI());
        if (result == null) {
            return file.getName();
        }
        String str = result.getPath();
        return str == null ? file.getName() : str;
    }

    public static JInternalFrame getInternalFrameAncestor(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JInternalFrame) {
            return (JInternalFrame)c;
        }
        for (Container p = c.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JInternalFrame)) continue;
            return (JInternalFrame)p;
        }
        return null;
    }

    public static boolean isComponentInMainFrame(Component c) {
        return !ReloadUtils.isComponentInInternalFrame(c);
    }

    public static boolean isComponentInInternalFrame(Component c) {
        JInternalFrame frame = ReloadUtils.getInternalFrameAncestor(c);
        return frame != null;
    }

    public static String getLocalFileURL(File file) {
        String path = file.getAbsolutePath();
        path = path.replaceAll(" ", "%20");
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        if (path.startsWith("/")) {
            return "file://" + path;
        }
        return "file:///" + path;
    }

    public static void launchFile(File file) {
        if (file == null) {
            return;
        }
        String path = file.getAbsolutePath();
        ReloadUtils.launchFile(ReloadUtils.getLocalFileURL(file));
    }

    public static void launchFile(String path) {
        int OS = ReloadUtils.getOS();
        switch (OS) {
            case 1: 
            case 3: 
            case 4: {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "start", "\"\"", '\"' + path + '\"'});
                    process.waitFor();
                    process.exitValue();
                }
                catch (InterruptedException ex) {
                }
                catch (IOException ex) {}
                break;
            }
            case 2: {
                try {
                    Process process = Runtime.getRuntime().exec("rundll32.exe url.dll,FileProtocolHandler " + path);
                    process.waitFor();
                    process.exitValue();
                }
                catch (InterruptedException ex) {
                }
                catch (IOException ex) {}
                break;
            }
            case 0: {
                try {
                    Class<?> targetClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    Method openURL = targetClass.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, path);
                }
                catch (Exception ex) {
                    System.out.println("Error opening native browser on Mac");
                }
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "Unknown Operating System", "View File", 1);
            }
        }
    }

    public static File askFileNameOpen(Component parent, String title, FileFilter filter) {
        ReloadFileChooser chooser = null;
        chooser = title.indexOf("Choose Template") >= 0 ? new ReloadFileChooser(ReloadEditorDocumentHandler.TEMPLATEFOLDER) : new ReloadFileChooser();
        chooser.setDialogTitle(title);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(parent);
        if (returnVal != 0) {
            return null;
        }
        return chooser.getSelectedFileAndStore();
    }

    public static File askFileNameSave(Component parent, String title, FileFilter filter, String extension) {
        String fileName;
        ReloadFileChooser chooser = new ReloadFileChooser();
        chooser.setDialogTitle(title);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(parent);
        if (returnVal != 0) {
            return null;
        }
        File file = chooser.getSelectedFileAndStore();
        if (extension != null && !(fileName = file.getPath()).endsWith("." + extension)) {
            file = new File(fileName + "." + extension);
        }
        return file;
    }
}

