/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import uk.ac.reload.dweezil.util.DweezilXMLException;

public final class XMLUtils {
    private static final String OBJECTIVES = "adlseq:objectives";
    private static final String ADLOBJECTIVES = "adlseq:ADLobjectives";
    public static String DEFAULT_SAX_DRIVER_CLASS = "org.apache.xerces.parsers.SAXParser";

    public static void write2XMLFile(Document doc, File file) throws DweezilXMLException {
        try {
            XMLUtils.WriteInitialDocument(doc, file);
            StringBuilder newFileContents = XMLUtils.readAndProcessXmlDocument(file, ADLOBJECTIVES, OBJECTIVES);
            XMLUtils.writeProcessedDocument(file, newFileContents);
            SAXBuilder builder = new SAXBuilder(DEFAULT_SAX_DRIVER_CLASS);
            doc = builder.build(file);
            XMLUtils.WriteInitialDocument(doc, file);
        }
        catch (Exception ex) {
            throw new DweezilXMLException(ex);
        }
    }

    private static void writeProcessedDocument(File file, StringBuilder newFileContents) throws FileNotFoundException, IOException {
        FileOutputStream processedOutput = new FileOutputStream(file);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)processedOutput, XMLUtils.getEncoding()));
        writer.write(newFileContents.toString());
        writer.close();
        processedOutput.close();
    }

    private static Charset getEncoding() {
        return Charset.forName("UTF8");
    }

    private static StringBuilder readAndProcessXmlDocument(File file, String testValue, String replaceValue) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, XMLUtils.getEncoding()));
        String line = null;
        StringBuilder newFileContents = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            line = line.replace(testValue, replaceValue);
            newFileContents.append(line);
        }
        in.close();
        reader.close();
        return newFileContents;
    }

    private static void WriteInitialDocument(Document doc, File file) throws IOException {
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        XMLOutputter outputter = new XMLOutputter(format);
        FileOutputStream out = new FileOutputStream(file);
        outputter.output(doc, (OutputStream)out);
        out.close();
    }

    public static Document readXMLFile(File file, String schemaNamespace, String schemaLocation) throws DweezilXMLException {
        Document doc = null;
        try {
            SAXBuilder builder = XMLUtils.createSaxBuilder(schemaNamespace, schemaLocation);
            StringBuilder newFileContents = XMLUtils.readAndProcessXmlDocument(file, OBJECTIVES, ADLOBJECTIVES);
            XMLUtils.writeProcessedDocument(file, newFileContents);
            doc = builder.build(new FileInputStream(file));
        }
        catch (Exception ex) {
            throw new DweezilXMLException(ex);
        }
        return doc;
    }

    private static SAXBuilder createSaxBuilder(String schemaNamespace, String schemaLocation) {
        SAXBuilder builder = new SAXBuilder(DEFAULT_SAX_DRIVER_CLASS, true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        if (schemaNamespace != null && !schemaNamespace.isEmpty()) {
            builder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", schemaNamespace + " " + schemaLocation);
        }
        return builder;
    }

    public static Document readXMLFile(File file) throws DweezilXMLException {
        Document doc = null;
        try {
            StringBuilder newFileContents;
            SAXBuilder builder = new SAXBuilder(DEFAULT_SAX_DRIVER_CLASS);
            if (file.getName().equalsIgnoreCase("imsmanifest.xml")) {
                newFileContents = XMLUtils.readAndProcessXmlDocument(file, OBJECTIVES, ADLOBJECTIVES);
                XMLUtils.writeProcessedDocument(file, newFileContents);
            }
            doc = builder.build(new FileInputStream(file));
            if (file.getName().equalsIgnoreCase("imsmanifest.xml")) {
                newFileContents = XMLUtils.readAndProcessXmlDocument(file, ADLOBJECTIVES, OBJECTIVES);
                XMLUtils.writeProcessedDocument(file, newFileContents);
            }
        }
        catch (Exception ex) {
            throw new DweezilXMLException(ex);
        }
        return doc;
    }
}

