/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import uk.ac.reload.dweezil.DweezilConstants;
import uk.ac.reload.dweezil.gui.ReloadProgressMonitor;
import uk.ac.reload.dweezil.util.DweezilZipException;
import uk.ac.reload.dweezil.util.ReloadUtils;

public final class ZipUtils
implements DweezilConstants {
    public static void addFolderToZip(File rootFolder, File folder, ZipOutputStream zOut, File zipFile) throws DweezilZipException {
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                ZipUtils.addFolderToZip(rootFolder, files[i], zOut, zipFile);
                continue;
            }
            if (files[i].equals(zipFile)) continue;
            String entryName = ReloadUtils.getRelativePath(rootFolder, files[i]);
            ZipUtils.addFileToZip(files[i], entryName, zOut);
        }
    }

    public static boolean addFileToZip(File file, String entryName, ZipOutputStream zOut) throws DweezilZipException {
        if (file == null || !file.exists()) {
            return false;
        }
        int bufSize = 1024;
        byte[] buf = new byte[1024];
        try {
            int bytesRead;
            ZipEntry zipEntry = new ZipEntry(entryName);
            zipEntry.setTime(file.lastModified());
            zOut.putNextEntry(zipEntry);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), 1024);
            while ((bytesRead = in.read(buf)) != -1) {
                zOut.write(buf, 0, bytesRead);
            }
            zOut.closeEntry();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DweezilZipException("Could not add file to zip");
        }
        return true;
    }

    public static boolean addStringToZip(String text, String entryName, ZipOutputStream zOut) throws DweezilZipException {
        try {
            int i;
            BufferedReader reader = new BufferedReader(new StringReader(text));
            ZipEntry zipEntry = new ZipEntry(entryName);
            zOut.putNextEntry(zipEntry);
            while ((i = reader.read()) != -1) {
                zOut.write(i);
            }
            zOut.closeEntry();
        }
        catch (Exception ex) {
            throw new DweezilZipException("Could not add String to zip");
        }
        return true;
    }

    public static String extractZipEntry(File zipFile, String entryName) throws DweezilZipException {
        ZipInputStream zIn;
        if (zipFile == null || !zipFile.exists()) {
            return null;
        }
        boolean foundEntry = false;
        try {
            ZipEntry zipEntry;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
            zIn = new ZipInputStream(in);
            while ((zipEntry = zIn.getNextEntry()) != null) {
                String zipEntryName = zipEntry.getName();
                if (zipEntryName.equalsIgnoreCase(entryName)) {
                    foundEntry = true;
                    break;
                }
                zIn.closeEntry();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DweezilZipException("Could not extract zip entry");
        }
        if (!foundEntry) {
            try {
                zIn.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            int bit;
            while ((bit = zIn.read()) != -1) {
                sb.append((char)bit);
            }
            zIn.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DweezilZipException("Could not extract zip entry");
        }
        return sb.toString();
    }

    public static File extractZipEntry(File zipFile, String entryName, File outFile) throws DweezilZipException {
        ZipEntry zipEntry;
        ZipInputStream zIn;
        if (zipFile == null || !zipFile.exists()) {
            return null;
        }
        int bufSize = 1024;
        byte[] buf = new byte[1024];
        boolean foundEntry = false;
        try {
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile), 1024);
            zIn = new ZipInputStream(in);
            while ((zipEntry = zIn.getNextEntry()) != null) {
                String zipEntryName = zipEntry.getName();
                if (zipEntryName.equalsIgnoreCase(entryName)) {
                    foundEntry = true;
                    break;
                }
                zIn.closeEntry();
            }
        }
        catch (Exception ex) {
            throw new DweezilZipException("Could not extract zip entry");
        }
        if (!foundEntry) {
            return null;
        }
        try {
            int bytesRead;
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile), 1024);
            while ((bytesRead = zIn.read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
                Thread.sleep(2L);
            }
            out.flush();
            out.close();
            zIn.close();
            outFile.setLastModified(zipEntry.getTime());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DweezilZipException("Could not save zip entry");
        }
        return outFile;
    }

    public static String[] getZipFileEntryNames(File zipFile) throws DweezilZipException {
        if (zipFile == null || !zipFile.exists()) {
            return null;
        }
        ZipInputStream zIn = null;
        int bufSize = 1024;
        Vector<String> fileList = new Vector<String>();
        try {
            ZipEntry zipEntry;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile), 1024);
            zIn = new ZipInputStream(in);
            while ((zipEntry = zIn.getNextEntry()) != null) {
                if (!zipEntry.isDirectory()) {
                    String zipEntryName = zipEntry.getName();
                    fileList.addElement(zipEntryName);
                }
                zIn.closeEntry();
            }
        }
        catch (Exception ex) {
            throw new DweezilZipException("Could not locate zip entry");
        }
        finally {
            try {
                if (zIn != null) {
                    zIn.close();
                }
            }
            catch (IOException ex) {}
        }
        Object[] names = new String[fileList.size()];
        fileList.copyInto(names);
        return names;
    }

    public static boolean unpackZip(File zipFile, File folder) throws DweezilZipException {
        return ZipUtils.unpackZip(zipFile, folder, null);
    }

    public static boolean unpackZip(File zipFile, File folder, ReloadProgressMonitor progressMonitor) throws DweezilZipException {
        if (zipFile == null || !zipFile.exists()) {
            return false;
        }
        folder.mkdirs();
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        ZipInputStream zIn = null;
        int bufSize = 512;
        byte[] buf = new byte[512];
        try {
            ZipEntry zipEntry;
            in = new BufferedInputStream(new FileInputStream(zipFile), 512);
            zIn = new ZipInputStream(in);
            while ((zipEntry = zIn.getNextEntry()) != null) {
                if (!zipEntry.isDirectory()) {
                    int bytesRead;
                    File outFile = new File(folder, zipEntry.getName());
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    out = new BufferedOutputStream(new FileOutputStream(outFile), 512);
                    if (progressMonitor != null) {
                        progressMonitor.setNote(zipEntry.getName());
                    }
                    int sleep_count = 0;
                    while ((bytesRead = zIn.read(buf)) != -1) {
                        out.write(buf, 0, bytesRead);
                        if (sleep_count >= 40) {
                            Thread.sleep(2L);
                            sleep_count = 0;
                        }
                        ++sleep_count;
                        if (progressMonitor == null || !progressMonitor.isCanceled()) continue;
                        out.flush();
                        out.close();
                        zIn.close();
                        return false;
                    }
                    outFile.setLastModified(zipEntry.getTime());
                    out.flush();
                    out.close();
                }
                zIn.closeEntry();
            }
            zIn.close();
        }
        catch (Exception ex) {
            try {
                if (zIn != null) {
                    zIn.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException ex1) {
                // empty catch block
            }
            ex.printStackTrace();
            throw new DweezilZipException("Could not save zip entry");
        }
        return true;
    }
}

