/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import uk.ac.reload.dweezil.ApplicationListener;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadFileChooser;
import uk.ac.reload.dweezil.gui.ReloadInternalFrame;
import uk.ac.reload.dweezil.gui.ReloadInternalFrameManager;
import uk.ac.reload.dweezil.gui.ReloadStatusWindow;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.gui.SplashScreen;
import uk.ac.reload.dweezil.util.DweezilXMLException;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditorDesktopPane;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.editor.prefs.ReloadEditorPrefs;

public class ReloadEditor
extends JFrame
implements InternalFrameListener {
    public static boolean DEBUG = true;
    public static String APP_NAME = "ADL SCORM 2004 RELOAD Editor";
    public static String VERSION = "1.1";
    public static String BUILD_DATE = "November 20, 2009";
    public static String COPYRIGHT = "Copyright (c) 2003 Oleg Liber, Bill Olivier, Phillip Beauvoir";
    public static String AUTHORS = "Authors - Phillip Beauvoir, Paul Sharples, Jennifer Brooks, ADL Technical Team";
    public static String PROJMANAGER = "Project Management - Oleg Liber, ADL Technical Team";
    public static String BILL = "Adviser on Specifications and Architecture - Bill Olivier, ADL Technical Team";
    public static String DOCDISS = "Documentation and Dissemination - Colin Milligan, ADL Technical Team";
    public static String CONTRIBUTORS = "Advisers & Contributors - Phil Barker, Lorna Campbell, Sarah Currier, Charles Duncan, Pierre Gorissen, Gerry Graham, Steve Jeyes, Wilbert Kraan, Boon Low, Sharon Perry, Mark Power, Ben Ryan, Scott Wilson, ADL Technical Team, Frank Zappa and all the Glasgow code-bashers";
    public static String EMAIL_CONTACT = "p.beauvoir@bolton.ac.uk, brooksj@adlnet.org";
    public static String WEB_PAGE = "http://www.adlnet.gov";
    public static String ICON_PATH = "/resources/images/";
    public static String ICON_VALIDATE = ICON_PATH + "checkmark.gif";
    public static String IMG_LINE = ICON_PATH + "line.gif";
    public static String ICON_ADL = ICON_PATH + "adl.gif";
    public static String ICON_APP16 = ICON_PATH + "app16.gif";
    public static String ICON_APP32 = ICON_PATH + "app32.gif";
    public static String ICON_BLANK = ICON_PATH + "blank16.gif";
    public static String ICON_COPY = ICON_PATH + "copy.gif";
    public static String ICON_CP = ICON_PATH + "cp.gif";
    public static String ICON_CPSCORM = ICON_PATH + "cp_scorm.gif";
    public static String ICON_CUT = ICON_PATH + "cut.gif";
    public static String ICON_DELETE = ICON_PATH + "delete.gif";
    public static String ICON_DEPENDENCY = ICON_PATH + "dependency.gif";
    public static String ICON_DOWN = ICON_PATH + "down.gif";
    public static String ICON_FILE = ICON_PATH + "file.gif";
    public static String ICON_FOLDER_CLOSED = ICON_PATH + "folder_closed.gif";
    public static String ICON_FOLDER_NEW = ICON_PATH + "folder_new.gif";
    public static String ICON_FOLDER_OPEN = ICON_PATH + "folder_open.gif";
    public static String ICON_IMPORT = ICON_PATH + "import.gif";
    public static String ICON_ITEM = ICON_PATH + "parent_item.gif";
    public static String ICON_SCO = ICON_PATH + "sco.gif";
    public static String ICON_ITEMSCORM = ICON_PATH + "item_scorm.gif";
    public static String ICON_SCOSCORM = ICON_PATH + "sco.gif";
    public static String ICON_JUMP = ICON_PATH + "jump.gif";
    public static String ICON_LEFT = ICON_PATH + "left.gif";
    public static String ICON_MD = ICON_PATH + "md.gif";
    public static String ICON_MDLEAF = ICON_PATH + "md-leaf.gif";
    public static String ICON_MDFOLDER = ICON_PATH + "md-folder.gif";
    public static String ICON_ORGS = ICON_PATH + "orgs.gif";
    public static String ICON_ORG = ICON_PATH + "org.gif";
    public static String ICON_NEW = ICON_PATH + "new.gif";
    public static String ICON_OPEN = ICON_PATH + "open.gif";
    public static String ICON_PASTE = ICON_PATH + "paste.gif";
    public static String ICON_REDO = ICON_PATH + "redo.gif";
    public static String ICON_REFRESH = ICON_PATH + "refresh.gif";
    public static String ICON_RESOURCE = ICON_PATH + "resource.gif";
    public static String ICON_RESOURCES = ICON_PATH + "resources.gif";
    public static String ICON_SAVE = ICON_PATH + "save.gif";
    public static String ICON_TITLE = ICON_PATH + "title.gif";
    public static String ICON_UNDO = ICON_PATH + "undo.gif";
    public static String ICON_UP = ICON_PATH + "up.gif";
    public static String ICON_VIEWCP = ICON_PATH + "viewcp.gif";
    public static String ICON_VIEWFILE = ICON_PATH + "viewfile.gif";
    public static String ICON_ZIP = ICON_PATH + "zip.gif";
    public static String ICON_CONVERT = ICON_PATH + "convert.gif";
    public static String ICON_VIEWRTE = ICON_PATH + "lms.gif";
    public static String IMAGE_SPLASH = ICON_PATH + "splash.jpg";
    public static String IMAGE_EASTER_EGG = ICON_PATH + "easter_egg.jpg";
    private ReloadStatusWindow _statusWindow;
    private ReloadInternalFrameManager _internalFrameManager;
    private static ReloadEditor _instance;
    private ReloadEditorDesktopPane _desktop;
    private Vector listeners = new Vector();

    public ReloadEditor() {
        _instance = this;
        ReloadUIManager.setMacUIDefaults(APP_NAME);
        SplashScreen splash = new SplashScreen(ReloadUIManager.getIcon(IMAGE_SPLASH));
        this._statusWindow = new ReloadStatusWindow(APP_NAME, VERSION, BUILD_DATE, ReloadUIManager.getIcon(ICON_APP32), DEBUG);
        String lf = ReloadEditorPrefs.getInstance().getValue("look_and_feel");
        if (lf == null) {
            lf = UIManager.getSystemLookAndFeelClassName();
        }
        ReloadUIManager.setLookAndFeel(lf, new Component[]{ReloadEditor.getInstance(), this.getStatusWindow()});
        String defFolder = ReloadEditorPrefs.getInstance().getValue("default_folder");
        if (defFolder != null) {
            ReloadFileChooser.setDefaultFolder(new File(defFolder));
        }
        super.setTitle(APP_NAME);
        ImageIcon icon = ReloadUIManager.getIcon(ICON_APP32);
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReloadEditor.this.closeApp();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        this._desktop = new ReloadEditorDesktopPane();
        panel.add((Component)this._desktop, "Center");
        this.setContentPane(panel);
        this._internalFrameManager = new ReloadInternalFrameManager(this._desktop);
        this.setJMenuBar(MainMenu.sharedInstance);
        this.getContentPane().add((Component)MainMenu.sharedInstance.getReloadToolBar(), "North");
        splash.close();
        ReloadUtils.centreWindowProportional(this, 0.9, 0.9);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new ReloadEditor();
    }

    public static ReloadEditor getInstance() {
        return _instance;
    }

    public ReloadStatusWindow getStatusWindow() {
        return this._statusWindow;
    }

    public ReloadInternalFrameManager getInternalFrameManager() {
        return this._internalFrameManager;
    }

    public File getHelpFile() {
        return new File(System.getProperty("user.dir"), "/help/ADL_Readme/main.html");
    }

    public void closeApp() {
        boolean result = this.fireApplicationClosing();
        if (result) {
            String lf = UIManager.getLookAndFeel().getClass().getName();
            ReloadEditorPrefs.getInstance().putValue("look_and_feel", lf);
            try {
                ReloadEditorPrefs.getInstance().save();
            }
            catch (DweezilXMLException ex) {
                ErrorDialogBox.showWarning(this, "Could not save Preferences: ", "Preferences", ex);
            }
            System.exit(0);
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(APP_NAME + " - " + title);
    }

    public JDesktopPane getDesktop() {
        return this._desktop;
    }

    public void addInternalFrame(ReloadInternalFrame frame) {
        frame.addInternalFrameListener(this);
        this._internalFrameManager.addInternalFrame(frame);
        MainMenu.sharedInstance.addInternalFrame(frame);
    }

    public void removeInternalFrame(ReloadInternalFrame frame) {
        frame.removeInternalFrameListener(this);
        this._internalFrameManager.removeInternalFrame(frame);
        MainMenu.sharedInstance.removeInternalFrame(frame);
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        Object o = e.getSource();
        if (o instanceof ReloadInternalFrame) {
            this.removeInternalFrame((ReloadInternalFrame)o);
        }
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public synchronized void addApplicationListener(ApplicationListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public synchronized void removeApplicationListener(ApplicationListener listener) {
        this.listeners.removeElement(listener);
    }

    public boolean fireApplicationClosing() {
        boolean ok = true;
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ApplicationListener listener = (ApplicationListener)this.listeners.elementAt(i);
            boolean result = listener.applicationClosing();
            if (result) continue;
            ok = false;
        }
        return ok;
    }
}

