/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.AbstractList;
import javax.swing.JDesktopPane;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;

public class ReloadEditorDesktopPane
extends JDesktopPane
implements DropTargetListener {
    public ReloadEditorDesktopPane() {
        DropTarget dropTarget = new DropTarget(this, this);
    }

    private void openFiles(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName().toLowerCase();
            if (!name.endsWith(".zip") && !name.endsWith(".xml")) continue;
            ReloadEditorDocumentHandler.openFile(ReloadEditor.getInstance(), files[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent event) {
        Transferable transferable = event.getTransferable();
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            event.acceptDrop(this.getCorrectDropContext(event));
            try {
                Object userObject = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (userObject instanceof AbstractList) {
                    AbstractList list = (AbstractList)userObject;
                    Object[] files = list.toArray();
                    this.openFiles((File[])files);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            event.getDropTargetContext().dropComplete(true);
        } else {
            event.rejectDrop();
        }
    }

    public boolean isDropOK(DropTargetDragEvent event) {
        DataFlavor[] flavors = event.getCurrentDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (this.isDropOK(event)) {
            event.acceptDrag(this.getCorrectDropContext(event));
        } else {
            event.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        if (this.isDropOK(event)) {
            event.acceptDrag(this.getCorrectDropContext(event));
        } else {
            event.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        if (this.isDropOK(event)) {
            event.acceptDrag(this.getCorrectDropContext(event));
        } else {
            event.rejectDrag();
        }
    }

    public int getCorrectDropContext(DropTargetDropEvent event) {
        int OS = ReloadUtils.getOS();
        if (OS == 0) {
            int result = event.getDropAction();
            switch (result) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 1;
        }
        return event.getDropAction();
    }

    public int getCorrectDropContext(DropTargetDragEvent event) {
        int OS = ReloadUtils.getOS();
        if (OS == 0) {
            int result = event.getDropAction();
            switch (result) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 1;
        }
        return event.getDropAction();
    }
}

