/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.jdom.Document;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadFileFilter;
import uk.ac.reload.dweezil.gui.ReloadFolderChooser;
import uk.ac.reload.dweezil.gui.ReloadInternalFrame;
import uk.ac.reload.dweezil.gui.ReloadInternalFrameManager;
import uk.ac.reload.dweezil.gui.ReloadProgressMonitor;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.dweezil.util.XMLUtils;
import uk.ac.reload.dweezil.util.ZipUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.ReloadEditorSchemaController;
import uk.ac.reload.editor.contentpackaging.ContentPackageEditor;
import uk.ac.reload.editor.contentpackaging.ContentPackageSchemaController;
import uk.ac.reload.editor.contentpackaging.SCORM1_2PackageEditor;
import uk.ac.reload.editor.contentpackaging.SCORM1_2SchemaController;
import uk.ac.reload.editor.contentpackaging.SCORM1_3PackageEditor;
import uk.ac.reload.editor.contentpackaging.SCORM1_3SchemaController;
import uk.ac.reload.editor.metadata.MetadataEditorFrame;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.editor.prefs.ReloadEditorPrefs;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaController;

public final class ReloadEditorDocumentHandler
extends IMSDocumentHandler {
    public static File SCHEMAROOTFOLDER = new File(System.getProperty("user.dir"), "schema");
    public static File SCHEMASHIPPEDFOLDER = new File(SCHEMAROOTFOLDER, "shipped");
    public static File SCHEMAMODELFOLDER = new File(SCHEMAROOTFOLDER, "model");
    public static File HELPERFOLDER = new File(System.getProperty("user.dir"), "helpers");
    public static File TEMPLATEFOLDER = new File(System.getProperty("user.dir"), "LSAL_Templates");
    public static File fileSchemaMD1_2_1 = new File(new File(SCHEMAMODELFOLDER, IMSMD_121), "imsmd_rootv1p2p1.xsd");
    public static File fileSchemaMD1_2_2 = new File(new File(SCHEMAMODELFOLDER, IMSMD_122), "imsmd_v1p2p2.xsd");
    public static File fileSchemaLOM1_0 = new File(new File(SCHEMAMODELFOLDER, LOM_10), "lom.xsd");
    public static File fileSchemaLOM1_0_HealthCare = new File(new File(SCHEMAMODELFOLDER, LOM_10), "lom_healthcare.xsd");
    public static File folderMDHelper = new File(HELPERFOLDER, "md");
    public static File folderMDProfile = new File(folderMDHelper, "profile");
    public static File fileDefaultMDProfile = new File(folderMDProfile, "lom_en_profile.xml");
    public static File fileDefaultSCORM2004MDProfile = new File(folderMDProfile, "lom_SCORM_shortForm_profile.xml");
    public static File fileHealthCareSCORM2004MDProfile = new File(folderMDProfile, "lom_SCORM_healthcare_profile.xml");
    public static File fileDefaultSCORM1_2MDProfile = new File(folderMDProfile, "ims-lrm_en_profile.xml");
    public static File folderMDSchemahelper = new File(folderMDHelper, "schemahelper");
    public static File folderMDVocab = new File(folderMDHelper, "vocab");
    public static File fileSchemaCP1_1_2 = new File(new File(SCHEMAMODELFOLDER, IMSCP_112), "imscp_rootv1p1p2.xsd");
    public static File fileSchemaCP1_1_3 = new File(new File(SCHEMAMODELFOLDER, IMSCP_113), "imscp_v1p1.xsd");
    public static File folderCPHelper = new File(HELPERFOLDER, "cp");
    public static File folderCPProfile = new File(folderCPHelper, "profile");
    public static File fileDefaultCPProfile = new File(folderCPProfile, "ims-cp_en_profile.xml");
    public static File folderCPSchemahelper = new File(folderCPHelper, "schemahelper");
    public static File folderCPVocab = new File(folderCPHelper, "vocab");
    public static File fileSchemaSCORM1_2_IMCP1_1_2 = new File(new File(SCHEMAMODELFOLDER, ADLCP_120_112), "imscp_rootv1p1p2.xsd");
    public static File fileSchemaSCORM1_2_IMCP1_1_3 = new File(new File(SCHEMAMODELFOLDER, ADLCP_120_113), "imscp_v1p1.xsd");
    public static File folderSCORM1_2Helper = new File(HELPERFOLDER, "scorm1_2");
    public static File folderSCORM1_2Profile = new File(folderSCORM1_2Helper, "profile");
    public static File fileDefaultSCORM1_2Profile = new File(folderSCORM1_2Profile, "scorm12_en_profile.xml");
    public static File folderSCORM1_2Schemahelper = new File(folderSCORM1_2Helper, "schemahelper");
    public static File folderSCORM1_2Vocab = new File(folderSCORM1_2Helper, "vocab");
    public static File fileSchemaSCORM1_3_0_4TH = new File(new File(SCHEMAMODELFOLDER, ADLCP_130_4th), "imscp_v1p1.xsd");
    public static File fileSchemaSCORM1_3_0_3RD = new File(new File(SCHEMAMODELFOLDER, ADLCP_130_3RD), "imscp_v1p1.xsd");
    public static File folderSCORM1_3Helper = new File(HELPERFOLDER, "scorm1_3");
    public static File folderSCORM1_3Profile = new File(folderSCORM1_3Helper, "profile");
    public static File fileDefaultSCORM1_3Profile = new File(folderSCORM1_3Profile, "scorm13_en_profile.xml");
    public static File folderSCORM1_3Schemahelper = new File(folderSCORM1_3Helper, "schemahelper");
    public static File folderSCORM1_3Vocab = new File(folderSCORM1_3Helper, "vocab");
    public static File fileSchemaSS1_0 = new File(new File(SCHEMAMODELFOLDER, IMSSS_100), "imsss_v1p0.xsd");
    public static File folderSSHelper = new File(HELPERFOLDER, "ss");
    public static File folderSSSchemahelper = new File(folderSSHelper, "schemahelper");
    public static File fileHelperSS = new File(folderSSSchemahelper, "imsss_en_helper.xml");
    public static File folderSSVocab = new File(folderSSHelper, "vocab");
    public static File fileVocabSS = new File(folderSSVocab, "imsss_en_vocab.xml");

    public static void openFile(Component parent) {
        ReloadFileFilter filter = new ReloadFileFilter(new String[]{"xml", "zip"}, "XML or Archive Files");
        File file = ReloadUtils.askFileNameOpen(parent, "Open XML or Archive file", filter);
        if (file == null) {
            return;
        }
        ReloadEditorDocumentHandler.openFile(parent, file);
    }

    public static void openFile(Component parent, String title, boolean tisTrue) {
        ReloadFileFilter filter = new ReloadFileFilter(new String[]{"xml", "zip"}, "XML or Archive Files");
        File file = ReloadUtils.askFileNameOpen(parent, title, filter);
        if (file == null) {
            return;
        }
        ReloadEditorDocumentHandler.openFile(parent, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openFile(Component parent, File file) {
        ReloadProgressMonitor progressMonitor = null;
        ReloadInternalFrame frame = ReloadInternalFrameManager.getReloadInternalFrame(file);
        if (frame != null) {
            try {
                frame.setIcon(false);
                frame.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
            return;
        }
        try {
            if (file.getName().toLowerCase().endsWith(".zip")) {
                if (!ReloadEditorDocumentHandler.containsManifest(file)) {
                    JOptionPane.showMessageDialog(ReloadEditor.getInstance(), "Manifest file imsmanifest.xml cannot be located in archive.", "Archive error", 2);
                    return;
                }
                File targetFolder = ReloadEditorDocumentHandler.askNewContentPackageFolder("Select Folder to Unzip " + file.getName());
                if (targetFolder == null) {
                    return;
                }
                progressMonitor = new ReloadProgressMonitor(ReloadEditor.getInstance(), "Unzipping Content Package", "Unzipping...", "Searching...", true, ReloadUIManager.getIcon(ReloadEditor.ICON_APP16));
                if ((file = ReloadEditorDocumentHandler.unzipContentPackage(file, targetFolder, progressMonitor)) == null) {
                    return;
                }
            }
            ReloadEditor.getInstance().setCursor(ReloadUIManager.WAIT_CURSOR);
            Document doc = XMLUtils.readXMLFile(file);
            String version = ReloadEditorDocumentHandler.getSchemaVersion(doc);
            if (version == null) {
                ReloadEditor.getInstance().setCursor(ReloadUIManager.DEFAULT_CURSOR);
                ReloadEditorDocumentHandler.showWarningMessage("This is an unsupported version.  Sorry, cannot open file.");
                return;
            }
            ReloadSchemaController schemaController = ReloadEditorSchemaController.getReloadSchemaController(version.equals(IMSDocumentHandler.LOM_10) && ReloadEditorDocumentHandler.IsDocumentHealthcare(doc.getRootElement()) ? "lom_hc_10" : version);
            if (schemaController == null) {
                ReloadEditor.getInstance().setCursor(ReloadUIManager.DEFAULT_CURSOR);
                ReloadEditorDocumentHandler.showWarningMessage("This is an unsupported version.  Sorry, cannot open file.");
                return;
            }
            ReloadEditorDocumentHandler.correctAdditionalNamespaces(doc);
            ReloadEditorDocumentHandler.correctLomElement(doc.getRootElement());
            if (schemaController instanceof MetadataSchemaController) {
                MetadataEditorFrame mdEditorFrame = new MetadataEditorFrame();
                mdEditorFrame.setDocument(file, doc, (MetadataSchemaController)schemaController);
                ReloadEditorDocumentHandler.launchEditor(mdEditorFrame);
            } else if (schemaController instanceof SCORM1_3SchemaController) {
                SCORM1_3PackageEditor scormEditorFrame = new SCORM1_3PackageEditor();
                scormEditorFrame.setDocument(file, doc, (SCORM1_3SchemaController)schemaController, version.equals(IMSDocumentHandler.ADLCP_130_4th));
                ReloadEditorDocumentHandler.launchEditor(scormEditorFrame);
            } else if (schemaController instanceof SCORM1_2SchemaController) {
                SCORM1_2PackageEditor scormEditorFrame = new SCORM1_2PackageEditor();
                scormEditorFrame.setDocument(file, doc, (SCORM1_2SchemaController)schemaController);
                ReloadEditorDocumentHandler.launchEditor(scormEditorFrame);
            } else if (schemaController instanceof ContentPackageSchemaController) {
                ContentPackageEditor cpEditorFrame = new ContentPackageEditor();
                cpEditorFrame.setDocument(file, doc, (ContentPackageSchemaController)schemaController);
                ReloadEditorDocumentHandler.launchEditor(cpEditorFrame);
            }
            ReloadEditorPrefs.getInstance().addFileToHistory(file);
        }
        catch (Exception ex) {
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            ErrorDialogBox.showWarning("Error opening file: " + file.getPath(), "Could not open file", ex);
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            ReloadEditor.getInstance().setCursor(ReloadUIManager.DEFAULT_CURSOR);
        }
    }

    private static boolean IsDocumentHealthcare(Element currentElement) {
        if (IMSDocumentHandler.HEALTHCARE_LOM_NAMESPACE_PREFIX.equals(currentElement.getNamespacePrefix())) {
            return true;
        }
        boolean isChildHC = false;
        for (Object obj : currentElement.getChildren()) {
            Element child = (Element)obj;
            isChildHC |= ReloadEditorDocumentHandler.IsDocumentHealthcare(child);
        }
        return isChildHC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataEditorFrame launchNewMetadataEditor(String version) {
        MetadataEditorFrame mdEditorFrame = null;
        try {
            ReloadEditor.getInstance().setCursor(ReloadUIManager.WAIT_CURSOR);
            mdEditorFrame = new MetadataEditorFrame();
            if (version.equals(IMSDocumentHandler.IMSMD_122)) {
                mdEditorFrame.newDocument(MetadataSchemaController.getDefaultSchemaController1_2());
            } else if (version.equals(IMSDocumentHandler.LOM_10)) {
                mdEditorFrame.newDocument(MetadataSchemaController.getDefaultSchemaController1_3());
            } else if (version.equals("lom_ADLR_10")) {
                mdEditorFrame = new MetadataEditorFrame(true);
                mdEditorFrame.newDocument(MetadataSchemaController.getDefaultSchemaController1_3());
            } else if (version.equals("lom_hc_10")) {
                mdEditorFrame.newDocument(MetadataSchemaController.getHealthCareSchemaController1_3());
            } else {
                mdEditorFrame = null;
                throw new ReloadEditorException("Unsupported Metadata Version");
            }
            ReloadEditorDocumentHandler.launchEditor(mdEditorFrame);
        }
        catch (Exception ex) {
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            if (mdEditorFrame != null) {
                mdEditorFrame.dispose();
            }
            ErrorDialogBox.showWarning("Error in New Metadata", "Could not create Metadata file", ex);
            mdEditorFrame = null;
            return mdEditorFrame;
        }
        finally {
            ReloadEditor.getInstance().setCursor(ReloadUIManager.DEFAULT_CURSOR);
            return mdEditorFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentPackageEditor launchNewContentPackageEditor() {
        ContentPackageEditor cpEditorFrame = null;
        try {
            File cpFolder = ReloadEditorDocumentHandler.askNewContentPackageFolder("Select Folder for New Content Package");
            if (cpFolder == null) {
                Object var2_3 = null;
                return var2_3;
            }
            ReloadEditor.getInstance().setCursor(ReloadUIManager.WAIT_CURSOR);
            cpEditorFrame = new ContentPackageEditor();
            cpEditorFrame.newContentPackage(cpFolder, IMSDocumentHandler.IMSMD_122);
            ReloadEditorDocumentHandler.launchEditor(cpEditorFrame);
            ReloadEditorPrefs.getInstance().addFileToHistory(cpEditorFrame.getContentPackage().getFile());
        }
        catch (Exception ex) {
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            if (cpEditorFrame != null) {
                cpEditorFrame.dispose();
            }
            ErrorDialogBox.showWarning("Error in New Content Package", "Could not create Content Package", ex);
            cpEditorFrame = null;
            return cpEditorFrame;
        }
        finally {
            ReloadEditor.getInstance().setCursor(ReloadUIManager.DEFAULT_CURSOR);
            return cpEditorFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SCORM1_2PackageEditor launchNewSCORM1_2PackageEditor() {
        ContentPackageEditor scormEditorFrame = null;
        try {
            File cpFolder = ReloadEditorDocumentHandler.askNewContentPackageFolder("Select Folder for new SCORM Package");
            if (cpFolder == null) {
                Object var2_3 = null;
                return var2_3;
            }
            ReloadEditor.getInstance().setCursor(ReloadUIManager.WAIT_CURSOR);
            scormEditorFrame = new SCORM1_2PackageEditor();
            ((SCORM1_2PackageEditor)scormEditorFrame).newContentPackage(cpFolder);
            ReloadEditorDocumentHandler.launchEditor(scormEditorFrame);
            ReloadEditorPrefs.getInstance().addFileToHistory(scormEditorFrame.getContentPackage().getFile());
        }
        catch (Exception ex) {
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            if (scormEditorFrame != null) {
                scormEditorFrame.dispose();
            }
            ErrorDialogBox.showWarning("Error in New SCORM 1.2 Package", "Could not create SCORM Package", ex);
            scormEditorFrame = null;
            return scormEditorFrame;
        }
        finally {
            ReloadEditor.getInstance().setCursor(ReloadUIManager.DEFAULT_CURSOR);
            return scormEditorFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SCORM1_3PackageEditor launchNewSCORM1_3PackageEditor(boolean fourthEdition) {
        ContentPackageEditor scormEditorFrame = null;
        try {
            File cpFolder = ReloadEditorDocumentHandler.askNewContentPackageFolder("Select Folder for New SCORM 2004 Package");
            if (cpFolder == null) {
                Object var3_4 = null;
                return var3_4;
            }
            ReloadEditor.getInstance().setCursor(ReloadUIManager.WAIT_CURSOR);
            scormEditorFrame = new SCORM1_3PackageEditor();
            ((SCORM1_3PackageEditor)scormEditorFrame).newContentPackage(cpFolder, fourthEdition);
            ReloadEditorDocumentHandler.launchEditor(scormEditorFrame);
            ReloadEditorPrefs.getInstance().addFileToHistory(scormEditorFrame.getContentPackage().getFile());
        }
        catch (Exception ex) {
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            if (scormEditorFrame != null) {
                scormEditorFrame.dispose();
            }
            ErrorDialogBox.showWarning("Error in New SCORM 2004 Package", "Could not create SCORM Package", ex);
            scormEditorFrame = null;
            return scormEditorFrame;
        }
        finally {
            ReloadEditor.getInstance().setCursor(ReloadUIManager.DEFAULT_CURSOR);
            return scormEditorFrame;
        }
    }

    protected static void launchEditor(final ReloadInternalFrame editorWindow) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReloadEditor.getInstance().addInternalFrame(editorWindow);
                editorWindow.show();
            }
        });
    }

    public static File askManifestFileOpen(Component parent) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().equalsIgnoreCase("imsmanifest.xml") || file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "XML or Archive Files";
            }
        };
        return ReloadUtils.askFileNameOpen(parent, "Open XML or Archive file", filter);
    }

    public static File unzipContentPackage(File zipFile, File targetFolder, ReloadProgressMonitor progressMonitor) throws ReloadEditorException {
        File manifestFile = null;
        try {
            boolean result = ZipUtils.unpackZip(zipFile, targetFolder, progressMonitor);
            if (!result) {
                File file = null;
                return file;
            }
            manifestFile = new File(targetFolder, "imsmanifest.xml");
            if (!manifestFile.exists()) {
                File file = null;
                return file;
            }
        }
        catch (Exception ex) {
            throw new ReloadEditorException(ex);
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
        }
        return manifestFile;
    }

    public static File askNewContentPackageFolder(String title) {
        ReloadFolderChooser chooser = new ReloadFolderChooser();
        chooser.setDialogTitle(title);
        int returnVal = chooser.showOpenDialog(ReloadEditor.getInstance());
        if (returnVal != 0) {
            return null;
        }
        File file = chooser.getSelectedFileAndStore();
        file.mkdirs();
        if (!file.exists() || !file.isDirectory()) {
            JOptionPane.showMessageDialog(ReloadEditor.getInstance(), "Folder doesn't exist", "New Content Package", 2);
            return null;
        }
        File imsManifest = new File(file, "imsmanifest.xml");
        if (imsManifest.exists()) {
            JOptionPane.showMessageDialog(ReloadEditor.getInstance(), "Folder already contains imsmanifest.xml", "New Content Package", 2);
            return null;
        }
        return file;
    }

    protected static void showWarningMessage(String msg) {
        JOptionPane.showMessageDialog(ReloadEditor.getInstance(), msg, "Reload Editor", 2);
    }
}

