/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor;

import java.io.File;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadHelperProfile;
import uk.ac.reload.editor.contentpackaging.ContentPackageSchemaController;
import uk.ac.reload.editor.contentpackaging.SCORM1_2SchemaController;
import uk.ac.reload.editor.contentpackaging.SCORM1_3SchemaController;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingSchemaController;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaController;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;
import uk.ac.reload.moonunit.schema.ReloadSchemaException;

public abstract class ReloadEditorSchemaController
extends ReloadSchemaController {
    protected ReloadHelperProfile _helperProfile;
    protected ReloadHelperProfile _shortFormHelperProfileSCORM2004;
    protected ReloadHelperProfile _healthCareHelperProfileSCORM2004;

    public ReloadEditorSchemaController() {
    }

    public ReloadEditorSchemaController(File fileSchema, File fileHelper, File fileVocab) {
        this.loadSchema(fileSchema);
        this.loadSchemaHelper(fileHelper);
        this.loadVocab(fileVocab);
    }

    public ReloadEditorSchemaController(File fileSchema, ReloadHelperProfile profile) {
        this.loadSchema(fileSchema);
        this.setHelperProfile(profile);
    }

    public void setHelperProfiles(ReloadHelperProfile profile, ReloadHelperProfile SCORM2004profile) {
        this.loadSchemaHelper(profile.getSchemaHelperFile());
        this.loadVocab(profile.getVocabFile());
        this._helperProfile = profile;
        this._shortFormHelperProfileSCORM2004 = SCORM2004profile;
    }

    public void setHelperProfile(ReloadHelperProfile profile) {
        this.loadSchemaHelper(profile.getSchemaHelperFile());
        this.loadVocab(profile.getVocabFile());
        this._helperProfile = profile;
    }

    @Override
    public void loadSchema(File fileSchema) {
        try {
            super.loadSchema(fileSchema);
        }
        catch (ReloadSchemaException ex) {
            ErrorDialogBox.showWarning("Could not load Schema: ", "Load Schema", ex);
        }
    }

    @Override
    public void loadSchemaHelper(File fileHelper) {
        try {
            super.loadSchemaHelper(fileHelper);
        }
        catch (ReloadSchemaException ex) {
            ErrorDialogBox.showWarning("Could not load Schema Helper: ", "Load SchemaHelper", ex);
        }
    }

    @Override
    public void loadVocab(File fileVocab) {
        try {
            super.loadVocab(fileVocab);
        }
        catch (ReloadSchemaException ex) {
            ErrorDialogBox.showWarning("Could not load Vocabulary: ", "Load Schema", ex);
        }
    }

    public static ReloadSchemaController getReloadSchemaController(Document doc, Namespace ns) {
        ns = IMSDocumentHandler.correctAdditionalNamespace(doc, ns);
        String version = IMSDocumentHandler.getSchemaVersionFromNamespace(ns);
        return ReloadEditorSchemaController.getReloadSchemaController(version);
    }

    public static ReloadSchemaController getReloadSchemaController(String schemaVersion) {
        ReloadEditorSchemaController schemaController = null;
        if (schemaVersion != null) {
            if (schemaVersion.equals(IMSDocumentHandler.IMSMD_110)) {
                ReloadEditorSchemaController.showWarningMessage("This is Metadata version 1.1.  Will use version 1.2.2 Schema model.");
                return ReloadEditorSchemaController.getReloadSchemaController(IMSDocumentHandler.IMSMD_122);
            }
            if (schemaVersion.equals(IMSDocumentHandler.IMSMD_120)) {
                ReloadEditorSchemaController.showWarningMessage("This is Metadata version 1.2.  Will use version 1.2.2 Schema model.");
                return ReloadEditorSchemaController.getReloadSchemaController(IMSDocumentHandler.IMSMD_122);
            }
            if (schemaVersion.equals(IMSDocumentHandler.IMSMD_121)) {
                schemaController = new MetadataSchemaController(ReloadEditorDocumentHandler.fileSchemaMD1_2_1, IMSDocumentHandler.IMSMD_121);
            } else if (schemaVersion.equals(IMSDocumentHandler.IMSMD_122)) {
                schemaController = new MetadataSchemaController(ReloadEditorDocumentHandler.fileSchemaMD1_2_2, IMSDocumentHandler.IMSMD_122);
            } else if (schemaVersion.equals(IMSDocumentHandler.LOM_10)) {
                schemaController = new MetadataSchemaController(ReloadEditorDocumentHandler.fileSchemaLOM1_0, IMSDocumentHandler.LOM_10);
            } else if (schemaVersion.equals("lom_hc_10")) {
                schemaController = new MetadataSchemaController(ReloadEditorDocumentHandler.fileSchemaLOM1_0_HealthCare, "lom_hc_10");
            } else {
                if (schemaVersion.equals(IMSDocumentHandler.IMSCP_111)) {
                    ReloadEditorSchemaController.showWarningMessage("This is Content Packaging version 1.1.  Will use version 1.1.3 Schema model.");
                    return ReloadEditorSchemaController.getReloadSchemaController(IMSDocumentHandler.IMSCP_113);
                }
                if (schemaVersion.equals(IMSDocumentHandler.IMSCP_112)) {
                    schemaController = new ContentPackageSchemaController(ReloadEditorDocumentHandler.fileSchemaCP1_1_2);
                } else if (schemaVersion.equals(IMSDocumentHandler.IMSCP_113)) {
                    schemaController = new ContentPackageSchemaController(ReloadEditorDocumentHandler.fileSchemaCP1_1_3);
                } else if (schemaVersion.equals(IMSDocumentHandler.ADLCP_120_112)) {
                    schemaController = new SCORM1_2SchemaController(ReloadEditorDocumentHandler.fileSchemaSCORM1_2_IMCP1_1_2);
                } else if (schemaVersion.equals(IMSDocumentHandler.ADLCP_120_113)) {
                    schemaController = new SCORM1_2SchemaController(ReloadEditorDocumentHandler.fileSchemaSCORM1_2_IMCP1_1_3);
                } else if (schemaVersion.equals(IMSDocumentHandler.ADLCP_130_4th)) {
                    schemaController = new SCORM1_3SchemaController(ReloadEditorDocumentHandler.fileSchemaSCORM1_3_0_4TH, true);
                } else if (schemaVersion.equals(IMSDocumentHandler.ADLCP_130_3RD)) {
                    schemaController = new SCORM1_3SchemaController(ReloadEditorDocumentHandler.fileSchemaSCORM1_3_0_3RD, false);
                } else if (schemaVersion.equals(IMSDocumentHandler.IMSSS_100)) {
                    schemaController = new SimpleSequencingSchemaController(ReloadEditorDocumentHandler.fileSchemaSS1_0, ReloadEditorDocumentHandler.fileHelperSS, ReloadEditorDocumentHandler.fileVocabSS);
                }
            }
        }
        return schemaController;
    }

    protected static void showWarningMessage(String msg) {
        JOptionPane.showMessageDialog(ReloadEditor.getInstance(), msg, "Reload Editor", 2);
    }

    public ReloadHelperProfile getReloadHelperProfile() {
        return this._helperProfile;
    }

    public ReloadHelperProfile getReloadSCORM2004HelperProfile() {
        return this._shortFormHelperProfileSCORM2004;
    }

    public abstract Icon getLeafIcon(Element var1);

    public abstract Icon getClosedIcon(Element var1);

    public abstract Icon getOpenIcon(Element var1);

    public abstract Icon getLeafIcon(ReloadSchemaElement var1);

    public abstract Icon getClosedIcon(ReloadSchemaElement var1);

    public abstract Icon getOpenIcon(ReloadSchemaElement var1);
}

