/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class ReloadFileType {
    public static final String UNKNOWN_TEXT = "Unknown File Type";
    public static final String WEBPAGE_TEXT = "HTML Document";
    public static final String CSS_TEXT = "Cascading Style Sheet";
    public static final String IMAGE_TEXT = "Compressed Web Image";
    public static final String JAVASCRIPT_TEXT = "Javascript Source File";
    public static final String MSWORD_TEXT = "Microsoft Word Document";
    public static final String MSEXCEL_TEXT = "Microsoft Excel Document";
    public static final String MSPOWERPOINT_TEXT = "Microsoft Powerpoint Document";
    public static final String MSACCESS_TEXT = "Microsoft Access Document";
    public static final String ASP_TEXT = "Active Server Page";
    public static final String JSP_TEXT = "Java Server Page";
    public static final String PHP_TEXT = "Personal Home Page Document";
    public static final String COLDFUSION_TEXT = "Cold Fusion Document";
    public static final String TEXTFILE_TEXT = "Text Document";
    public static final String AUDIOVIDEOMEDIA_TEXT = "Multimedia File";
    public static final String FLASH_TEXT = "Macromedia Flash File";
    public static final String SHOCKWAVE_TEXT = "Macromedia Shockwave File";
    public static final String JAVAAPPLET_TEXT = "Sun Java File";
    public static final String PDF_TEXT = "Adobe Acrobat Document";
    public static final String ARCHIVE_TEXT = "Compressed File Archive";
    public static final int UNKNOWN = 0;
    public static final int WEBPAGE = 1;
    public static final int CSS = 2;
    public static final int IMAGE = 3;
    public static final int JAVASCRIPT = 4;
    public static final int MSWORD = 5;
    public static final int MSEXCEL = 6;
    public static final int MSPOWERPOINT = 7;
    public static final int MSACCESS = 8;
    public static final int ASP = 9;
    public static final int JSP = 10;
    public static final int PHP = 11;
    public static final int COLDFUSION = 12;
    public static final int TEXTFILE = 13;
    public static final int AUDIOVIDEOMEDIA = 14;
    public static final int FLASH = 15;
    public static final int SHOCKWAVE = 16;
    public static final int JAVAAPPLET = 17;
    public static final int PDF = 18;
    public static final int ARCHIVE = 19;
    public static final List WEB_PAGE_EXTENSIONS;
    public static final List ASP_EXTENSIONS;
    public static final List JSP_EXTENSIONS;
    public static final List COLDFUSION_EXTENSIONS;
    public static final List PHP_EXTENSIONS;
    public static final List SERVERTECHNOLOGY_EXTENSIONS;
    public static final List IMAGEFILE_EXTENSIONS;
    public static final List STYLESHEET_EXTENSIONS;
    public static final List JAVAAPPLET_EXTENSIONS;
    public static final List MSWORD_EXTENSIONS;
    public static final List MSEXCEL_EXTENSIONS;
    public static final List MSACCESS_EXTENSIONS;
    public static final List MSPOWERPOINT_EXTENSIONS;
    public static final List TEXT_EXTENSIONS;
    public static final List JAVASCRIPT_EXTENSIONS;
    public static final List SHOCKWAVE_EXTENSIONS;
    public static final List FLASH_EXTENSIONS;
    public static final List AUDIOVIDEOMEDIA_EXTENSIONS;
    public static final List PDF_EXTENSIONS;
    public static final List ARCHIVE_EXTENSIONS;
    public static final List EXTENSIONS_TO_PARSE;
    public static final List ALL_EXTENSIONS;
    public static final List JAVASCRIPTEVENTS;

    public static boolean findExtension(List aList, String theResource) {
        Iterator listElement = aList.iterator();
        while (listElement.hasNext()) {
            if (!theResource.toLowerCase().endsWith(listElement.next().toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isParseableFile(File aFile) {
        Iterator listElement = EXTENSIONS_TO_PARSE.iterator();
        while (listElement.hasNext()) {
            if (!aFile.toString().endsWith(listElement.next().toString())) continue;
            return true;
        }
        return false;
    }

    public static int getFileType(String theResource) {
        if (ReloadFileType.findExtension(WEB_PAGE_EXTENSIONS, theResource)) {
            return 1;
        }
        if (ReloadFileType.findExtension(IMAGEFILE_EXTENSIONS, theResource)) {
            return 3;
        }
        if (ReloadFileType.findExtension(ASP_EXTENSIONS, theResource)) {
            return 9;
        }
        if (ReloadFileType.findExtension(JSP_EXTENSIONS, theResource)) {
            return 10;
        }
        if (ReloadFileType.findExtension(PHP_EXTENSIONS, theResource)) {
            return 11;
        }
        if (ReloadFileType.findExtension(COLDFUSION_EXTENSIONS, theResource)) {
            return 12;
        }
        if (ReloadFileType.findExtension(MSWORD_EXTENSIONS, theResource)) {
            return 5;
        }
        if (ReloadFileType.findExtension(MSACCESS_EXTENSIONS, theResource)) {
            return 8;
        }
        if (ReloadFileType.findExtension(MSEXCEL_EXTENSIONS, theResource)) {
            return 6;
        }
        if (ReloadFileType.findExtension(MSPOWERPOINT_EXTENSIONS, theResource)) {
            return 7;
        }
        if (ReloadFileType.findExtension(STYLESHEET_EXTENSIONS, theResource)) {
            return 2;
        }
        if (ReloadFileType.findExtension(JAVAAPPLET_EXTENSIONS, theResource)) {
            return 17;
        }
        if (ReloadFileType.findExtension(TEXT_EXTENSIONS, theResource)) {
            return 13;
        }
        if (ReloadFileType.findExtension(SHOCKWAVE_EXTENSIONS, theResource)) {
            return 16;
        }
        if (ReloadFileType.findExtension(FLASH_EXTENSIONS, theResource)) {
            return 15;
        }
        if (ReloadFileType.findExtension(AUDIOVIDEOMEDIA_EXTENSIONS, theResource)) {
            return 14;
        }
        if (ReloadFileType.findExtension(PDF_EXTENSIONS, theResource)) {
            return 18;
        }
        if (ReloadFileType.findExtension(JAVASCRIPT_EXTENSIONS, theResource)) {
            return 4;
        }
        if (ReloadFileType.findExtension(ARCHIVE_EXTENSIONS, theResource)) {
            return 19;
        }
        return 0;
    }

    static {
        ArrayList<String> _audio = new ArrayList<String>();
        _audio.add(".aif");
        _audio.add(".aiff");
        _audio.add(".au");
        _audio.add(".mov");
        _audio.add(".mp2");
        _audio.add(".mp3");
        _audio.add(".mpg");
        _audio.add(".mpeg");
        _audio.add(".ra");
        _audio.add(".ram");
        _audio.add(".wav");
        AUDIOVIDEOMEDIA_EXTENSIONS = Collections.unmodifiableList(_audio);
        ArrayList<String> _shockwave = new ArrayList<String>();
        _shockwave.add(".dcr");
        SHOCKWAVE_EXTENSIONS = Collections.unmodifiableList(_shockwave);
        ArrayList<String> _archivers = new ArrayList<String>();
        _archivers.add(".zip");
        _archivers.add(".ace");
        _archivers.add(".rar");
        _archivers.add(".tar");
        ARCHIVE_EXTENSIONS = Collections.unmodifiableList(_archivers);
        ArrayList<String> _flash = new ArrayList<String>();
        _flash.add(".swf");
        FLASH_EXTENSIONS = Collections.unmodifiableList(_flash);
        ArrayList<String> _pdf = new ArrayList<String>();
        _pdf.add(".pdf");
        PDF_EXTENSIONS = Collections.unmodifiableList(_pdf);
        ArrayList<String> _javascript = new ArrayList<String>();
        _javascript.add(".js");
        JAVASCRIPT_EXTENSIONS = Collections.unmodifiableList(_javascript);
        ArrayList<String> _text = new ArrayList<String>();
        _text.add(".txt");
        TEXT_EXTENSIONS = Collections.unmodifiableList(_text);
        ArrayList<String> _mspowerpoint = new ArrayList<String>();
        _mspowerpoint.add(".ppt");
        _mspowerpoint.add(".pps");
        MSPOWERPOINT_EXTENSIONS = Collections.unmodifiableList(_mspowerpoint);
        ArrayList<String> _msaccess = new ArrayList<String>();
        _msaccess.add(".mdb");
        MSACCESS_EXTENSIONS = Collections.unmodifiableList(_msaccess);
        ArrayList<String> _msexcel = new ArrayList<String>();
        _msexcel.add(".xls");
        _msexcel.add(".csv");
        MSEXCEL_EXTENSIONS = Collections.unmodifiableList(_msexcel);
        ArrayList<String> _msword = new ArrayList<String>();
        _msword.add(".doc");
        _msword.add(".dot");
        _msword.add(".rtf");
        MSWORD_EXTENSIONS = Collections.unmodifiableList(_msword);
        ArrayList<String> _applets = new ArrayList<String>();
        _applets.add(".class");
        _applets.add(".java");
        JAVAAPPLET_EXTENSIONS = Collections.unmodifiableList(_applets);
        ArrayList<String> _stylesheets = new ArrayList<String>();
        _stylesheets.add(".css");
        STYLESHEET_EXTENSIONS = Collections.unmodifiableList(_stylesheets);
        ArrayList<String> _webimages = new ArrayList<String>();
        _webimages.add(".gif");
        _webimages.add(".jpg");
        _webimages.add(".jpeg");
        _webimages.add(".png");
        IMAGEFILE_EXTENSIONS = Collections.unmodifiableList(_webimages);
        ArrayList<String> _webpages = new ArrayList<String>();
        _webpages.add(".htm");
        _webpages.add(".html");
        _webpages.add(".shtml");
        _webpages.add(".shtm");
        WEB_PAGE_EXTENSIONS = Collections.unmodifiableList(_webpages);
        ArrayList<String> _asp = new ArrayList<String>();
        _asp.add(".asp");
        _asp.add(".aspx");
        _asp.add(".asa");
        ASP_EXTENSIONS = Collections.unmodifiableList(_asp);
        ArrayList<String> _jsp = new ArrayList<String>();
        _jsp.add(".jsp");
        JSP_EXTENSIONS = Collections.unmodifiableList(_jsp);
        ArrayList<String> _php = new ArrayList<String>();
        _php.add(".php");
        _php.add(".php3");
        _php.add(".php4");
        PHP_EXTENSIONS = Collections.unmodifiableList(_php);
        ArrayList<String> _coldfusion = new ArrayList<String>();
        _coldfusion.add(".cfm");
        COLDFUSION_EXTENSIONS = Collections.unmodifiableList(_coldfusion);
        ArrayList _servertechnologies = new ArrayList();
        _servertechnologies.addAll(ASP_EXTENSIONS);
        _servertechnologies.addAll(JSP_EXTENSIONS);
        _servertechnologies.addAll(COLDFUSION_EXTENSIONS);
        _servertechnologies.addAll(PHP_EXTENSIONS);
        SERVERTECHNOLOGY_EXTENSIONS = Collections.unmodifiableList(_servertechnologies);
        ArrayList _parseextensions = new ArrayList();
        _parseextensions.addAll(WEB_PAGE_EXTENSIONS);
        _parseextensions.addAll(SERVERTECHNOLOGY_EXTENSIONS);
        _parseextensions.addAll(STYLESHEET_EXTENSIONS);
        _parseextensions.addAll(JAVASCRIPT_EXTENSIONS);
        EXTENSIONS_TO_PARSE = Collections.unmodifiableList(_parseextensions);
        ArrayList _allextensions = new ArrayList();
        _allextensions.addAll(ARCHIVE_EXTENSIONS);
        _allextensions.addAll(AUDIOVIDEOMEDIA_EXTENSIONS);
        _allextensions.addAll(SHOCKWAVE_EXTENSIONS);
        _allextensions.addAll(FLASH_EXTENSIONS);
        _allextensions.addAll(PDF_EXTENSIONS);
        _allextensions.addAll(TEXT_EXTENSIONS);
        _allextensions.addAll(MSWORD_EXTENSIONS);
        _allextensions.addAll(MSEXCEL_EXTENSIONS);
        _allextensions.addAll(MSACCESS_EXTENSIONS);
        _allextensions.addAll(MSPOWERPOINT_EXTENSIONS);
        _allextensions.addAll(JAVAAPPLET_EXTENSIONS);
        _allextensions.addAll(IMAGEFILE_EXTENSIONS);
        _allextensions.addAll(EXTENSIONS_TO_PARSE);
        ALL_EXTENSIONS = Collections.unmodifiableList(_allextensions);
        ArrayList<String> _javascriptEvents = new ArrayList<String>();
        _javascriptEvents.add("onload");
        _javascriptEvents.add("onclick");
        _javascriptEvents.add("ondblclick");
        _javascriptEvents.add("onkeydown");
        _javascriptEvents.add("onkeypress");
        _javascriptEvents.add("onkeyup");
        _javascriptEvents.add("onmousedown");
        _javascriptEvents.add("onmouseover");
        _javascriptEvents.add("onmouseout");
        JAVASCRIPTEVENTS = Collections.unmodifiableList(_javascriptEvents);
    }
}

