/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor;

import java.io.File;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilXMLException;
import uk.ac.reload.dweezil.util.XMLUtils;
import uk.ac.reload.editor.ReloadEditorException;

public abstract class ReloadHelperProfile {
    protected Document _docProfile;
    protected File _fileProfile;

    public ReloadHelperProfile() {
    }

    public ReloadHelperProfile(File fileProfile) throws ReloadEditorException {
        if (fileProfile == null) {
            throw new ReloadEditorException("Profile file cannot be null");
        }
        this._fileProfile = fileProfile;
        try {
            this._docProfile = this.loadProfile(this._fileProfile);
        }
        catch (DweezilXMLException ex) {
            throw new ReloadEditorException(ex);
        }
    }

    protected Document loadProfile(File fileProfile) throws DweezilXMLException {
        return XMLUtils.readXMLFile(fileProfile);
    }

    public abstract File getVocabFile();

    public abstract File getSchemaHelperFile();

    public String getProfileName() {
        return this.getRootAttributeValue("name");
    }

    public File getFile() {
        return this._fileProfile;
    }

    public String getVocabularyFileName() {
        return this.getRootAttributeValue("vocabfile");
    }

    public String getSchemaHelperFileName() {
        return this.getRootAttributeValue("schemahelperfile");
    }

    protected String getRootAttributeValue(String attName) {
        if (this._docProfile != null && this._docProfile.hasRootElement()) {
            Element root = this._docProfile.getRootElement();
            Attribute att = root.getAttribute(attName);
            return att == null ? null : att.getValue();
        }
        return null;
    }

    public String toString() {
        return this.getProfileName();
    }
}

