/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.diva.util.GeneralUtils;
import uk.ac.reload.diva.util.IProgressMonitor;
import uk.ac.reload.dweezil.gui.DweezilFolderChooser;
import uk.ac.reload.dweezil.gui.DweezilProgressMonitor;
import uk.ac.reload.dweezil.util.NativeLauncher;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.contentpackaging.ContentPackage;

public class CP_Viewer {
    private ContentPackage _contentPackage;
    private int _orgCount = -1;
    private int _itemCount = -1;
    private String _defaultOrganization;
    private File previewFolder = null;

    public CP_Viewer(ContentPackage cp) {
        this._contentPackage = cp;
    }

    public void launch() throws IOException {
        String[] javascriptStrings = this.parse(false);
        this.writeItemsToFile(javascriptStrings, this.getNavigationFile());
        NativeLauncher.launchFile(this.getPreviewFile());
    }

    protected String[] parse(boolean useRelativePaths) {
        Vector v = new Vector();
        Element manifestRoot = (Element)this._contentPackage.getRootElement().clone();
        Element orgs = manifestRoot.getChild("organizations", manifestRoot.getNamespace());
        if (orgs.getAttributeValue("default") != null) {
            this._defaultOrganization = orgs.getAttributeValue("default");
        }
        this.writePackageSettings(v, "packageName", this._contentPackage.getProjectName());
        this.createNavLinks(v, manifestRoot, "menu", useRelativePaths);
        Object[] javascriptStrings = new String[v.size()];
        v.copyInto(javascriptStrings);
        return javascriptStrings;
    }

    protected void writeItemsToFile(String[] javascriptStrings, File navigationFile) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(navigationFile));
        for (int i = 0; i < javascriptStrings.length; ++i) {
            out.write(javascriptStrings[i] + System.getProperty("line.separator"));
        }
        out.flush();
        out.close();
    }

    public File getPreviewFolder() {
        if (this.previewFolder == null) {
            this.previewFolder = new File(System.getProperty("user.dir"), "preview");
        }
        return this.previewFolder;
    }

    public File getPreviewFile() {
        return new File(this.getPreviewFolder(), "ReloadContentPreview.htm");
    }

    public File getNavigationFile() {
        return new File(this.getPreviewFolder(), "ReloadContentPreviewFiles/CPOrgs.js");
    }

    protected void createNavLinks(Vector javascriptStrings, Element element, String menuParent, boolean useRelativePaths) {
        String name = element.getName();
        if (name.equals("organization") && this._contentPackage.isDocumentNamespace(element)) {
            this._itemCount = -1;
            ++this._orgCount;
            String orgId = element.getAttributeValue("identifier");
            menuParent = "menu";
            String title = "Organization";
            Element titleElement = element.getChild("title", element.getNamespace());
            if (titleElement != null && !titleElement.getText().equals("")) {
                title = titleElement.getText();
            }
            if (this._defaultOrganization != null && this._defaultOrganization.equals(orgId)) {
                this.writePackageSettings(javascriptStrings, "_defaultOrg", this._orgCount);
            }
            this.writeOrganization(javascriptStrings, title, orgId);
        } else if (name.equals("item") && this._contentPackage.isDocumentNamespace(element)) {
            Element ref_element;
            String isVisibleAttrib;
            ++this._itemCount;
            String itemId = element.getAttributeValue("identifier");
            String hyperLink = "";
            String title = "Item";
            Element titleElement = element.getChild("title", element.getNamespace());
            if (titleElement != null && !titleElement.getText().equals("")) {
                title = titleElement.getText();
            }
            if ((isVisibleAttrib = "true") != null && isVisibleAttrib.equals("false")) {
                title = "* hidden";
            }
            if ((ref_element = this._contentPackage.getReferencedElement(element)) != null) {
                String ref_name = ref_element.getName();
                if (ref_name.equals("resource")) {
                    String url;
                    if (useRelativePaths) {
                        url = this._contentPackage.getElementHREF(element);
                        if (!GeneralUtils.isExternalURL(url)) {
                            url = "../" + url;
                        }
                    } else {
                        File currentFile = new File(this._contentPackage.getProjectFolder(), this._contentPackage.getElementHREF(element));
                        url = "file://" + currentFile.getAbsolutePath();
                        url = this.escapeBackslashes(url);
                    }
                    if (url != null) {
                        hyperLink = url;
                    }
                } else if (ref_name.equals("manifest")) {
                    Element orgsElement = ref_element.getChild("organizations", ref_element.getNamespace());
                    if (orgsElement != null) {
                        ref_element = this._contentPackage.getDefaultOrganization(orgsElement);
                    }
                    if (ref_element != null) {
                        for (Element ref_child : ref_element.getChildren()) {
                            element.addContent((Element)ref_child.clone());
                        }
                    }
                }
            } else {
                hyperLink = "javascript:void(0)";
            }
            this.writeItem(javascriptStrings, title, hyperLink, itemId, menuParent);
            menuParent = itemId;
        }
        for (Element child : element.getChildren()) {
            this.createNavLinks(javascriptStrings, child, menuParent, useRelativePaths);
        }
    }

    protected void writePackageSettings(Vector javascriptStrings, String name, String value) {
        javascriptStrings.add("CPAPI." + name + " = \"" + value + "\";");
    }

    protected void writePackageSettings(Vector javascriptStrings, String name, int value) {
        javascriptStrings.add("CPAPI." + name + " = " + value + ";");
    }

    protected void writeOrganization(Vector javascriptStrings, String title, String orgId) {
        javascriptStrings.add("CPAPI.orgArray(" + this._orgCount + ").organizationName = \"" + this.escapeQuotes(title) + "\";");
        javascriptStrings.add("CPAPI.orgArray(" + this._orgCount + ").organizationIdentifier = \"" + orgId + "\";");
    }

    protected void writeItem(Vector javascriptStrings, String title, String url, String itemId, String parentMenu) {
        parentMenu = parentMenu.replace('-', '_');
        javascriptStrings.add("CPAPI.orgArray(" + this._orgCount + ").itemArray(" + this._itemCount + ").itemTitle = \"" + this.escapeQuotes(title) + "\";");
        javascriptStrings.add("CPAPI.orgArray(" + this._orgCount + ").itemArray(" + this._itemCount + ").itemIdentifier = \"" + itemId + "\";");
        javascriptStrings.add("CPAPI.orgArray(" + this._orgCount + ").itemArray(" + this._itemCount + ").itemParent = \"" + parentMenu + "\";");
        javascriptStrings.add("CPAPI.orgArray(" + this._orgCount + ").itemArray(" + this._itemCount + ").itemHyper = \"" + url + "\";");
    }

    protected String escapeQuotes(String inputString) {
        inputString = inputString.replaceAll("'", "\\\\\\\\'");
        inputString = inputString.replaceAll("\"", "\\\\\"");
        return inputString;
    }

    protected String escapeBackslashes(String inputString) {
        inputString = inputString.replaceAll("\\\\", "\\\\\\\\");
        return inputString;
    }

    public File askExportFolder() {
        DweezilFolderChooser chooser = new DweezilFolderChooser();
        int returnVal = chooser.showOpenDialog(ReloadEditor.getInstance());
        if (returnVal != 0) {
            return null;
        }
        File file = chooser.getSelectedFileAndStore();
        file.mkdirs();
        return file;
    }

    public void exportContentPackage(File exportFolder, DweezilProgressMonitor progressMonitor) throws IOException {
        boolean ok;
        for (File dest = exportFolder.getParentFile(); dest != null; dest = dest.getParentFile()) {
            if (!dest.equals(this._contentPackage.getProjectFolder()) || progressMonitor == null) continue;
            progressMonitor.close();
        }
        String[] javascriptStrings = this.parse(true);
        if (!exportFolder.equals(this._contentPackage.getProjectFolder()) && !(ok = this.copyResourceFiles(this._contentPackage, exportFolder, progressMonitor))) {
            return;
        }
        File previewHomeFolder = this.getPreviewFolder();
        this.copyPreviewFiles(previewHomeFolder, exportFolder);
        File targetNavFile = new File(exportFolder, "ReloadContentPreviewFiles/CPOrgs.js");
        this.writeItemsToFile(javascriptStrings, targetNavFile);
    }

    public void exportContentPackage(File exportFolder) throws IOException {
        this.exportContentPackage(exportFolder, null);
    }

    protected boolean copyResourceFiles(ContentPackage cp, File exportFolder, IProgressMonitor progressMonitor) throws IOException {
        if (exportFolder.equals(this._contentPackage.getProjectFolder())) {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            return false;
        }
        boolean result = FileUtils.copyFolder(cp.getProjectFolder(), exportFolder, progressMonitor);
        File manifest = new File(exportFolder, "manifest");
        manifest.delete();
        return result;
    }

    protected void copyPreviewFiles(File previewHomeFolder, File exportFolder) throws IOException {
        FileUtils.copyFolder(previewHomeFolder, exportFolder);
    }
}

