/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.util.DweezilXMLException;
import uk.ac.reload.dweezil.util.RandomGUID;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.dweezil.util.XMLUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.ReloadFileType;
import uk.ac.reload.editor.contentpackaging.ContentPackageSchemaController;
import uk.ac.reload.editor.contentpackaging.ReloadResource;
import uk.ac.reload.editor.contentpackaging.SCORM1_3Package;
import uk.ac.reload.editor.contentpackaging.htmlparser.HTMLParser;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.dom.DomPath;
import uk.ac.reload.moonunit.dom.ReloadDocumentClipboard;
import uk.ac.reload.moonunit.dom.ReloadDocumentListenerEvent;
import uk.ac.reload.moonunit.dom.ReloadDomException;
import uk.ac.reload.moonunit.dom.ReloadSchemaDocument;
import uk.ac.reload.moonunit.dom.contentpackaging.AbstractContentPackage;
import uk.ac.reload.moonunit.dom.contentpackaging.ContentPackageCore;
import uk.ac.reload.moonunit.schema.ReloadSchema;
import uk.ac.reload.moonunit.schema.ReloadSchemaAttribute;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class ContentPackage
extends ReloadSchemaDocument
implements AbstractContentPackage {
    protected ContentPackageCore _cpCore = new ContentPackageCore(this);
    protected Element lastResourceElementAdded = null;
    static final String[] cp_comments = new String[]{"This is a Reload version " + ReloadEditor.VERSION + " Content Package document", "Spawned from the Reload Content Package Generator - http://www.reload.ac.uk"};

    public ContentPackage() {
    }

    public ContentPackage(File file, Document doc, ContentPackageSchemaController schemaController) {
        super(file, doc, schemaController);
    }

    public void newContentPackage(File projectFolder, ContentPackageSchemaController cpController, MetadataSchemaController mdController, String metadataVersion) throws ReloadEditorException {
        this.newDocument(projectFolder, cpController, mdController, metadataVersion);
        try {
            this.saveDocument();
        }
        catch (ReloadDomException ex) {
            throw new ReloadEditorException(ex);
        }
        this.setDirty(false);
        cpController.copySchemaFilesToFolder(projectFolder);
    }

    protected void newDocument(File projectFolder, ContentPackageSchemaController cpController, MetadataSchemaController mdController, String metadataVersion) throws ReloadEditorException {
        this.setReloadSchemaController(cpController);
        this._doc = new Document();
        this.addComments(this._doc);
        ReloadSchema cpSchema = cpController.getReloadSchema();
        Element root = this.addElementBySchema(this, null, cpSchema.getRootElement(), false);
        this._doc.setRootElement(root);
        ReloadSchema mdSchema = mdController.getReloadSchema();
        Namespace mdNamespace = null;
        mdNamespace = metadataVersion == IMSDocumentHandler.LOM_10 ? Namespace.getNamespace(IMSDocumentHandler.LOM_NAMESPACE_PREFIX, mdSchema.getTargetNamespace()) : Namespace.getNamespace(IMSDocumentHandler.IMSMD_NAMESPACE_PREFIX, mdSchema.getTargetNamespace());
        root.addNamespaceDeclaration(mdNamespace);
        root.addNamespaceDeclaration(IMSDocumentHandler.XSI_Namespace);
        root.setAttribute("identifier", RandomGUID.getUniqueID("MANIFEST-"));
        StringBuffer schemaLocationURI = new StringBuffer();
        schemaLocationURI.append(cpSchema.getTargetNamespace());
        schemaLocationURI.append(" ");
        schemaLocationURI.append(cpSchema.getSchemaName());
        schemaLocationURI.append(" ");
        schemaLocationURI.append(mdSchema.getTargetNamespace());
        schemaLocationURI.append(" ");
        schemaLocationURI.append(mdSchema.getSchemaName());
        root.setAttribute(IMSDocumentHandler.XSI_SchemaLocation, schemaLocationURI.toString(), IMSDocumentHandler.XSI_Namespace);
        this._file = new File(projectFolder, "imsmanifest.xml");
    }

    @Override
    public String[] getComments() {
        return cp_comments;
    }

    public Element importManifest(File manifestFile, Element manifestElement, String base) throws ReloadEditorException {
        Element importedRootElement = null;
        Document importedDoc = null;
        try {
            importedDoc = XMLUtils.readXMLFile(manifestFile);
        }
        catch (DweezilXMLException ex) {
            throw new ReloadEditorException(ex);
        }
        if (importedDoc != null) {
            String rootTarget;
            importedRootElement = (Element)importedDoc.getRootElement().detach();
            String rootSource = importedRootElement.getName();
            if (!rootSource.equals(rootTarget = this.getTargetRootElementName())) {
                throw new ReloadEditorException("Not a valid Manifest file");
            }
            Namespace ns2 = importedRootElement.getNamespace();
            if (ns2 != null) {
                IMSDocumentHandler.replaceNamespaces(importedRootElement, ns2, this.getSchemaNamespace());
            }
            importedRootElement.removeAttribute(IMSDocumentHandler.XSI_SchemaLocation, IMSDocumentHandler.XSI_Namespace);
            importedRootElement.removeAttribute(IMSDocumentHandler.XSI_SchemaLocation, IMSDocumentHandler.XSI_NamespaceOLD);
            importedRootElement.removeNamespaceDeclaration(IMSDocumentHandler.XSI_Namespace);
            importedRootElement.removeNamespaceDeclaration(IMSDocumentHandler.XSI_NamespaceOLD);
            Vector<Namespace> v = new Vector<Namespace>();
            Iterator it = importedRootElement.getAdditionalNamespaces().listIterator();
            while (it.hasNext()) {
                ns2 = (Namespace)it.next();
                v.add(ns2);
            }
            for (Namespace ns2 : v) {
                importedRootElement.removeNamespaceDeclaration(ns2);
                Namespace ns22 = this.getRootElement().getNamespace(ns2.getPrefix());
                if (ns22 != null) continue;
                this.getRootElement().addNamespaceDeclaration(ns2);
            }
            Hashtable idmap = this.createNewIDs(importedRootElement);
            this.createNewIDRefs(importedRootElement, idmap);
            this.createNewPrerequisiteRefs(importedRootElement, idmap);
            importedRootElement.setAttribute("base", base + "/", Namespace.XML_NAMESPACE);
            this.addElementUndoable(this, manifestElement, importedRootElement, false);
        }
        return importedRootElement;
    }

    protected void createNewPrerequisiteRefs(Element element, Hashtable id_map) {
        if (element != null && this.isDocumentNamespace(element)) {
            String script;
            Element prereq = element.getChild("prerequisites", IMSDocumentHandler.ADLCP_NAMESPACE_12);
            if (prereq != null && (script = prereq.getText().trim()) != null && !script.equals("")) {
                Enumeration e = id_map.keys();
                while (e.hasMoreElements()) {
                    String newID;
                    Element ref_element;
                    String oldID = (String)e.nextElement();
                    int index = script.indexOf(oldID);
                    if (index == -1 || (ref_element = (Element)id_map.get(oldID)) == null || (newID = ref_element.getAttributeValue("identifier")) == null) continue;
                    script = script.replaceAll(oldID, newID);
                }
                prereq.setText(script);
            }
            for (Element child : element.getChildren()) {
                this.createNewPrerequisiteRefs(child, id_map);
            }
        }
    }

    public boolean exportManifest(Element manifestElement, File targetFolder) throws ReloadEditorException {
        File newFile;
        File sourceFolder;
        String base = this.getElementBase(manifestElement);
        if (base != null && (sourceFolder = new File(this.getProjectFolder(), base)).exists() && targetFolder.exists()) {
            try {
                File imsmanifestFile = new File(sourceFolder, "imsmanifest.xml");
                if (imsmanifestFile.exists()) {
                    ReloadUtils.copyFolder(sourceFolder, targetFolder, null);
                    return true;
                }
            }
            catch (IOException ex) {
                throw new ReloadEditorException(ex);
            }
        }
        File[] files = this.getResourceFiles(manifestElement);
        for (int i = 0; i < files.length; ++i) {
            try {
                String path = ReloadUtils.getRelativePath(this.getProjectFolder(), files[i]);
                newFile = new File(targetFolder, path);
                newFile.getParentFile().mkdirs();
                ReloadUtils.copyFile(files[i], newFile);
                continue;
            }
            catch (IOException ex) {
                throw new ReloadEditorException(ex);
            }
        }
        Document newDoc = new Document();
        this.addComments(newDoc);
        Element newRoot = (Element)manifestElement.clone();
        newDoc.setRootElement(newRoot);
        newFile = new File(targetFolder, "imsmanifest.xml");
        try {
            XMLUtils.write2XMLFile(newDoc, newFile);
        }
        catch (DweezilXMLException ex1) {
            throw new ReloadEditorException(ex1);
        }
        ((ContentPackageSchemaController)this.getReloadSchemaController()).copySchemaFilesToFolder(targetFolder);
        return true;
    }

    @Override
    public String getTargetRootElementName() {
        return "manifest";
    }

    public String getProjectName() {
        return this.getProjectFolder() == null ? null : this.getProjectFolder().getName();
    }

    public File getProjectFolder() {
        return this._file == null ? null : this._file.getParentFile();
    }

    @Override
    public boolean canCopyElement(Element element) {
        return this.canDragElement(element, 1);
    }

    @Override
    public boolean canCutElement(Element element, ReloadSchemaElement schemaElement) {
        return this.canCopyElement(element) && this.canDeleteElement(element, schemaElement);
    }

    @Override
    public boolean canPasteFromClipboard(Element element) {
        Element clipboardElement = ReloadDocumentClipboard.getElement();
        if (clipboardElement != null && element != null) {
            return this.acceptClipboardElement(clipboardElement, element);
        }
        return false;
    }

    public boolean canDragElement(Element element, int action) {
        if (element != null) {
            if (this.isSequence(element)) {
                return true;
            }
            if (!this.isDocumentNamespace(element)) {
                return false;
            }
            String name = element.getName();
            return name.equals("resource") || name.equals("metadata") || name.equals("item") || name.equals("organization") || name.equals("manifest");
        }
        return false;
    }

    public static Element findSequencingElementAncestor(Element element) {
        if (element != null) {
            String name = element.getName();
            name.toLowerCase();
            if (name.equals("resource") || name.equals("metadata") || name.equals("item") || name.equals("organization") || name.equals("manifest")) {
                return null;
            }
            if (name.equals("sequencing")) {
                return element;
            }
            return ContentPackage.findSequencingElementAncestor(element.getParentElement());
        }
        return null;
    }

    public boolean isSequence(Element element) {
        if (element != null) {
            String name = element.getName();
            name.toLowerCase();
            if (name.equals("resource") || name.equals("metadata") || name.equals("item") || name.equals("organization") || name.equals("manifest")) {
                return false;
            }
            if (name.equals("sequencing")) {
                return true;
            }
            return this.isSequence(element.getParentElement());
        }
        return false;
    }

    public boolean acceptClipboardElement(Element sourceElement, Element targetElement) {
        if (sourceElement != null && targetElement != null) {
            String sourceName = sourceElement.getName();
            String targetName = targetElement.getName();
            if (sourceName.equals("resource") && targetName.equals("resources")) {
                return !this.containsResource(sourceElement, targetElement);
            }
            return this.isAllowedChild(targetElement, sourceElement);
        }
        return false;
    }

    public boolean acceptElement(Element sourceElement, Element targetElement, int actionCopyMove) {
        if (sourceElement != null && targetElement != null) {
            boolean differentDoc;
            if (sourceElement.equals(targetElement)) {
                return false;
            }
            if ((actionCopyMove & 2) != 0) {
                if (targetElement.getContent().contains(sourceElement)) {
                    return false;
                }
                if (targetElement.isAncestor(sourceElement)) {
                    return false;
                }
            }
            Element targetManifest = this.getParentManifestElement(targetElement);
            Element sourceManifest = this.getParentManifestElement(sourceElement);
            if (targetManifest == null || sourceManifest == null) {
                return false;
            }
            String sourceName = sourceElement.getName();
            String targetName = targetElement.getName();
            boolean bl = differentDoc = !ContentPackage.isMemberOfSameDocument(sourceElement, targetElement);
            if (differentDoc) {
                return false;
            }
            if (sourceName.equals("resource")) {
                if (targetName.equals("organization") || targetName.equals("item")) {
                    if (targetManifest == sourceManifest) {
                        return true;
                    }
                    return sourceManifest.isAncestor(targetManifest);
                }
                if (targetName.equals("resources")) {
                    return !this.containsResource(sourceElement, targetElement);
                }
            }
            if (sourceName.equals("item")) {
                if (targetName.equals("organization") || targetName.equals("item")) {
                    if (targetManifest == sourceManifest) {
                        return true;
                    }
                    Element refElement = this.getReferencedElement(sourceElement);
                    if (refElement != null) {
                        Element ref_targetManifest = this.getParentManifestElement(refElement);
                        return ref_targetManifest.isAncestor(targetManifest) || ref_targetManifest == targetManifest;
                    }
                    return true;
                }
            } else if (sourceName.equals("manifest")) {
                if (targetName.equals("organization") || targetName.equals("item")) {
                    return sourceManifest.isAncestor(targetManifest);
                }
                if (targetName.equals("manifest")) {
                    return false;
                }
            } else {
                return this.isAllowedChild(targetElement, sourceElement);
            }
        }
        return false;
    }

    public Element shiftElement(Element sourceElement, Element targetElement, int action) {
        if (sourceElement != null && targetElement != null) {
            Element targetManifest = this.getParentManifestElement(targetElement);
            Element sourceManifest = this.getParentManifestElement(sourceElement);
            if (targetManifest == null || sourceManifest == null) {
                return null;
            }
            boolean isSameDocument = ContentPackage.isMemberOfSameDocument(sourceElement, targetElement);
            if (targetManifest != sourceManifest) {
                action = 1;
            }
            String sourceName = sourceElement.getName();
            String targetName = targetElement.getName();
            if (sourceName.equals("resource")) {
                if (targetName.equals("organization")) {
                    return this.addItemResource(targetElement, sourceElement, true);
                }
                if (targetName.equals("item")) {
                    Element refElement = this.getReferencedElement(targetElement);
                    if (refElement == null) {
                        return this.addItemResource(targetElement, sourceElement, true);
                    }
                    String msg = "You cannot add a Resource to an Item that already contains a reference to a Resource or a Manifest.";
                    ErrorDialogBox.showWarning(msg, "Item Contains Reference", null);
                    return null;
                }
                if (targetName.equals("resources")) {
                    return this._shiftElement(sourceElement, targetElement, action, true);
                }
            } else if (sourceName.equals("manifest")) {
                if (targetName.equals("organization")) {
                    return this.addItemManifest(sourceElement, targetElement, true);
                }
                if (targetName.equals("item")) {
                    Element refElement = this.getReferencedElement(targetElement);
                    if (refElement == null) {
                        return this.addItemManifest(sourceElement, targetElement, true);
                    }
                    String msg = "You cannot add a reference to a Manifest if the target Item already contains a reference to a Resource or another Manifest.";
                    ErrorDialogBox.showWarning(msg, "Item Contains Reference", null);
                    return null;
                }
                if (targetName.equals("manifest")) {
                    return this._shiftElement(sourceElement, targetElement, action, true);
                }
            } else {
                if (sourceName.equals("item") && targetName.equals("item") && this instanceof SCORM1_3Package) {
                    Element refElement = this.getReferencedElement(targetElement);
                    if (refElement == null && this.isAllowedChild(targetElement, sourceElement) && targetElement.getChild("presentation", IMSDocumentHandler.ADLNAV_NAMESPACE_13) == null) {
                        return this._shiftElement(sourceElement, targetElement, action, true);
                    }
                    String msg = "You cannot add this Item to the target Item if the target Item contains a reference to a Resource or Manifest or if the target Item contains an adlnav:presentation element.";
                    ErrorDialogBox.showWarning(msg, "Item Contains Reference", null);
                    return null;
                }
                if (this.isAllowedChild(targetElement, sourceElement)) {
                    return this._shiftElement(sourceElement, targetElement, action, true);
                }
            }
        }
        return null;
    }

    protected Element _shiftElement(Element sourceElement, Element targetElement, int action, boolean doSelect) {
        if ((action & 1) != 0) {
            return this.copyElementUndoable(this, sourceElement, targetElement, doSelect);
        }
        if ((action & 2) != 0) {
            return this.moveElementUndoable(this, sourceElement, targetElement, doSelect);
        }
        return null;
    }

    @Override
    public Element addElementBySchema(Object source, Element parentElement, ReloadSchemaElement newSchemaElement, boolean doSelect) {
        Element newElement = super.addElementBySchema(source, parentElement, newSchemaElement, doSelect);
        if (newElement != null) {
            String name;
            String id;
            if (newSchemaElement.hasAttribute("identifier") && (id = newElement.getAttributeValue("identifier")) == null) {
                ReloadSchemaAttribute schemaAtt = newSchemaElement.getAttribute("identifier");
                Attribute att = this.addAttribute(source, newElement, schemaAtt);
                String uniqueID = this.generateUniqueID(newElement);
                att.setValue(uniqueID);
                this.fireElementChanged(new ReloadDocumentListenerEvent(source, this, newElement, false));
            }
            if ((name = newElement.getName()).equals("organization")) {
                this.setDefaultOrganization(newElement);
                this.addTitle(newElement, "Organization");
            } else if (name.equals("item")) {
                this.addTitle(newElement, "Item");
            }
        }
        return newElement;
    }

    @Override
    public Element copyElementUndoable(Object source, Element element, Element newParent, boolean doSelect) {
        Element newElement = super.copyElementUndoable(source, element, newParent, doSelect);
        this._copypasteElement(newElement);
        return newElement;
    }

    @Override
    public Element pasteElementUndoable(Object source, Element element, Element newParent, boolean doSelect) {
        Element newElement = super.pasteElementUndoable(source, element, newParent, doSelect);
        this._copypasteElement(newElement);
        return newElement;
    }

    protected void _copypasteElement(Element newElement) {
        if (newElement != null) {
            String name = newElement.getName();
            if (name.equals("item") || name.equals("resource")) {
                this.createNewIDs(newElement);
            } else if (name.equals("organization")) {
                this.createNewIDs(newElement);
                this.setDefaultOrganization(newElement);
                this.checkIDRefs(newElement);
            } else if (name.equals("manifest")) {
                Hashtable map = this.createNewIDs(newElement);
                this.createNewIDRefs(newElement, map);
            }
        }
    }

    protected Element addItemManifest(Element manifestElement, Element targetElement, boolean doSelect) {
        String manifestID;
        DomPath domPath = DomPath.getDomPath(targetElement);
        domPath.appendElementName("item");
        ReloadSchemaElement schemaElement = (ReloadSchemaElement)this.getReloadSchemaController().getReloadSchemaNode(domPath);
        Element itemElement = this.addElementBySchemaUndoable(this, targetElement, schemaElement, doSelect);
        if (itemElement != null && (manifestID = manifestElement.getAttributeValue("identifier")) != null) {
            itemElement.setAttribute("identifierref", manifestID);
        }
        return itemElement;
    }

    protected Element addItemResource(Element parentElement, Element resourceElement, boolean doSelect) {
        DomPath domPath = DomPath.getDomPath(parentElement);
        domPath.appendElementName("item");
        ReloadSchemaElement schemaElement = (ReloadSchemaElement)this.getReloadSchemaController().getReloadSchemaNode(domPath);
        Element itemElement = this.addElementBySchemaUndoable(this, parentElement, schemaElement, doSelect);
        if (itemElement != null && resourceElement != null) {
            String resourceID = resourceElement.getAttributeValue("identifier");
            if (resourceID != null) {
                itemElement.setAttribute("identifierref", resourceID);
            }
            this.addItemTitle(itemElement, resourceElement);
        }
        return itemElement;
    }

    protected Element addOrganization(Element parentElement, boolean doSelect) {
        DomPath domPath = DomPath.getDomPath(parentElement);
        domPath.appendElementName("organization");
        ReloadSchemaElement schemaElement = (ReloadSchemaElement)this.getReloadSchemaController().getReloadSchemaNode(domPath);
        return this.addElementBySchemaUndoable(this, parentElement, schemaElement, doSelect);
    }

    protected Element addTitle(Element parentElement, String text) {
        Element titleElement = parentElement.getChild("title", parentElement.getNamespace());
        if (titleElement != null) {
            titleElement.setText(text);
        } else {
            titleElement = new Element("title", parentElement.getNamespace());
            titleElement.setText(text);
            this.addElement(this, parentElement, titleElement, false);
        }
        return titleElement;
    }

    protected Element addItemTitle(Element itemElement, Element resourceElement) {
        Element titleElement = null;
        if (itemElement != null && resourceElement != null) {
            String title = null;
            File file = this.getResourceFile(resourceElement);
            if (file != null) {
                String fileName = file.getName().toLowerCase();
                if (fileName.endsWith(".html") || fileName.endsWith(".htm")) {
                    HTMLParser parser = new HTMLParser(file);
                    title = parser.getTagText("title");
                } else {
                    title = ReloadUtils.getFileNameWithoutExtension(file);
                }
            }
            titleElement = this.addTitle(itemElement, title);
        }
        return titleElement;
    }

    public String getElementDisplayName(Element element) {
        String fname = null;
        if (element != null) {
            String name = element.getName();
            if (name.equals("item") || name.equals("organization")) {
                Element titleElement = element.getChild("title", element.getNamespace());
                if (titleElement != null) {
                    fname = titleElement.getText().trim();
                }
            } else if (name.equals("dependency")) {
                fname = this.getElementHREF(element);
            } else if (name.equals("manifest")) {
                fname = element.getAttributeValue("identifier");
            } else if (name.equals("file") || name.equals("resource")) {
                fname = element.getAttributeValue("href");
            } else if (name.equals("schema") || name.equals("schemaversion")) {
                fname = element.getText().trim();
            }
            if ((fname == null || fname.equals("")) && (fname = this.getReloadSchemaController().getElementFriendlyName(DomPath.getDomPath(element))) == null) {
                fname = element.getQualifiedName();
            }
        }
        return fname;
    }

    public Element getReferencedElement(Element sourceElement) {
        return this._cpCore.getReferencedElement(sourceElement);
    }

    public boolean isReferencingElement(Element element) {
        return this._cpCore.isReferencingElement(element);
    }

    public String[] getReferencedIdentifersAllowed(Element element) {
        return this._cpCore.getReferencedIdentifersAllowed(element);
    }

    public Element[] getReferencedElementsAllowed(Element element) {
        return this._cpCore.getReferencedElementsAllowed(element);
    }

    public Element[] getOrganizations(Element orgsElement) {
        return this._cpCore.getOrganizations(orgsElement);
    }

    public Element[] getOrganizationsAllowed(Element orgsElement) {
        return this._cpCore.getOrganizationsAllowed(orgsElement);
    }

    public Element getDefaultOrganization(Element orgsElement) {
        return this._cpCore.getDefaultOrganization(orgsElement);
    }

    public Element getParentManifestElement(Element element) {
        return this._cpCore.getParentManifestElement(element);
    }

    public Element[] getElementsInManifest(Element manifestElement, String elementName, Namespace ns) {
        return this._cpCore.getElementsInManifest(manifestElement, elementName, ns);
    }

    public Element getElementByIdentifier(Element parent, String identifier) {
        return this._cpCore.getElementByIdentifier(parent, identifier);
    }

    @Override
    public Namespace getMetadataNamespace() {
        return this._cpCore.getMetadataNamespace();
    }

    @Override
    public boolean isMetadataRoot(String name) {
        return this._cpCore.isMetadataRoot(name);
    }

    @Override
    public boolean isMetadataElement(String name) {
        return this._cpCore.isMetadataElement(name);
    }

    public String getURL(Element element) {
        return this._cpCore.getURL(element);
    }

    public String getElementHREF(Element element) {
        return this._cpCore.getElementHREF(element);
    }

    public String getElementBase(Element element) {
        return this._cpCore.getElementBase(element);
    }

    public String getParameters(Element element) {
        return this._cpCore.getParameters(element);
    }

    public File getResourceFile(Element element) {
        return this._cpCore.getResourceFile(element);
    }

    public File[] getResourceFiles(Element manifestElement) {
        return this._cpCore.getResourceFiles(manifestElement);
    }

    public Element getResource(String href, Element resourcesElement) {
        return this._cpCore.getResource(href, resourcesElement);
    }

    public Element getResourcesElement(Element element) {
        return this._cpCore.getResourcesElement(element);
    }

    protected void createNewIDRefs(Element element, Hashtable id_map) {
        if (element != null && this.isDocumentNamespace(element)) {
            String newID;
            Element ref_element;
            String idref;
            String name = element.getName();
            String attrib = null;
            if (name.equals("item")) {
                attrib = "identifierref";
            } else if (name.equals("organizations")) {
                attrib = "default";
            }
            if (attrib != null && (idref = element.getAttributeValue(attrib)) != null && !idref.equals("") && (ref_element = (Element)id_map.get(idref)) != null && (newID = ref_element.getAttributeValue("identifier")) != null) {
                element.setAttribute(attrib, newID);
            }
            for (Element child : element.getChildren()) {
                this.createNewIDRefs(child, id_map);
            }
        }
    }

    protected Hashtable createNewIDs(Element element) {
        Hashtable idmap = new Hashtable();
        this._createNewIDs(element, idmap);
        return idmap;
    }

    protected void _createNewIDs(Element element, Hashtable idmap) {
        if (element != null && this.isDocumentNamespace(element)) {
            String oldID = element.getAttributeValue("identifier");
            if (oldID != null) {
                String newID = this.generateUniqueID(element);
                idmap.put(oldID, element);
                element.setAttribute("identifier", newID);
            }
            for (Element child : element.getChildren()) {
                this._createNewIDs(child, idmap);
            }
        }
    }

    protected void checkIDRefs(Element element) {
        if (element != null && this.isDocumentNamespace(element)) {
            Attribute att;
            Element ref_element = this.getReferencedElement(element);
            if (ref_element == null && (att = element.getAttribute("identifierref")) != null) {
                element.removeAttribute(att);
            }
            for (Element child : element.getChildren()) {
                this.checkIDRefs(child);
            }
        }
    }

    protected String generateUniqueID(Element element) {
        String elementName = element.getName();
        String prefix = elementName.equals("manifest") ? "MANIFEST-" : (elementName.equals("organization") ? "ORG-" : (elementName.equals("item") ? "ITEM-" : (elementName.equals("resource") ? "RES-" : "RLD-")));
        return RandomGUID.getUniqueID(prefix);
    }

    protected void setDefaultOrganization(Element organization) {
        String id;
        Element orgs = organization.getParentElement();
        if (orgs.getChildren("organization", orgs.getNamespace()).size() == 1 && (id = organization.getAttributeValue("identifier")) != null) {
            orgs.setAttribute("default", id);
        }
    }

    public Element addReloadResources(ReloadResource[] reloadResources, Element parentElement) {
        Element element = null;
        for (int i = 0; i < reloadResources.length; ++i) {
            element = this.addReloadResource(reloadResources[i], parentElement);
        }
        return element;
    }

    public Element addReloadResource(ReloadResource reloadResource, Element parentElement) {
        if (reloadResource.isDirectory()) {
            String name = parentElement.getName();
            if (name.equals("organizations")) {
                parentElement = this.addOrganization(parentElement, false);
                this.addTitle(parentElement, reloadResource.getName());
            } else if (name.equals("organization") || name.equals("item")) {
                parentElement = this.addItemResource(parentElement, null, false);
                this.addTitle(parentElement, reloadResource.getName());
            }
            ReloadResource[] resources = reloadResource.getChildren();
            if (resources != null) {
                for (int i = 0; i < resources.length; ++i) {
                    this.addReloadResource(resources[i], parentElement);
                }
            }
            return parentElement;
        }
        return this._addReloadResource(reloadResource, parentElement, false);
    }

    protected Element _addReloadResource(ReloadResource reloadResource, Element parentElement, boolean doSelect) {
        Element resourcesElement = this.getResourcesElement(parentElement);
        Element resourceElement = this.getResourceByReloadResouce(reloadResource, resourcesElement);
        if (resourceElement == null) {
            resourceElement = this._addReloadResourceToResourcesElement(reloadResource, resourcesElement, doSelect);
        }
        String name = parentElement.getName();
        this.lastResourceElementAdded = resourceElement;
        if (name.equals("organization") || name.equals("item")) {
            return this.addItemResource(parentElement, resourceElement, doSelect);
        }
        return resourceElement;
    }

    public Element getLastResourceElementAdded() {
        return this.lastResourceElementAdded;
    }

    public void clearLastResourceElementAdded() {
        this.lastResourceElementAdded = null;
    }

    protected Element _addReloadResourceToResourcesElement(ReloadResource reloadResource, Element resourcesElement, boolean doSelect) {
        DomPath domPath = DomPath.getDomPath(resourcesElement);
        domPath.appendElementName("resource");
        ReloadSchemaElement schemaElement = (ReloadSchemaElement)this.getReloadSchemaController().getReloadSchemaNode(domPath);
        Element newElement = this.addElementBySchema(this, resourcesElement, schemaElement, doSelect);
        if (newElement != null) {
            String href = ReloadUtils.getRelativePath(this.getProjectFolder(), reloadResource);
            newElement.setAttribute("href", href);
            this.addFileElements(reloadResource, newElement, schemaElement, doSelect);
            if (this._undoHandler != null) {
                ReloadSchemaDocument.UndoableAddAction addAction = new ReloadSchemaDocument.UndoableAddAction(this, resourcesElement, newElement);
                this._undoHandler.addUndoableAction(addAction);
            }
        }
        return newElement;
    }

    protected boolean containsReloadResource(ReloadResource reloadResource, Element resourcesElement) {
        Element element = this.getResourceByReloadResouce(reloadResource, resourcesElement);
        return element != null;
    }

    protected Element getResourceByReloadResouce(ReloadResource reloadResource, Element resourcesElement) {
        String href = ReloadUtils.getRelativePath(this.getProjectFolder(), reloadResource);
        return this.getResource(href, resourcesElement);
    }

    public boolean containsResource(Element sourceElement, Element resourcesElement) {
        String href;
        if (sourceElement != null && resourcesElement != null && sourceElement.getName().equals("resource") && resourcesElement.getName().equals("resources") && (href = sourceElement.getAttributeValue("href")) != null) {
            return this.containsResource(href, resourcesElement);
        }
        return false;
    }

    protected boolean containsResource(String href, Element resourcesElement) {
        Element element = this.getResource(href, resourcesElement);
        return element != null;
    }

    public boolean acceptsReloadResources(Element targetElement) {
        if (!targetElement.getNamespace().equals(this.getTargetNamespace())) {
            return false;
        }
        String name = targetElement.getName();
        return name.equals("manifest") || name.equals("resources") || name.equals("organization") || name.equals("item") || name.equals("organizations");
    }

    public void addFileElements(ReloadResource reloadResource, Element parentElement, ReloadSchemaElement parentSchemaElement, boolean doSelect) {
        ReloadSchemaElement fileSchemaElement = parentSchemaElement.getChild("file");
        Element fileElement = this.addElementBySchema(this, parentElement, fileSchemaElement, doSelect);
        if (fileElement != null) {
            String href = ReloadUtils.getRelativePath(this.getProjectFolder(), reloadResource);
            fileElement.setAttribute("href", href);
        }
        if (ReloadFileType.isParseableFile(reloadResource)) {
            File[] files = reloadResource.getDependencies(this.getProjectFolder());
            for (int i = 0; i < files.length; ++i) {
                fileElement = this.addElementBySchema(this, parentElement, fileSchemaElement, doSelect);
                String href = ReloadUtils.getRelativePath(this.getProjectFolder(), files[i]);
                fileElement.setAttribute("href", href);
            }
        }
    }
}

