/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import aadl.ImportUtility;
import aadl.Input;
import aadl.Messagebox;
import aadl.ZiptoView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.ZipOutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.ApplicationListener;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadComboBox;
import uk.ac.reload.dweezil.gui.ReloadFileFilter;
import uk.ac.reload.dweezil.gui.ReloadInternalFrame;
import uk.ac.reload.dweezil.gui.ReloadInternalFrameManager;
import uk.ac.reload.dweezil.gui.ReloadProgressMonitor;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.menu.ReloadMenuEvent;
import uk.ac.reload.dweezil.menu.ReloadUndoMenuManager;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.dweezil.util.ZipUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.contentpackaging.CP_Viewer;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.ContentPackageHelperProfile;
import uk.ac.reload.editor.contentpackaging.ContentPackageSchemaController;
import uk.ac.reload.editor.contentpackaging.ProxyConvertHandler;
import uk.ac.reload.editor.contentpackaging.ProxyValidationHandler;
import uk.ac.reload.editor.contentpackaging.SCORM1_3Package;
import uk.ac.reload.editor.contentpackaging.manifestview.ManifestPanel;
import uk.ac.reload.editor.contentpackaging.resourceview.CPResourcesPanel;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.dom.ReloadDocumentListener;
import uk.ac.reload.moonunit.dom.ReloadDocumentListenerEvent;
import uk.ac.reload.moonunit.dom.ReloadDomException;
import uk.ac.reload.moonunit.dom.ReloadSchemaDocument;

public class ContentPackageEditor
extends ReloadInternalFrame
implements ApplicationListener,
ReloadDocumentListener {
    protected ContentPackage _contentPackage;
    protected CPResourcesPanel _resourcesPanel;
    protected ManifestPanel _manifestPanel;
    protected JSplitPane _splitPane;
    protected ProxySaveHandler _saveHandler;
    protected ProxySaveHandler _saveAsHandler;
    protected ProxyZipHandler _zipHandler;
    protected ProxyValidationHandler _validationHandler;
    protected ProxyConvertHandler _convertHandler;
    protected ProxyViewCPHandler _viewCPHandler;
    protected ProxyViewRTEHandler _viewRTEHandler;
    protected ReloadUndoMenuManager _undoMenuManager;
    protected CPPrefsPanel _prefsPanel;

    public ContentPackageEditor() {
        this.setFrameIcon(ReloadEditor.ICON_CP);
        this.setTitle("Content Package");
        this._resourcesPanel = new CPResourcesPanel();
        this._manifestPanel = new ManifestPanel(this);
        this._prefsPanel = new CPPrefsPanel();
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this._prefsPanel, "North");
        p.add((Component)this._manifestPanel, "Center");
        this._splitPane = new JSplitPane(1);
        this._splitPane.setOneTouchExpandable(true);
        this.getContentPane().add(this._splitPane);
        this._splitPane.setLeftComponent(this._resourcesPanel);
        this._splitPane.setRightComponent(p);
        this.setDefaultCloseOperation(0);
        ReloadEditor.getInstance().addApplicationListener(this);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean ok = ContentPackageEditor.this.checkNeedsSaving();
                        if (ok) {
                            ContentPackageEditor.this.dispose();
                        }
                    }
                });
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                ContentPackageEditor.this.setFocusGained();
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                ContentPackageEditor.this.setFocusLost();
            }
        });
    }

    @Override
    public void show() {
        super.show();
        this._splitPane.setDividerLocation(0.25);
        this._manifestPanel.initView();
    }

    public void setDocument(File file, Document doc, ContentPackageSchemaController schemaController) throws ReloadEditorException {
        this._contentPackage = new ContentPackage(file, doc, schemaController);
        this.setContentPackage(this._contentPackage);
    }

    protected void setContentPackage(ContentPackage contentPackage) {
        ReloadInternalFrameManager.addReloadInternalFrameToWindowMap(this._contentPackage.getFile(), this);
        this.setTitle("Content Package - " + contentPackage.getProjectName());
        this._resourcesPanel.setFileView(contentPackage.getProjectFolder());
        this._manifestPanel.setContentPackage(contentPackage);
        this._saveHandler = new ProxySaveHandler(MainMenu.sharedInstance.actionSave);
        this._saveAsHandler = new ProxySaveHandler(MainMenu.sharedInstance.actionSaveAs);
        this._zipHandler = new ProxyZipHandler();
        this._validationHandler = new ProxyValidationHandler(contentPackage.getProjectFolder() + File.separator + "imsmanifest.xml");
        this._viewCPHandler = new ProxyViewCPHandler();
        this._convertHandler = new ProxyConvertHandler(contentPackage, this);
        this._convertHandler.setEnabled(false);
        this._viewRTEHandler = new ProxyViewRTEHandler();
        contentPackage.addReloadDocumentListener(this);
        this._undoMenuManager = new ReloadUndoMenuManager(MainMenu.sharedInstance.editMenu.actionUndo, MainMenu.sharedInstance.editMenu.actionRedo);
        contentPackage.setUndoHandler(this._undoMenuManager.getUndoHandler());
        this._prefsPanel.init(contentPackage);
    }

    public void newContentPackage(File projectFolder, String metadataVersion) throws ReloadEditorException {
        this._contentPackage = new ContentPackage();
        ContentPackageSchemaController cpController = ContentPackageSchemaController.getDefaultSchemaController();
        MetadataSchemaController mdController = null;
        mdController = metadataVersion.equals(IMSDocumentHandler.LOM_10) ? MetadataSchemaController.getDefaultSchemaController1_3() : MetadataSchemaController.getDefaultSchemaController1_2();
        this._contentPackage.newContentPackage(projectFolder, cpController, mdController, metadataVersion);
        this.setContentPackage(this._contentPackage);
    }

    public void exportManifest(Element manifestElement) {
        try {
            File targetFolder = ReloadEditorDocumentHandler.askNewContentPackageFolder("Select Folder for Exported Content Package");
            if (targetFolder == null || !targetFolder.exists()) {
                return;
            }
            boolean result = this._contentPackage.exportManifest(manifestElement, targetFolder);
            if (result) {
                JOptionPane.showMessageDialog(this, "Sub-Manifest exported successfully.", "Export Package", 1, null);
            } else {
                JOptionPane.showMessageDialog(this, "Error in export.", "Export Package", 0, null);
            }
        }
        catch (Exception ex) {
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            ErrorDialogBox.showWarning(this, "Error Exporting", "Could not Export Content Package", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importManifest(Element manifestElement) {
        ReloadProgressMonitor progressMonitor = null;
        try {
            File manifestFile = ReloadEditorDocumentHandler.askManifestFileOpen(this);
            if (manifestFile == null || !manifestFile.exists()) {
                return;
            }
            if (manifestFile.equals(this._contentPackage.getFile())) {
                JOptionPane.showMessageDialog(this, "Cannot import the same Manifest!", "Import Package", 2);
                return;
            }
            File fileBase = null;
            String base = this._contentPackage.getElementBase(manifestElement);
            fileBase = base != null ? new File(this._contentPackage.getProjectFolder(), base) : this._contentPackage.getProjectFolder();
            File targetFolder = null;
            int i = 1;
            do {
                targetFolder = new File(fileBase, "submanifest" + i);
                ++i;
            } while (targetFolder.exists());
            if (manifestFile.getName().toLowerCase().endsWith(".zip")) {
                if (!IMSDocumentHandler.containsManifest(manifestFile)) {
                    JOptionPane.showMessageDialog(ReloadEditor.getInstance(), "Manifest file imsmanifest.xml cannot be located in archive.", "Archive error", 2);
                    return;
                }
                targetFolder.mkdirs();
                progressMonitor = new ReloadProgressMonitor(ReloadEditor.getInstance(), "Unzipping Content Package", "Unzipping...", "Searching...", true, ReloadUIManager.getIcon(ReloadEditor.ICON_APP16));
                manifestFile = ReloadEditorDocumentHandler.unzipContentPackage(manifestFile, targetFolder, progressMonitor);
                if (manifestFile == null) {
                    return;
                }
            } else {
                progressMonitor = new ReloadProgressMonitor(ReloadEditor.getInstance(), "Copying Content Package", "Copying...", "Searching...", true, ReloadUIManager.getIcon(ReloadEditor.ICON_APP16));
                targetFolder.mkdirs();
                ReloadUtils.copyFolder(manifestFile.getParentFile(), targetFolder, progressMonitor);
            }
            this._contentPackage.importManifest(manifestFile, manifestElement, targetFolder.getName());
        }
        catch (Exception ex) {
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            ErrorDialogBox.showWarning(this, "Error importing Content Package", "Could not import Content Package", ex);
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            this._resourcesPanel.refreshResourceTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipIt() {
        if (this._contentPackage != null) {
            block15: {
                boolean doSave = this.checkNeedsSaving();
                if (!doSave) {
                    return;
                }
                ReloadProgressMonitor progressMonitor = null;
                try {
                    ReloadFileFilter filter = new ReloadFileFilter(new String[]{"zip"}, "Archive files");
                    File file = ReloadUtils.askFileNameSave(this, "Save as Zip File", filter, "zip");
                    if (file != null) {
                        this._zipHandler.setEnabled(false);
                        this._validationHandler.setEnabled(false);
                        this._convertHandler.setEnabled(false);
                        progressMonitor = new ReloadProgressMonitor(ReloadEditor.getInstance(), "Zip Content Package", "Zipping...", "", true, ReloadUIManager.getIcon(ReloadEditor.ICON_APP16));
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                        ZipOutputStream zOut = new ZipOutputStream(out);
                        ZipUtils.addFolderToZip(this._contentPackage.getProjectFolder(), this._contentPackage.getProjectFolder(), zOut, file);
                        zOut.flush();
                        zOut.close();
                    }
                    if (progressMonitor == null) break block15;
                    progressMonitor.close();
                }
                catch (Exception ex) {
                    block16: {
                        try {
                            if (ReloadEditor.DEBUG) {
                                ex.printStackTrace();
                            }
                            ErrorDialogBox.showWarning(this, "Zip Content Package", "Error zipping Package", ex);
                            if (progressMonitor == null) break block16;
                            progressMonitor.close();
                        }
                        catch (Throwable throwable) {
                            if (progressMonitor != null) {
                                progressMonitor.close();
                            }
                            this._zipHandler.setEnabled(true);
                            this._validationHandler.setEnabled(this.isFourthEdition());
                            if (this._contentPackage instanceof SCORM1_3Package) {
                                this._convertHandler.setEnabled(!this.isFourthEdition());
                            } else {
                                this._convertHandler.setEnabled(false);
                            }
                            throw throwable;
                        }
                    }
                    this._zipHandler.setEnabled(true);
                    this._validationHandler.setEnabled(this.isFourthEdition());
                    if (this._contentPackage instanceof SCORM1_3Package) {
                        this._convertHandler.setEnabled(!this.isFourthEdition());
                    } else {
                        this._convertHandler.setEnabled(false);
                    }
                }
            }
            this._zipHandler.setEnabled(true);
            this._validationHandler.setEnabled(this.isFourthEdition());
            if (this._contentPackage instanceof SCORM1_3Package) {
                this._convertHandler.setEnabled(!this.isFourthEdition());
            } else {
                this._convertHandler.setEnabled(false);
            }
        }
    }

    private boolean isFourthEdition() {
        if (this._contentPackage instanceof SCORM1_3Package) {
            return ((SCORM1_3Package)this._contentPackage).isFourthEdition();
        }
        return false;
    }

    public ContentPackage getContentPackage() {
        return this._contentPackage;
    }

    public ProxyZipHandler getZipHandler() {
        return this._zipHandler;
    }

    public void loadProfile(ContentPackageHelperProfile cpProfile) {
        ((ContentPackageSchemaController)this.getContentPackage().getReloadSchemaController()).setHelperProfile(cpProfile);
    }

    public ContentPackageHelperProfile[] getHelperProfiles() {
        return ContentPackageHelperProfile.getContentPackageHelperProfiles();
    }

    @Override
    public void elementAdded(ReloadDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._contentPackage.isDirty());
        }
    }

    @Override
    public void elementChanged(ReloadDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._contentPackage.isDirty());
        }
    }

    @Override
    public void elementRemoved(ReloadDocumentListenerEvent e) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._contentPackage.isDirty());
        }
    }

    @Override
    public void documentSaved(ReloadSchemaDocument doc) {
        if (this.isSelected()) {
            this._saveHandler.setEnabled(this._contentPackage.isDirty());
        }
    }

    private void setFocusGained() {
        if (this._contentPackage != null) {
            this._resourcesPanel.setFocusGained();
            this._undoMenuManager.setFocusGained();
            this._zipHandler.setEnabled(true);
            this._zipHandler.addListener();
            this._viewCPHandler.setEnabled(true);
            this._viewCPHandler.addListener();
            this._viewRTEHandler.setEnabled(true);
            this._viewRTEHandler.addListener();
            this._saveHandler.setEnabled(this._contentPackage.isDirty());
            this._saveHandler.addListener();
            this._saveAsHandler.setEnabled(false);
            this._saveAsHandler.addListener();
            if (this.isFourthEdition()) {
                this._validationHandler.setEnabled(true);
                this._validationHandler.addListener();
            } else if (this._contentPackage instanceof SCORM1_3Package) {
                this._convertHandler.setEnabled(true);
                this._convertHandler.addListener();
            }
        }
    }

    private void setFocusLost() {
        this._undoMenuManager.setFocusLost();
        this._resourcesPanel.setFocusLost();
        this._zipHandler.setEnabled(false);
        this._zipHandler.removeListener();
        this._viewCPHandler.setEnabled(false);
        this._viewCPHandler.removeListener();
        this._viewRTEHandler.setEnabled(false);
        this._viewRTEHandler.removeListener();
        this._saveHandler.setEnabled(false);
        this._saveHandler.removeListener();
        this._saveAsHandler.setEnabled(false);
        this._saveAsHandler.removeListener();
        this._validationHandler.setEnabled(false);
        this._convertHandler.setEnabled(false);
        this._convertHandler.removeListener();
        this._validationHandler.removeListener();
    }

    @Override
    public boolean applicationClosing() {
        return this.checkNeedsSaving();
    }

    protected boolean checkNeedsSaving() {
        boolean isOK = true;
        if (this._contentPackage != null && this._contentPackage.isDirty()) {
            int doSave = JOptionPane.showConfirmDialog(this, "The Manifest has been modified. Do you wish to save these changes?", "Save Content Package Manifest", 1);
            if (doSave == 0) {
                isOK = this.saveDocument();
            } else if (doSave == 2) {
                isOK = false;
            }
        }
        return isOK;
    }

    @Override
    public void dispose() {
        try {
            ReloadEditor.getInstance().removeApplicationListener(this);
            this._saveHandler.removeListener();
            this._saveAsHandler.removeListener();
            this._zipHandler.removeListener();
            this._viewCPHandler.removeListener();
            this._validationHandler.removeListener();
            this._viewRTEHandler.removeListener();
            this._resourcesPanel.destroy();
            this._contentPackage.removeReloadDocumentListener(this);
            this._manifestPanel.destroy();
            this._contentPackage.destroy();
            this._undoMenuManager.destroy();
            super.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean saveDocument() {
        if (this._contentPackage.getFile() == null) {
            return this.saveAsDocument();
        }
        try {
            this._contentPackage.saveDocument();
        }
        catch (ReloadDomException ex) {
            ErrorDialogBox.showWarning(this, "Could not save file: ", "Save Manifest", ex);
            return false;
        }
        return true;
    }

    protected boolean saveAsDocument() {
        ReloadFileFilter filter = new ReloadFileFilter(new String[]{"xml"}, "xml files");
        File file = ReloadUtils.askFileNameSave(this, "Save Manifest", filter, "xml");
        if (file == null) {
            return false;
        }
        this.setTitle("Content Package - " + file.getPath());
        try {
            this._contentPackage.saveAsDocument(file);
            ReloadInternalFrameManager.addReloadInternalFrameToWindowMap(file, this);
        }
        catch (ReloadDomException ex) {
            ErrorDialogBox.showWarning(this, "Could not save file: ", "Save Manifest", ex);
            return false;
        }
        return true;
    }

    private void importAndRun() {
        this._zipHandler.setEnabled(false);
        Namespace ns = this._contentPackage.getTargetNamespace();
        if (this._contentPackage.getRootElement().getChild("organizations", ns).getChildren("organization", ns) != null) {
            Iterator itr = this._contentPackage.getDocument().getRootElement().getChild("organizations", ns).getChildren("organization", ns).iterator();
            Element[] el1 = new Element[100];
            int count = 0;
            Input ibox = new Input(ReloadEditor.getInstance());
            Messagebox msgbox = new Messagebox(ReloadEditor.getInstance());
            String text = "Note that each organization is imported into the RTE by using its title,\n and each organization in your manifest will be imported individually.\n To differentiate between them, you will now be prompted to change\n the title of those organizations you left as \"Organization\".";
            while (itr.hasNext()) {
                Element el = (Element)itr.next();
                el1[count] = el.getChild("title", ns);
                if (el1[count] == null) continue;
                if (el1[count].getText().equals("Organization")) {
                    if (count == 0) {
                        msgbox.show(text);
                    }
                    this._contentPackage.setDirty(true);
                    String txt = ibox.getString("Please enter the title of the Organization");
                    el1[count].setText(txt);
                    ReloadEditor.getInstance().repaint();
                }
                ++count;
            }
            this.checkNeedsSaving();
            int val = JOptionPane.showConfirmDialog(null, "Would you like the RTE to validate your content package?", "Validation of Content Package", 0);
            if (val != 1 && val != -1) {
                Input.isValidation = true;
            }
        }
        ZiptoView.zipViewFile(this._contentPackage);
        this._zipHandler.setEnabled(true);
        String tempFolderPath = ImportUtility.getValue("temp");
        ImportUtility.runimport(tempFolderPath + "\\reload\\course.zip");
    }

    class CPPrefsPanel
    extends JPanel {
        ReloadComboBox profileCombobox;

        CPPrefsPanel() {
            this.setLayout(new FlowLayout(0));
            this.add(new JLabel("Profile: "));
            this.profileCombobox = new ReloadComboBox(false);
            this.add(this.profileCombobox);
            Object[] profiles = ContentPackageEditor.this.getHelperProfiles();
            this.profileCombobox.setItems(profiles);
        }

        public void init(ContentPackage cp) {
            ContentPackageHelperProfile cpProfile = (ContentPackageHelperProfile)((ContentPackageSchemaController)cp.getReloadSchemaController()).getReloadHelperProfile();
            this.profileCombobox.setSelectedItem(cpProfile);
            this.profileCombobox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContentPackageHelperProfile profile = (ContentPackageHelperProfile)CPPrefsPanel.this.profileCombobox.getSelectedItem();
                    ContentPackageEditor.this.loadProfile(profile);
                }
            });
        }
    }

    class ProxyViewCPHandler
    extends ProxyAction {
        public ProxyViewCPHandler() {
            super(MainMenu.sharedInstance.actionViewCP);
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    CP_Viewer viewer = new CP_Viewer(ContentPackageEditor.this._contentPackage);
                    try {
                        viewer.launch();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            if (ContentPackageEditor.this.isSelected()) {
                thread.start();
            }
        }
    }

    class ProxyViewRTEHandler
    extends ProxyAction {
        public ProxyViewRTEHandler() {
            super(MainMenu.sharedInstance.actionViewRTE);
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ContentPackageEditor.this.importAndRun();
                }
            };
            if (ContentPackageEditor.this.isSelected()) {
                thread.start();
            }
        }
    }

    class ProxyZipHandler
    extends ProxyAction {
        public ProxyZipHandler() {
            super(MainMenu.sharedInstance.actionZipIt);
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ContentPackageEditor.this.zipIt();
                }
            };
            if (ContentPackageEditor.this.isSelected()) {
                thread.start();
            }
        }
    }

    class ProxySaveHandler
    extends ProxyAction {
        public ProxySaveHandler(MenuAction menuAction) {
            super(menuAction);
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            if (ContentPackageEditor.this.isSelected() && event.getSource() == MainMenu.sharedInstance.actionSave) {
                ContentPackageEditor.this.saveDocument();
            }
            if (ContentPackageEditor.this.isSelected() && event.getSource() == MainMenu.sharedInstance.actionSaveAs) {
                ContentPackageEditor.this.saveAsDocument();
            }
        }
    }
}

