/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import java.io.FileFilter;
import java.util.Hashtable;
import java.util.Vector;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.ReloadHelperProfile;
import uk.ac.reload.editor.prefs.ReloadEditorPrefs;

public class ContentPackageHelperProfile
extends ReloadHelperProfile {
    protected static Hashtable _cpProfilesTable = new Hashtable();

    public ContentPackageHelperProfile(File fileProfile) throws ReloadEditorException {
        super(fileProfile);
    }

    public static ContentPackageHelperProfile getContentPackageProfile(File fileProfile) throws ReloadEditorException {
        if (fileProfile == null) {
            return null;
        }
        ContentPackageHelperProfile cpProfile = (ContentPackageHelperProfile)_cpProfilesTable.get(fileProfile);
        if (cpProfile == null && fileProfile.exists()) {
            cpProfile = new ContentPackageHelperProfile(fileProfile);
            _cpProfilesTable.put(fileProfile, cpProfile);
        }
        return cpProfile;
    }

    public static ContentPackageHelperProfile[] getContentPackageHelperProfiles() {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return ReloadUtils.getFileExtension(file).equals("xml");
            }
        };
        Vector<ContentPackageHelperProfile> v = new Vector<ContentPackageHelperProfile>();
        File[] files = ReloadEditorDocumentHandler.folderCPProfile.listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    ContentPackageHelperProfile profile = ContentPackageHelperProfile.getContentPackageProfile(files[i]);
                    v.addElement(profile);
                    continue;
                }
                catch (ReloadEditorException ex) {
                    // empty catch block
                }
            }
        }
        Object[] profiles = new ContentPackageHelperProfile[v.size()];
        v.copyInto(profiles);
        return profiles;
    }

    @Override
    public File getVocabFile() {
        return new File(ReloadEditorDocumentHandler.folderCPVocab, this.getVocabularyFileName());
    }

    @Override
    public File getSchemaHelperFile() {
        return new File(ReloadEditorDocumentHandler.folderCPSchemahelper, this.getSchemaHelperFileName());
    }

    public static ContentPackageHelperProfile getDefaultContentPackageHelperProfile() throws ReloadEditorException {
        String defProfileName = ReloadEditorPrefs.getInstance().getValue("default_cpprofile");
        if (defProfileName == null) {
            return ContentPackageHelperProfile.getContentPackageProfile(ReloadEditorDocumentHandler.fileDefaultCPProfile);
        }
        File file = new File(ReloadEditorDocumentHandler.folderCPProfile, defProfileName);
        if (file.exists()) {
            return ContentPackageHelperProfile.getContentPackageProfile(file);
        }
        return ContentPackageHelperProfile.getContentPackageProfile(ReloadEditorDocumentHandler.fileDefaultCPProfile);
    }
}

