/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.ReloadEditorSchemaController;
import uk.ac.reload.editor.contentpackaging.ContentPackageHelperProfile;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class ContentPackageSchemaController
extends ReloadEditorSchemaController {
    public ContentPackageSchemaController() {
    }

    public ContentPackageSchemaController(File fileSchema) {
        try {
            this.loadSchema(fileSchema);
            ContentPackageHelperProfile defProfile = ContentPackageHelperProfile.getDefaultContentPackageHelperProfile();
            this.setHelperProfile(defProfile);
        }
        catch (ReloadEditorException ex) {
            ErrorDialogBox.showWarning("Could not load Default Content Package Profile", "Load Profile", ex);
        }
    }

    public static ContentPackageSchemaController getDefaultSchemaController() {
        return (ContentPackageSchemaController)ReloadEditorSchemaController.getReloadSchemaController(IMSDocumentHandler.IMSCP_113);
    }

    @Override
    public String getRootElementName() {
        return "manifest";
    }

    public static boolean isAcceptedNamespaceURI(String nameSpaceURI) {
        for (int i = 0; i < IMSDocumentHandler.IMSCP_NAMESPACE_URIS.length; ++i) {
            if (!nameSpaceURI.equals(IMSDocumentHandler.IMSCP_NAMESPACE_URIS[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isReferencingElement(Element element) {
        String idref = element.getAttributeValue("identifierref");
        return idref != null && !idref.equals("");
    }

    @Override
    public Icon getLeafIcon(Element element) {
        if (!ContentPackageSchemaController.isAcceptedNamespaceURI(element.getNamespace().getURI())) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_MDLEAF);
        }
        String elementName = element.getName();
        if (elementName.equals("manifest")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_CP);
        }
        if (elementName.equals("organizations")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_ORGS);
        }
        if (elementName.equals("organization")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_ORG);
        }
        if (elementName.equals("item")) {
            if (this.isReferencingElement(element)) {
                return ReloadUIManager.getIcon(ReloadEditor.ICON_SCO);
            }
            return ReloadUIManager.getIcon(ReloadEditor.ICON_ITEM);
        }
        if (elementName.equals("file")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_FILE);
        }
        if (elementName.equals("metadata")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_MD);
        }
        if (elementName.equals("resources")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_RESOURCES);
        }
        if (elementName.equals("resource")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_RESOURCE);
        }
        if (elementName.equals("dependency")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_DEPENDENCY);
        }
        return ReloadUIManager.getIcon(ReloadEditor.ICON_MDLEAF);
    }

    @Override
    public Icon getLeafIcon(ReloadSchemaElement schemaElement) {
        if (!ContentPackageSchemaController.isAcceptedNamespaceURI(schemaElement.getNamespace().getURI())) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_MDLEAF);
        }
        String elementName = schemaElement.getName();
        if (elementName.equals("manifest")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_CP);
        }
        if (elementName.equals("organizations")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_ORGS);
        }
        if (elementName.equals("organization")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_ORG);
        }
        if (elementName.equals("item")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_ITEM);
        }
        if (elementName.equals("file")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_FILE);
        }
        if (elementName.equals("metadata")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_MD);
        }
        if (elementName.equals("resources")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_RESOURCES);
        }
        if (elementName.equals("resource")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_RESOURCE);
        }
        if (elementName.equals("dependency")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_DEPENDENCY);
        }
        return ReloadUIManager.getIcon(ReloadEditor.ICON_MDLEAF);
    }

    @Override
    public Icon getOpenIcon(Element element) {
        return this.getLeafIcon(element);
    }

    @Override
    public Icon getOpenIcon(ReloadSchemaElement schemaElement) {
        return this.getLeafIcon(schemaElement);
    }

    @Override
    public Icon getClosedIcon(Element element) {
        return this.getLeafIcon(element);
    }

    @Override
    public Icon getClosedIcon(ReloadSchemaElement schemaElement) {
        return this.getLeafIcon(schemaElement);
    }

    public void copySchemaFilesToFolder(File projectFolder) throws ReloadEditorException {
        try {
            ReloadUtils.copyFolder(new File(ReloadEditorDocumentHandler.SCHEMASHIPPEDFOLDER, IMSDocumentHandler.IMSMD_122), projectFolder, null);
            ReloadUtils.copyFolder(new File(ReloadEditorDocumentHandler.SCHEMASHIPPEDFOLDER, IMSDocumentHandler.IMSCP_113), projectFolder, null);
        }
        catch (IOException ex) {
            throw new ReloadEditorException(ex);
        }
    }
}

