/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.contentpackaging.ContentPackage;

public class ContentPackageViewer {
    protected ContentPackage _contentPackage;

    public ContentPackageViewer(ContentPackage cp) {
        this._contentPackage = cp;
    }

    public void launch() {
        File navPage = this.createNavPage();
        File mainPage = this.createMainPage(navPage);
        ReloadUtils.launchFile(mainPage);
    }

    protected File createNavPage() {
        File file = null;
        BufferedWriter out = null;
        try {
            file = File.createTempFile("~rld-", ".html");
            if (file != null) {
                file.deleteOnExit();
                out = new BufferedWriter(new FileWriter(file));
                out.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
                out.write("<html>");
                out.write("<head>");
                out.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
                out.write("<style type=\"text/css\">");
                out.write("<!-- ");
                out.write("body { font-family:Verdana, Arial, Helvetica, sans-serif; font-size:13px; font-weight:bold; }");
                out.write("A { font-weight:bold; text-decoration:none; }");
                out.write("A:link { color:#0033CC; }");
                out.write("A:visited { color:#025999; }");
                out.write("A:hover { color:#ff9900; }");
                out.write(" -->");
                out.write("</style>");
                out.write("</head>");
                out.write("<body bgcolor=\"#9eb0b5\">");
                out.write("<strong><font color=\"#0000CC\">");
                out.write(this._contentPackage.getProjectName());
                out.write("</font></strong>");
                out.write("<hr WIDTH=\"100%\">");
                this.addLinks((Element)this._contentPackage.getRootElement().clone(), out, 0);
                out.write("</body>");
                out.write("</html>");
                out.flush();
                out.close();
            }
            return file;
        }
        catch (Exception ex) {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException ex1) {
                // empty catch block
            }
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            return file;
        }
    }

    private void addLinks(Element element, BufferedWriter out, int indent) throws IOException {
        String name = element.getName();
        if (name.equals("organization") && this._contentPackage.isDocumentNamespace(element)) {
            String title = "Organization";
            Element titleElement = element.getChild("title", element.getNamespace());
            if (titleElement != null && !titleElement.getText().equals("")) {
                title = titleElement.getText();
            }
            this.writeItem(out, title, indent);
        } else if (name.equals("item") && this._contentPackage.isDocumentNamespace(element)) {
            Element ref_element;
            StringBuffer sb = new StringBuffer();
            String title = "Item";
            Element titleElement = element.getChild("title", element.getNamespace());
            if (titleElement != null && !titleElement.getText().equals("")) {
                title = titleElement.getText();
            }
            if ((ref_element = this._contentPackage.getReferencedElement(element)) != null) {
                String ref_name = ref_element.getName();
                if (ref_name.equals("resource")) {
                    String url = this._contentPackage.getURL(element);
                    if (url != null) {
                        sb.append("<a href=\"");
                        sb.append(url);
                        sb.append("\" target=\"main\">");
                        sb.append(title);
                        sb.append("</a>");
                    } else {
                        sb.append(title);
                    }
                } else if (ref_name.equals("manifest")) {
                    sb.append(title);
                    Element orgsElement = ref_element.getChild("organizations", ref_element.getNamespace());
                    if (orgsElement != null) {
                        ref_element = this._contentPackage.getDefaultOrganization(orgsElement);
                    }
                    if (ref_element != null) {
                        for (Element ref_child : ref_element.getChildren()) {
                            element.addContent((Element)ref_child.clone());
                        }
                    }
                }
            } else {
                sb.append(title);
            }
            this.writeItem(out, sb.toString(), indent);
        } else if (name.equals("manifest") && this._contentPackage.isDocumentNamespace(element) && element.getParent() != null) {
            this.writeItem(out, "<font color=\"#006600\">Manifest</font>", indent);
            ++indent;
        }
        boolean indented = false;
        for (Element child : element.getChildren()) {
            String child_name = child.getName();
            if (!indented && child_name.equals("item")) {
                ++indent;
                indented = true;
            }
            this.addLinks(child, out, indent);
        }
    }

    private void writeItem(BufferedWriter out, String s, int indent) throws IOException {
        out.write("<p>");
        for (int i = 0; i < indent; ++i) {
            out.write("&nbsp;&nbsp;&nbsp;");
        }
        out.write(s);
        out.write("</p>");
    }

    private File createMainPage(File navPage) {
        File file = null;
        BufferedWriter out = null;
        try {
            file = File.createTempFile("~rld-", ".html");
            if (file != null) {
                file.deleteOnExit();
                out = new BufferedWriter(new FileWriter(file));
                out.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
                out.write("<html>");
                out.write("<head>");
                out.write("<title>");
                out.write("Content Package - " + this._contentPackage.getProjectName());
                out.write("</title>");
                out.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
                out.write("<frameset framespacing=\"0\" border=\"0\" cols=\"220,*\">");
                out.write("<frame scrolling=\"auto\" name=\"navbar\" src=\"");
                if (ReloadUtils.getOS() == 0) {
                    out.write("file:///private" + navPage.toString());
                } else {
                    out.write("file:///" + navPage.toString());
                }
                out.write("\">");
                out.write("<frame name=\"main\" scrolling=\"auto\">");
                out.write("</frameset>");
                out.write("</head>");
                out.write("<body></body>");
                out.write("</html>");
                out.flush();
                out.close();
            }
            return file;
        }
        catch (Exception ex) {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException ex1) {
                // empty catch block
            }
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            return file;
        }
    }
}

