/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.menu.ReloadMenuEvent;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.ContentPackageEditor;
import uk.ac.reload.editor.contentpackaging.SCORM1_3SchemaController;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.dom.ReloadDomException;

public class ProxyConvertHandler
extends ProxyAction {
    private ContentPackage mContentPackage;
    private ContentPackageEditor mEditor;

    public ProxyConvertHandler(ContentPackage contentPackage, ContentPackageEditor editor) {
        super(MainMenu.sharedInstance.thirdToFourthConversion);
        this.mContentPackage = contentPackage;
        this.mEditor = editor;
    }

    @Override
    public void menuActionPerformed(ReloadMenuEvent menuEvent) {
        this.updateSchemaVersion();
        this.updateSchemas();
        this.updateView();
    }

    private void updateView() {
        this.mEditor.dispose();
        ReloadEditorDocumentHandler.openFile(ReloadEditor.getInstance(), new File(this.mContentPackage.getProjectFolder() + File.separator + "imsmanifest.xml"));
    }

    private void updateSchemas() {
        SCORM1_3SchemaController cpController = SCORM1_3SchemaController.getDefaultSCORMSchemaController(true);
        try {
            cpController.copySchemaFilesToFolder(this.mContentPackage.getProjectFolder());
        }
        catch (ReloadEditorException e1) {
            e1.printStackTrace();
        }
    }

    private void updateSchemaVersion() {
        Namespace ns = Namespace.getNamespace(IMSDocumentHandler.IMSCP_NAMESPACE_URI_113);
        Element root = this.mContentPackage.getRootElement();
        Element metadata = root.getChild("metadata", ns);
        Element schemaVersion = metadata.getChild("schemaversion", ns);
        schemaVersion.setText("2004 4th Edition");
        this.mContentPackage.changedElement(this, schemaVersion);
        try {
            this.mContentPackage.saveDocument();
        }
        catch (ReloadDomException e) {
            e.printStackTrace();
        }
    }
}

