/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import uk.ac.reload.editor.contentpackaging.htmlparser.HTMLParser;

public class ReloadResource
extends File {
    public ReloadResource(File resource) {
        super(resource.toString());
    }

    public File[] getDependencies(File projectFolder) {
        HTMLParser dep = new HTMLParser(this, projectFolder, false);
        return dep.getAllLinks();
    }

    public ReloadResource[] getChildren() {
        File file;
        int i;
        if (!this.isDirectory()) {
            return null;
        }
        Vector<ReloadResource> v = new Vector<ReloadResource>();
        File[] files = this.listFiles();
        for (i = 0; i < files.length; ++i) {
            file = files[i];
            if (!file.isDirectory()) continue;
            v.add(new ReloadResource(files[i]));
        }
        for (i = 0; i < files.length; ++i) {
            file = files[i];
            if (file.isDirectory()) continue;
            v.add(new ReloadResource(files[i]));
        }
        Object[] resources = new ReloadResource[v.size()];
        v.copyInto(resources);
        return resources;
    }

    public boolean doParentDirectoriesExist() {
        return this.getParentFile().exists();
    }

    public String getFriendlyName() {
        String s = "";
        if (this.exists()) {
            FileSystemView view = FileSystemView.getFileSystemView();
            s = view.getSystemTypeDescription(this);
        }
        return s;
    }

    public Icon getResourceIcon() {
        Icon icon = null;
        if (this.exists()) {
            FileSystemView view = FileSystemView.getFileSystemView();
            icon = view.getSystemIcon(this);
        }
        return icon;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

