/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.gui.layout.XYConstraints;
import uk.ac.reload.dweezil.gui.layout.XYLayout;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadElementBinding;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.gui.ReloadElementAttributePanel;
import uk.ac.reload.editor.gui.ReloadElementEditor;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaController;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SCORM1_2EditorDialog
extends JDialog {
    protected ContentPackage _contentPackage;
    protected Element _itemElement;
    protected ReloadSchemaElement _schema_itemElement;
    protected JList _itemListBox;
    protected ReloadElementAttributePanel _prereqEditor;
    protected int WIDTH = 780;
    protected int HEIGHT = 555;

    public SCORM1_2EditorDialog(ContentPackage contentPackage, Element itemElement, ReloadSchemaElement schema_itemElement) {
        super(ReloadEditor.getInstance(), "SCORM Properties", true);
        this._itemElement = itemElement;
        this._contentPackage = contentPackage;
        this._schema_itemElement = schema_itemElement;
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SCORM1_2EditorDialog.this.dispose();
            }
        });
        JPanel mainPanel = this.createMainPanel();
        this.getContentPane().add((Component)mainPanel, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(this.WIDTH, this.HEIGHT);
        this.setLocationRelativeTo(ReloadEditor.getInstance());
    }

    protected JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new XYLayout());
        int x = 5;
        int y = 5;
        JPanel prereqPanel = this.createPrerequisitesPanel();
        mainPanel.add((Component)prereqPanel, new XYConstraints(x, y, this.WIDTH - 15, 250));
        JPanel otherPanel = this.createSCORMElementsPanel();
        mainPanel.add((Component)otherPanel, new XYConstraints(x, y += 265, this.WIDTH - 15, 220));
        return mainPanel;
    }

    protected JPanel createPrerequisitesPanel() {
        JPanel panel = new JPanel(new XYLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        ReloadSchemaController schemaController = this._contentPackage.getReloadSchemaController();
        ReloadSchemaElement prereqSchemaElement = this._schema_itemElement.getChild("prerequisites", IMSDocumentHandler.ADLCP_NAMESPACE_12);
        if (prereqSchemaElement != null) {
            int x = 5;
            int y = 0;
            String name = schemaController.getElementFriendlyName(prereqSchemaElement.getDomPath());
            JLabel nameLabel = new JLabel();
            nameLabel.setForeground(Color.BLUE);
            nameLabel.setFont(ReloadUIManager.boldFont12);
            nameLabel.setText(name);
            panel.add((Component)nameLabel, new XYConstraints(x, y, 100, 25));
            y += 35;
            Element element = this._itemElement.getChild(prereqSchemaElement.getName(), prereqSchemaElement.getNamespace());
            ReloadElementBinding eb = new ReloadElementBinding(element, prereqSchemaElement, this._contentPackage);
            if (element == null) {
                eb.setParentElement(this._itemElement);
            }
            this._prereqEditor = new ReloadElementAttributePanel();
            this._prereqEditor.setElement(eb);
            panel.add((Component)this._prereqEditor, new XYConstraints(x, y, 340, 200));
            JButton addButton = new JButton(ReloadUIManager.getIcon(ReloadEditor.ICON_LEFT));
            panel.add((Component)addButton, new XYConstraints(345, 120, 0, 0));
            addButton.addActionListener(new AddClick(this._prereqEditor));
            this._itemListBox = new JList(new ItemListModel());
            this._itemListBox.setSelectionMode(0);
            this._itemListBox.addMouseListener(new AddClick(this._prereqEditor));
            panel.add((Component)new JScrollPane(this._itemListBox), new XYConstraints(405, y, 340, 200));
        }
        return panel;
    }

    protected JPanel createSCORMElementsPanel() {
        JPanel panel = new JPanel(new XYLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        ReloadSchemaController schemaController = this._contentPackage.getReloadSchemaController();
        int x = 5;
        int y = 0;
        ReloadSchemaElement maxtimeallowedSchemaElement = this._schema_itemElement.getChild("maxtimeallowed", IMSDocumentHandler.ADLCP_NAMESPACE_12);
        this.addElement(maxtimeallowedSchemaElement, panel, x, y, 120, 25);
        ReloadSchemaElement schemaElement = this._schema_itemElement.getChild("timelimitaction", IMSDocumentHandler.ADLCP_NAMESPACE_12);
        this.addElement(schemaElement, panel, x, y += 60, 320, 100);
        x = 360;
        y = 0;
        schemaElement = this._schema_itemElement.getChild("datafromlms", IMSDocumentHandler.ADLCP_NAMESPACE_12);
        this.addElement(schemaElement, panel, x, y, 200, 25);
        schemaElement = this._schema_itemElement.getChild("masteryscore", IMSDocumentHandler.ADLCP_NAMESPACE_12);
        this.addElement(schemaElement, panel, x, y += 60, 200, 25);
        return panel;
    }

    protected void addElement(ReloadSchemaElement schemaElement, JPanel panel, int x, int y, int width, int height) {
        if (schemaElement != null) {
            ReloadSchemaController schemaController = this._contentPackage.getReloadSchemaController();
            String name = schemaController.getElementFriendlyName(schemaElement.getDomPath());
            JLabel nameLabel = new JLabel();
            nameLabel.setForeground(Color.BLUE);
            nameLabel.setFont(ReloadUIManager.boldFont12);
            nameLabel.setText(name);
            panel.add((Component)nameLabel, new XYConstraints(x, y, 100, 25));
            y += 30;
            Element element = this._itemElement.getChild(schemaElement.getName(), schemaElement.getNamespace());
            ReloadElementBinding eb = new ReloadElementBinding(element, schemaElement, this._contentPackage);
            if (element == null) {
                eb.setParentElement(this._itemElement);
            }
            ReloadElementEditor elementEditor = new ReloadElementEditor();
            elementEditor.setElement(eb);
            panel.add((Component)elementEditor, new XYConstraints(x, y, width, height));
        }
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton btnOK = new JButton("Done");
        btnOK.addActionListener(new OKClick());
        this.getRootPane().setDefaultButton(btnOK);
        buttonPanel.add(btnOK);
        return buttonPanel;
    }

    @Override
    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SCORM1_2EditorDialog.this._prereqEditor.getSplitpane().setDividerLocation(0.7);
            }
        });
        super.show();
    }

    protected void finish() {
        this.dispose();
    }

    @Override
    public void dispose() {
        try {
            super.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class ItemListModel
    extends AbstractListModel {
        Vector v = new Vector();

        public ItemListModel() {
            Element manifestElement = SCORM1_2EditorDialog.this._contentPackage.getParentManifestElement(SCORM1_2EditorDialog.this._itemElement);
            if (manifestElement != null) {
                Element[] items = SCORM1_2EditorDialog.this._contentPackage.getElementsInManifest(manifestElement, "item", manifestElement.getNamespace());
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].equals(SCORM1_2EditorDialog.this._itemElement)) continue;
                    ID_Mapping mapping = new ID_Mapping(items[i]);
                    this.v.add(mapping);
                }
            }
        }

        @Override
        public int getSize() {
            return this.v.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.v.elementAt(index);
        }
    }

    class ID_Mapping {
        Element _element;

        ID_Mapping(Element element) {
            this._element = element;
        }

        public String getIdentifier() {
            return this._element.getAttributeValue("identifier");
        }

        public String toString() {
            return SCORM1_2EditorDialog.this._contentPackage.getElementDisplayName(this._element) + "   (" + this.getIdentifier() + ")";
        }
    }

    private class AddClick
    extends AbstractAction
    implements MouseListener {
        ReloadElementAttributePanel _elementEditor;

        public AddClick(ReloadElementAttributePanel elementEditor) {
            this._elementEditor = elementEditor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.addText();
        }

        private void addText() {
            String id;
            Object object = SCORM1_2EditorDialog.this._itemListBox.getSelectedValue();
            if (object instanceof ID_Mapping && (id = ((ID_Mapping)object).getIdentifier()) != null) {
                this._elementEditor.getElementEditor().insertText(id);
                this._elementEditor.getElementEditor().setFocus();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.addText();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class OKClick
    extends AbstractAction {
        private OKClick() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SCORM1_2EditorDialog.this.finish();
        }
    }
}

