/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import java.io.FileFilter;
import java.util.Hashtable;
import java.util.Vector;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.contentpackaging.ContentPackageHelperProfile;
import uk.ac.reload.editor.prefs.ReloadEditorPrefs;

public class SCORM1_2HelperProfile
extends ContentPackageHelperProfile {
    protected static Hashtable _scormProfilesTable = new Hashtable();

    public SCORM1_2HelperProfile(File fileProfile) throws ReloadEditorException {
        super(fileProfile);
    }

    public static SCORM1_2HelperProfile getSCORM1_2Profile(File fileProfile) throws ReloadEditorException {
        if (fileProfile == null) {
            return null;
        }
        SCORM1_2HelperProfile scormProfile = (SCORM1_2HelperProfile)_scormProfilesTable.get(fileProfile);
        if (scormProfile == null && fileProfile.exists()) {
            scormProfile = new SCORM1_2HelperProfile(fileProfile);
            _scormProfilesTable.put(fileProfile, scormProfile);
        }
        return scormProfile;
    }

    public static SCORM1_2HelperProfile[] getSCORM1_2HelperProfiles() {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return ReloadUtils.getFileExtension(file).equals("xml");
            }
        };
        Vector<SCORM1_2HelperProfile> v = new Vector<SCORM1_2HelperProfile>();
        File[] files = ReloadEditorDocumentHandler.folderSCORM1_2Profile.listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    SCORM1_2HelperProfile profile = SCORM1_2HelperProfile.getSCORM1_2Profile(files[i]);
                    v.addElement(profile);
                    continue;
                }
                catch (ReloadEditorException ex) {
                    // empty catch block
                }
            }
        }
        Object[] profiles = new SCORM1_2HelperProfile[v.size()];
        v.copyInto(profiles);
        return profiles;
    }

    @Override
    public File getVocabFile() {
        return new File(ReloadEditorDocumentHandler.folderSCORM1_2Vocab, this.getVocabularyFileName());
    }

    @Override
    public File getSchemaHelperFile() {
        return new File(ReloadEditorDocumentHandler.folderSCORM1_2Schemahelper, this.getSchemaHelperFileName());
    }

    public static SCORM1_2HelperProfile getDefaultSCORM1_2HelperProfile() throws ReloadEditorException {
        String defProfileName = ReloadEditorPrefs.getInstance().getValue("default_scormprofile");
        if (defProfileName == null) {
            return SCORM1_2HelperProfile.getSCORM1_2Profile(ReloadEditorDocumentHandler.fileDefaultSCORM1_2Profile);
        }
        File file = new File(ReloadEditorDocumentHandler.folderSCORM1_2Profile, defProfileName);
        if (file.exists()) {
            return SCORM1_2HelperProfile.getSCORM1_2Profile(file);
        }
        return SCORM1_2HelperProfile.getSCORM1_2Profile(ReloadEditorDocumentHandler.fileDefaultSCORM1_2Profile);
    }
}

