/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.ContentPackageSchemaController;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchema;

public class SCORM1_2Package
extends ContentPackage {
    static final String[] scorm_comments = new String[]{"This is a Reload version " + ReloadEditor.VERSION + " SCORM 1.2 Content Package document", "Spawned from the Reload Content Package Generator - http://www.reload.ac.uk"};

    public SCORM1_2Package() {
    }

    public SCORM1_2Package(File file, Document doc, ContentPackageSchemaController schemaController) {
        super(file, doc, schemaController);
    }

    @Override
    protected void newDocument(File projectFolder, ContentPackageSchemaController cpController, MetadataSchemaController mdController, String metadataVersion) throws ReloadEditorException {
        super.newDocument(projectFolder, cpController, mdController, metadataVersion);
        Element root = this.getDocument().getRootElement();
        ReloadSchema cpSchema = cpController.getReloadSchema();
        root.addNamespaceDeclaration(IMSDocumentHandler.ADLCP_NAMESPACE_12);
        Attribute att = root.getAttribute(IMSDocumentHandler.XSI_SchemaLocation, IMSDocumentHandler.XSI_Namespace);
        if (att != null) {
            String value = att.getValue();
            if (value == null) {
                value = "";
            }
            StringBuffer schemaLocationURI = new StringBuffer(value);
            schemaLocationURI.append(" ");
            schemaLocationURI.append(IMSDocumentHandler.ADLCP_NAMESPACE_12.getURI());
            schemaLocationURI.append(" ");
            schemaLocationURI.append(cpSchema.getSchemaName(IMSDocumentHandler.ADLCP_NAMESPACE_12.getURI()));
            att.setValue(schemaLocationURI.toString());
        }
    }

    @Override
    public String[] getComments() {
        return scorm_comments;
    }
}

