/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import org.jdom.Document;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.ContentPackageEditor;
import uk.ac.reload.editor.contentpackaging.ContentPackageHelperProfile;
import uk.ac.reload.editor.contentpackaging.SCORM1_2HelperProfile;
import uk.ac.reload.editor.contentpackaging.SCORM1_2Package;
import uk.ac.reload.editor.contentpackaging.SCORM1_2SchemaController;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.moonunit.IMSDocumentHandler;

public class SCORM1_2PackageEditor
extends ContentPackageEditor {
    public SCORM1_2PackageEditor() {
        this.setFrameIcon(ReloadEditor.ICON_CPSCORM);
        this.setTitle("SCORM Package");
    }

    @Override
    protected void setContentPackage(ContentPackage contentPackage) {
        super.setContentPackage(contentPackage);
        this.setTitle("SCORM Package - " + contentPackage.getProjectName());
    }

    public void setDocument(File file, Document doc, SCORM1_2SchemaController schemaController) throws ReloadEditorException {
        this._contentPackage = new SCORM1_2Package(file, doc, schemaController);
        this.setContentPackage(this._contentPackage);
    }

    public void newContentPackage(File projectFolder) throws ReloadEditorException {
        this._contentPackage = new SCORM1_2Package();
        SCORM1_2SchemaController cpController = SCORM1_2SchemaController.getDefaultSCORMSchemaController();
        MetadataSchemaController mdController = SCORM1_2SchemaController.getDefaultMetadataSchemaController();
        this._contentPackage.newContentPackage(projectFolder, cpController, mdController, IMSDocumentHandler.IMSMD_122);
        this.setContentPackage(this._contentPackage);
    }

    @Override
    public ContentPackageHelperProfile[] getHelperProfiles() {
        return SCORM1_2HelperProfile.getSCORM1_2HelperProfiles();
    }
}

