/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.ReloadEditorSchemaController;
import uk.ac.reload.editor.contentpackaging.ContentPackageSchemaController;
import uk.ac.reload.editor.contentpackaging.SCORM1_2HelperProfile;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SCORM1_2SchemaController
extends ContentPackageSchemaController {
    public SCORM1_2SchemaController(File fileSchema) {
        try {
            this.loadSchema(fileSchema);
            SCORM1_2HelperProfile defProfile = SCORM1_2HelperProfile.getDefaultSCORM1_2HelperProfile();
            this.setHelperProfile(defProfile);
        }
        catch (ReloadEditorException ex) {
            ErrorDialogBox.showWarning("Could not load Default Content Package Profile", "Load Profile", ex);
        }
    }

    public static SCORM1_2SchemaController getDefaultSCORMSchemaController() {
        return (SCORM1_2SchemaController)ReloadEditorSchemaController.getReloadSchemaController(IMSDocumentHandler.ADLCP_120_112);
    }

    public static MetadataSchemaController getDefaultMetadataSchemaController() {
        return (MetadataSchemaController)ReloadEditorSchemaController.getReloadSchemaController(IMSDocumentHandler.IMSMD_121);
    }

    @Override
    public Icon getLeafIcon(Element element) {
        String elementName = element.getName();
        if (elementName.equals("manifest")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_CPSCORM);
        }
        if (elementName.equals("item")) {
            if (this.hasScormElements(element)) {
                if (this.isReferencingElement(element)) {
                    return ReloadUIManager.getIcon(ReloadEditor.ICON_SCOSCORM);
                }
                return ReloadUIManager.getIcon(ReloadEditor.ICON_ITEMSCORM);
            }
            return super.getLeafIcon(element);
        }
        if (IMSDocumentHandler.ADLCP_NAMESPACE_12.equals(element.getNamespace())) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_ADL);
        }
        return super.getLeafIcon(element);
    }

    @Override
    public Icon getLeafIcon(ReloadSchemaElement schemaElement) {
        String elementName = schemaElement.getName();
        if (elementName.equals("manifest")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_CPSCORM);
        }
        if (IMSDocumentHandler.ADLCP_NAMESPACE_12.equals(schemaElement.getNamespace())) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_ADL);
        }
        return super.getLeafIcon(schemaElement);
    }

    @Override
    public void copySchemaFilesToFolder(File projectFolder) throws ReloadEditorException {
        try {
            ReloadUtils.copyFolder(new File(ReloadEditorDocumentHandler.SCHEMASHIPPEDFOLDER, IMSDocumentHandler.IMSMD_121), projectFolder, null);
            ReloadUtils.copyFolder(new File(ReloadEditorDocumentHandler.SCHEMASHIPPEDFOLDER, IMSDocumentHandler.IMSCP_112), projectFolder, null);
            ReloadUtils.copyFolder(new File(ReloadEditorDocumentHandler.SCHEMASHIPPEDFOLDER, IMSDocumentHandler.ADLCP_120_112), projectFolder, null);
        }
        catch (IOException ex) {
            throw new ReloadEditorException(ex);
        }
    }

    @Override
    public boolean isReferencingElement(Element element) {
        String idref = element.getAttributeValue("identifierref");
        return idref != null && !idref.equals("");
    }

    public boolean hasScormElements(Element element) {
        for (Element child : element.getChildren()) {
            if (!child.getNamespace().equals(IMSDocumentHandler.ADLCP_NAMESPACE_12)) continue;
            return true;
        }
        return false;
    }
}

