/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import java.io.FileFilter;
import java.util.Hashtable;
import java.util.Vector;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.contentpackaging.ContentPackageHelperProfile;
import uk.ac.reload.editor.prefs.ReloadEditorPrefs;

public class SCORM1_3HelperProfile
extends ContentPackageHelperProfile {
    protected static Hashtable _scormProfilesTable = new Hashtable();

    public SCORM1_3HelperProfile(File fileProfile) throws ReloadEditorException {
        super(fileProfile);
    }

    public static SCORM1_3HelperProfile getSCORM1_3Profile(File fileProfile) throws ReloadEditorException {
        if (fileProfile == null) {
            return null;
        }
        SCORM1_3HelperProfile scormProfile = (SCORM1_3HelperProfile)_scormProfilesTable.get(fileProfile);
        if (scormProfile == null && fileProfile.exists()) {
            scormProfile = new SCORM1_3HelperProfile(fileProfile);
            _scormProfilesTable.put(fileProfile, scormProfile);
        }
        return scormProfile;
    }

    public static SCORM1_3HelperProfile[] getSCORM1_3HelperProfiles() {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return ReloadUtils.getFileExtension(file).equals("xml");
            }
        };
        Vector<SCORM1_3HelperProfile> v = new Vector<SCORM1_3HelperProfile>();
        File[] files = ReloadEditorDocumentHandler.folderSCORM1_3Profile.listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    SCORM1_3HelperProfile profile = SCORM1_3HelperProfile.getSCORM1_3Profile(files[i]);
                    v.addElement(profile);
                    continue;
                }
                catch (ReloadEditorException ex) {
                    // empty catch block
                }
            }
        }
        Object[] profiles = new SCORM1_3HelperProfile[v.size()];
        v.copyInto(profiles);
        return profiles;
    }

    @Override
    public File getVocabFile() {
        return new File(ReloadEditorDocumentHandler.folderSCORM1_3Vocab, this.getVocabularyFileName());
    }

    @Override
    public File getSchemaHelperFile() {
        return new File(ReloadEditorDocumentHandler.folderSCORM1_3Schemahelper, this.getSchemaHelperFileName());
    }

    public static SCORM1_3HelperProfile getDefaultSCORM1_3HelperProfile() throws ReloadEditorException {
        String defProfileName = ReloadEditorPrefs.getInstance().getValue("default_scormprofile");
        if (defProfileName == null) {
            return SCORM1_3HelperProfile.getSCORM1_3Profile(ReloadEditorDocumentHandler.fileDefaultSCORM1_3Profile);
        }
        File file = new File(ReloadEditorDocumentHandler.folderSCORM1_3Profile, defProfileName);
        if (file.exists()) {
            return SCORM1_3HelperProfile.getSCORM1_3Profile(file);
        }
        return SCORM1_3HelperProfile.getSCORM1_3Profile(ReloadEditorDocumentHandler.fileDefaultSCORM1_3Profile);
    }
}

