/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.ContentPackageSchemaController;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchema;

public class SCORM1_3Package
extends ContentPackage {
    static final String[] scorm_comments = new String[]{"This is a Reload version " + ReloadEditor.VERSION + " SCORM 2004 Content Package document", "Spawned from the Reload Content Package Generator - http://www.reload.ac.uk"};
    private boolean mFourthEdition = true;

    public SCORM1_3Package(boolean fourthEdition) {
        this.setFourthEdition(fourthEdition);
    }

    public SCORM1_3Package(File file, Document doc, ContentPackageSchemaController schemaController, boolean fourthEdition) {
        super(file, doc, schemaController);
        this.setFourthEdition(fourthEdition);
    }

    @Override
    protected void newDocument(File projectFolder, ContentPackageSchemaController cpController, MetadataSchemaController mdController, String metadataVersion) throws ReloadEditorException {
        super.newDocument(projectFolder, cpController, mdController, IMSDocumentHandler.LOM_10);
        Element root = this.getDocument().getRootElement();
        root.setAttribute("version", "1.3");
        ReloadSchema cpSchema = cpController.getReloadSchema();
        root.addNamespaceDeclaration(IMSDocumentHandler.ADLCP_NAMESPACE_13);
        root.addNamespaceDeclaration(IMSDocumentHandler.IMSSS_NAMESPACE_10);
        root.addNamespaceDeclaration(IMSDocumentHandler.ADLSEQ_NAMESPACE_13);
        root.addNamespaceDeclaration(IMSDocumentHandler.ADLNAV_NAMESPACE_13);
        Attribute att = root.getAttribute(IMSDocumentHandler.XSI_SchemaLocation, IMSDocumentHandler.XSI_Namespace);
        if (att != null) {
            String value = att.getValue();
            if (value == null) {
                value = "";
            }
            StringBuffer schemaLocationURI = new StringBuffer(value);
            schemaLocationURI.append(" ");
            schemaLocationURI.append(IMSDocumentHandler.ADLCP_NAMESPACE_13.getURI());
            schemaLocationURI.append(" ");
            schemaLocationURI.append(cpSchema.getSchemaName(IMSDocumentHandler.ADLCP_NAMESPACE_13.getURI()));
            schemaLocationURI.append(" ");
            schemaLocationURI.append(IMSDocumentHandler.IMSSS_NAMESPACE_10.getURI());
            schemaLocationURI.append(" ");
            schemaLocationURI.append(cpSchema.getSchemaName(IMSDocumentHandler.IMSSS_NAMESPACE_10.getURI()));
            schemaLocationURI.append(" ");
            schemaLocationURI.append(IMSDocumentHandler.ADLSEQ_NAMESPACE_13.getURI());
            schemaLocationURI.append(" ");
            schemaLocationURI.append("adlseq_v1p3.xsd");
            schemaLocationURI.append(" ");
            schemaLocationURI.append(IMSDocumentHandler.ADLNAV_NAMESPACE_13.getURI());
            schemaLocationURI.append(" ");
            schemaLocationURI.append("adlnav_v1p3.xsd");
            att.setValue(schemaLocationURI.toString());
        }
    }

    @Override
    public String[] getComments() {
        return scorm_comments;
    }

    public void setFourthEdition(boolean mFourthEdition) {
        this.mFourthEdition = mFourthEdition;
    }

    public boolean isFourthEdition() {
        return this.mFourthEdition;
    }
}

