/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import org.jdom.Document;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.ContentPackageEditor;
import uk.ac.reload.editor.contentpackaging.ContentPackageHelperProfile;
import uk.ac.reload.editor.contentpackaging.SCORM1_3HelperProfile;
import uk.ac.reload.editor.contentpackaging.SCORM1_3Package;
import uk.ac.reload.editor.contentpackaging.SCORM1_3SchemaController;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.moonunit.IMSDocumentHandler;

public class SCORM1_3PackageEditor
extends ContentPackageEditor {
    public SCORM1_3PackageEditor() {
        this.setFrameIcon(ReloadEditor.ICON_CPSCORM);
        this.setTitle("SCORM 2004 Package");
    }

    @Override
    protected void setContentPackage(ContentPackage contentPackage) {
        super.setContentPackage(contentPackage);
        this.setTitle("SCORM 2004 Package - " + contentPackage.getProjectName());
    }

    public void setDocument(File file, Document doc, SCORM1_3SchemaController schemaController, boolean fourthEditon) throws ReloadEditorException {
        this._contentPackage = new SCORM1_3Package(file, doc, schemaController, fourthEditon);
        this.setContentPackage(this._contentPackage);
    }

    public void newContentPackage(File projectFolder, boolean fourthEdition) throws ReloadEditorException {
        this._contentPackage = new SCORM1_3Package(fourthEdition);
        SCORM1_3SchemaController cpController = SCORM1_3SchemaController.getDefaultSCORMSchemaController(fourthEdition);
        MetadataSchemaController mdController = null;
        mdController = MetadataSchemaController.getDefaultSchemaController1_3();
        this._contentPackage.newContentPackage(projectFolder, cpController, mdController, IMSDocumentHandler.LOM_10);
        this.setContentPackage(this._contentPackage);
    }

    @Override
    public ContentPackageHelperProfile[] getHelperProfiles() {
        return SCORM1_3HelperProfile.getSCORM1_3HelperProfiles();
    }
}

