/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging;

import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorDocumentHandler;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.ReloadEditorSchemaController;
import uk.ac.reload.editor.contentpackaging.ContentPackageSchemaController;
import uk.ac.reload.editor.contentpackaging.SCORM1_3HelperProfile;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class SCORM1_3SchemaController
extends ContentPackageSchemaController {
    private boolean mFourthEdition = true;

    public SCORM1_3SchemaController(File fileSchema, boolean fourthEdition) {
        try {
            this.loadSchema(fileSchema);
            this.mFourthEdition = fourthEdition;
            SCORM1_3HelperProfile defProfile = SCORM1_3HelperProfile.getDefaultSCORM1_3HelperProfile();
            this.setHelperProfile(defProfile);
        }
        catch (ReloadEditorException ex) {
            ErrorDialogBox.showWarning("Could not load Default Content Package Profile", "Load Profile", ex);
        }
    }

    public static SCORM1_3SchemaController getDefaultSCORMSchemaController(boolean fourthEdition) {
        return (SCORM1_3SchemaController)ReloadEditorSchemaController.getReloadSchemaController(fourthEdition ? IMSDocumentHandler.ADLCP_130_4th : IMSDocumentHandler.ADLCP_130_3RD);
    }

    public static MetadataSchemaController getDefaultMetadataSchemaController() {
        return (MetadataSchemaController)ReloadEditorSchemaController.getReloadSchemaController(IMSDocumentHandler.LOM_10);
    }

    public static MetadataSchemaController getHealthCareMetadataSchemaController() {
        return (MetadataSchemaController)ReloadEditorSchemaController.getReloadSchemaController("lom_hc_10");
    }

    @Override
    public Icon getLeafIcon(Element element) {
        String elementName = element.getName();
        if (elementName.equals("manifest")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_CPSCORM);
        }
        if (elementName.equals("item")) {
            if (this.hasScormElements(element)) {
                if (this.isReferencingElement(element)) {
                    return ReloadUIManager.getIcon(ReloadEditor.ICON_SCOSCORM);
                }
                return ReloadUIManager.getIcon(ReloadEditor.ICON_ITEM);
            }
            return super.getLeafIcon(element);
        }
        if (IMSDocumentHandler.ADLCP_NAMESPACE_13.equals(element.getNamespace()) || elementName.equals("presentation") || elementName.equals("navigationInterface") || IMSDocumentHandler.ADLNAV_NAMESPACE_13.equals(element.getNamespace()) || IMSDocumentHandler.ADLSEQ_NAMESPACE_13.equals(element.getNamespace()) || elementName.equals("hideLMSUI")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_ADL);
        }
        return super.getLeafIcon(element);
    }

    @Override
    public Icon getLeafIcon(ReloadSchemaElement schemaElement) {
        String elementName = schemaElement.getName();
        if (elementName.equals("manifest")) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_CPSCORM);
        }
        if (IMSDocumentHandler.ADLCP_NAMESPACE_13.equals(schemaElement.getNamespace()) || IMSDocumentHandler.ADLNAV_NAMESPACE_13.equals(schemaElement.getNamespace()) || IMSDocumentHandler.ADLSEQ_NAMESPACE_13.equals(schemaElement.getNamespace())) {
            return ReloadUIManager.getIcon(ReloadEditor.ICON_ADL);
        }
        return super.getLeafIcon(schemaElement);
    }

    @Override
    public void copySchemaFilesToFolder(File projectFolder) throws ReloadEditorException {
        try {
            ReloadUtils.copyFolder(new File(ReloadEditorDocumentHandler.SCHEMASHIPPEDFOLDER, IMSDocumentHandler.LOM_10), projectFolder, null);
            ReloadUtils.copyFolder(new File(ReloadEditorDocumentHandler.SCHEMASHIPPEDFOLDER, this.mFourthEdition ? IMSDocumentHandler.ADLCP_130_4th : IMSDocumentHandler.ADLCP_130_3RD), projectFolder, null);
        }
        catch (IOException ex) {
            throw new ReloadEditorException(ex);
        }
    }

    @Override
    public boolean isReferencingElement(Element element) {
        String idref = element.getAttributeValue("identifierref");
        return idref != null && !idref.equals("");
    }

    public boolean hasScormElements(Element element) {
        for (Element child : element.getChildren()) {
            if (!child.getNamespace().equals(IMSDocumentHandler.ADLCP_NAMESPACE_13)) continue;
            return true;
        }
        return false;
    }
}

