/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.convert;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ReloadConsoleApplication {
    private static final int SLEEP_UNIT = 600;
    private static final int BLOCK_SIZE = 65500;
    private static byte[] buf = new byte[65500];
    private String cmd;
    public static String WORK_DIR = "Convert2004";
    private Process process;

    public ReloadConsoleApplication(String cmd) {
        this.cmd = cmd;
        this.process = null;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String newCmd) {
        this.cmd = newCmd;
    }

    public String getWorkingDirectory() {
        return WORK_DIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipe(InputStream in, OutputStream out, boolean isBlocking) throws IOException {
        int total = 0;
        InputStream inputStream = in;
        synchronized (inputStream) {
            int nread;
            int navailable;
            while ((navailable = isBlocking ? Integer.MAX_VALUE : in.available()) > 0 && (nread = in.read(buf, 0, Math.min(buf.length, navailable))) >= 0) {
                out.write(buf, 0, nread);
                total += nread;
            }
        }
        out.flush();
    }

    public OutputStream getConsoleInputStreamPipe() {
        if (this.process != null) {
            return this.process.getOutputStream();
        }
        return null;
    }

    public void killProcess() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    public boolean initializeProcess() {
        try {
            File wd = null;
            wd = new File(WORK_DIR);
            this.process = wd != null && wd.exists() ? Runtime.getRuntime().exec(this.cmd, null, wd) : Runtime.getRuntime().exec(this.cmd, null);
            return true;
        }
        catch (Exception e) {
            this.killProcess();
            return false;
        }
    }

    public int launchProcess() {
        int exitVal = 0;
        try {
            boolean isRunning = true;
            while (isRunning) {
                Thread.sleep(600L);
                try {
                    exitVal = this.process.exitValue();
                    isRunning = false;
                }
                catch (IllegalThreadStateException ie) {
                    // empty catch block
                }
                try {
                    ReloadConsoleApplication.pipe(this.process.getErrorStream(), System.err, false);
                    ReloadConsoleApplication.pipe(this.process.getInputStream(), System.out, false);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.killProcess();
        return exitVal;
    }
}

