/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.convert;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import uk.ac.reload.dweezil.DweezilConstants;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.contentpackaging.convert.ReloadConsoleApplication;

public class ReloadConsoleWindow
extends JDialog
implements DweezilConstants {
    protected boolean macKludge = ReloadUtils.getOS() == 0;
    protected JTextArea console;
    private OutputStream keyStream;
    private PrintStream oldOutput = null;
    private ReloadConsoleApplication app;

    public ReloadConsoleWindow(String title, String cmd) {
        super((Frame)ReloadEditor.getInstance(), title);
        this.getContentPane().setLayout(new BorderLayout());
        this.console = new JTextArea();
        this.console.setEditable(false);
        this.console.setCursor(ReloadUIManager.TEXT_CURSOR);
        this.console.setLineWrap(true);
        this.getContentPane().add((Component)new JScrollPane(this.console), "Center");
        ReloadUtils.centreWindow(this, 800, 400);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ReloadConsoleWindow.this.console.requestFocusInWindow();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReloadConsoleWindow.this.killApp();
            }
        });
        this.console.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                try {
                    char[] key = new char[]{e.getKeyChar()};
                    String keyStr = new String(key);
                    if (ReloadConsoleWindow.this.keyStream != null) {
                        ReloadConsoleWindow.this.console.append(keyStr);
                        ReloadConsoleWindow.this.keyStream.write(keyStr.getBytes());
                        ReloadConsoleWindow.this.keyStream.flush();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.app = new ReloadConsoleApplication(cmd);
        if (!this.app.initializeProcess()) {
            JOptionPane.showMessageDialog(ReloadEditor.getInstance(), "Error launching " + title, title + " Error", 0, ReloadUIManager.getIcon(ReloadEditor.ICON_APP32));
            this.killApp();
            return;
        }
        this.mapStreams();
        this.show();
        Thread thread = new Thread(){

            @Override
            public void run() {
                ReloadConsoleWindow.this.app.launchProcess();
            }
        };
        thread.start();
    }

    private void killApp() {
        if (this.oldOutput != null) {
            System.setOut(this.oldOutput);
        }
        this.app.killProcess();
        this.dispose();
    }

    public void mapStreams() {
        try {
            this.keyStream = this.app.getConsoleInputStreamPipe();
            this.oldOutput = System.out;
            PrintStream output = new PrintStream(new DumpStream(), true);
            System.setOut(output);
            PrintStream err = new PrintStream(new DumpStream(), true);
            System.setErr(err);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class DumpStream
    extends OutputStream {
        String s;

        @Override
        public void write(int b) {
            this.s = String.valueOf((char)(b & 0xFF));
            if (ReloadConsoleWindow.this.macKludge && (this.s.equals(DweezilConstants.CR) || this.s.equals("\r"))) {
                ReloadConsoleWindow.this.console.append("\r\n");
            } else {
                ReloadConsoleWindow.this.console.append(this.s);
            }
            ReloadConsoleWindow.this.console.setCaretPosition(ReloadConsoleWindow.this.console.getText().length());
        }
    }
}

