/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.convert;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.contentpackaging.convert.ReloadConversionUtilities;

public class ReloadConvertDialog
extends JDialog {
    boolean validate;
    private JPanel lblPanel_1_2;
    private JLabel lbl_1_2;
    private JPanel browsePanel_1_2;
    private JTextField txtLocation_1_2;
    private JButton btnBrowse_1_2;
    private JPanel lblPanel_2004;
    private JLabel lbl_2004;
    private JPanel browsePanel_2004;
    private JTextField txtLocation_2004;
    private JButton btnBrowse_2004;
    private JPanel optionsPanel;
    private JCheckBox chkValidate;
    private JPanel btnPanel;
    private JButton btnConvert;
    private JButton btnCancel;

    public ReloadConvertDialog() {
        super(ReloadEditor.getInstance(), "Convert", true);
        this.setSize(400, 500);
        this.setLocationRelativeTo(ReloadEditor.getInstance());
        this.setResizable(false);
        this.initComponents();
    }

    private void initComponents() {
        this.lblPanel_1_2 = new JPanel();
        this.lbl_1_2 = new JLabel();
        this.browsePanel_1_2 = new JPanel();
        this.txtLocation_1_2 = new JTextField();
        this.btnBrowse_1_2 = new JButton();
        this.lblPanel_2004 = new JPanel();
        this.lbl_2004 = new JLabel();
        this.browsePanel_2004 = new JPanel();
        this.txtLocation_2004 = new JTextField();
        this.btnBrowse_2004 = new JButton();
        this.optionsPanel = new JPanel();
        this.chkValidate = new JCheckBox();
        this.btnPanel = new JPanel();
        this.btnConvert = new JButton();
        this.btnCancel = new JButton();
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        content.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.setDefaultCloseOperation(2);
        this.lblPanel_1_2.setLayout(new FlowLayout(0));
        this.lbl_1_2.setHorizontalAlignment(2);
        this.lbl_1_2.setText("Location of SCORM 1.2 Package:");
        this.lbl_1_2.setVerticalAlignment(1);
        this.lbl_1_2.setName("label_1_2");
        this.lbl_1_2.setHorizontalTextPosition(2);
        this.lblPanel_1_2.add(this.lbl_1_2);
        content.add(this.lblPanel_1_2);
        this.browsePanel_1_2.setLayout(new BoxLayout(this.browsePanel_1_2, 0));
        this.browsePanel_1_2.add(this.txtLocation_1_2);
        this.browsePanel_1_2.add(Box.createHorizontalStrut(10));
        this.btnBrowse_1_2.setText("Browse...");
        this.btnBrowse_1_2.addActionListener(new Browse1_2Click());
        this.browsePanel_1_2.add(this.btnBrowse_1_2);
        content.add(this.browsePanel_1_2);
        content.add(Box.createVerticalStrut(15));
        this.lblPanel_2004.setLayout(new FlowLayout(0));
        this.lbl_1_2.setVerticalAlignment(1);
        this.lbl_1_2.setName("label_1_2");
        this.lbl_1_2.setHorizontalTextPosition(2);
        this.lbl_2004.setHorizontalAlignment(2);
        this.lbl_2004.setText("Location of SCORM 2004 Package:");
        this.lbl_2004.setVerticalAlignment(1);
        this.lbl_2004.setName("label_2004");
        this.lbl_2004.setHorizontalTextPosition(2);
        this.lblPanel_2004.add(this.lbl_2004);
        content.add(this.lblPanel_2004);
        this.browsePanel_2004.setLayout(new BoxLayout(this.browsePanel_2004, 0));
        this.browsePanel_2004.add(this.txtLocation_2004);
        this.browsePanel_2004.add(Box.createHorizontalStrut(10));
        this.btnBrowse_2004.setText("Browse...");
        this.btnBrowse_2004.addActionListener(new Browse2004Click());
        this.browsePanel_2004.add(this.btnBrowse_2004);
        content.add(this.browsePanel_2004);
        content.add(Box.createVerticalStrut(15));
        this.validate = false;
        this.chkValidate.setText("Validate Converted Package");
        this.chkValidate.addActionListener(new ValidateCheck());
        this.optionsPanel.add(this.chkValidate);
        content.add(this.optionsPanel);
        content.add(Box.createVerticalStrut(15));
        this.btnPanel.setLayout(new BoxLayout(this.btnPanel, 0));
        this.btnPanel.add(Box.createHorizontalStrut(100));
        this.btnConvert.setText("Convert");
        this.btnConvert.addActionListener(new ConvertClick());
        this.btnPanel.add(this.btnConvert);
        this.btnPanel.add(Box.createHorizontalStrut(25));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new CancelClick());
        this.btnPanel.add(this.btnCancel);
        this.btnPanel.add(Box.createHorizontalStrut(100));
        content.add(this.btnPanel);
        this.setContentPane(content);
        this.pack();
    }

    private class ValidateCheck
    extends AbstractAction {
        private ValidateCheck() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReloadConvertDialog.this.validate = !ReloadConvertDialog.this.validate;
        }
    }

    private class CancelClick
    extends AbstractAction {
        private CancelClick() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReloadConvertDialog.this.dispose();
        }
    }

    private class ConvertClick
    extends AbstractAction {
        private ConvertClick() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f12 = new File(ReloadConvertDialog.this.txtLocation_1_2.getText());
            File f13 = new File(ReloadConvertDialog.this.txtLocation_2004.getText());
            if (ReloadConvertDialog.this.txtLocation_2004.getText().length() != 0) {
                if (f12.exists()) {
                    File folder = f13.getParentFile();
                    if (!folder.exists() && !folder.mkdir()) {
                        JOptionPane.showMessageDialog(ReloadEditor.getInstance(), "Pleae enter a valid location for the SCORM 2004 package.", "Invalid Path Name", 0, ReloadUIManager.getIcon(ReloadEditor.ICON_APP32));
                        return;
                    }
                    ReloadConvertDialog.this.dispose();
                    ReloadConversionUtilities.Convert(f12, f13, ReloadConvertDialog.this.validate);
                } else {
                    JOptionPane.showMessageDialog(ReloadEditor.getInstance(), "The SCORM 1.2 Package you have selected does not exist.", "File Not Found", 0, ReloadUIManager.getIcon(ReloadEditor.ICON_APP32));
                }
            } else {
                JOptionPane.showMessageDialog(ReloadEditor.getInstance(), "Please enter a value for the path name.", "Path Name Empty", 0, ReloadUIManager.getIcon(ReloadEditor.ICON_APP32));
            }
        }
    }

    private class Browse2004Click
    extends AbstractAction {
        private Browse2004Click() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file2 = ReloadConversionUtilities.saveFile();
            ReloadConvertDialog.this.txtLocation_2004.setText(file2.getAbsolutePath());
        }
    }

    private class Browse1_2Click
    extends AbstractAction {
        private Browse1_2Click() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file1 = ReloadConversionUtilities.openFile();
            ReloadConvertDialog.this.txtLocation_1_2.setText(file1.getAbsolutePath());
        }
    }
}

