/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.htmlparser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadFileType;
import uk.ac.reload.editor.contentpackaging.htmlparser.CSSParser;

public class HTMLParser
extends HTMLEditorKit.ParserCallback {
    protected HTML.Attribute[] _htmlAttributes = new HTML.Attribute[]{HTML.Attribute.HREF, HTML.Attribute.BACKGROUND, HTML.Attribute.SRC, HTML.Attribute.CODE, HTML.Attribute.ACTION};
    protected File _htmlFile;
    protected boolean _firstPage;
    protected File _rootFolder;
    protected boolean _higherLocalLinkFound;
    protected boolean _absoluteLocalLinkFound;
    protected Hashtable _htmlResourcesTable;
    protected File _startPath;
    protected Vector _allLinks;

    public HTMLParser(File htmlFile) {
        this._htmlFile = htmlFile;
    }

    public HTMLParser(File htmlFile, File rootFolder, boolean userWantsToImport) {
        this._htmlFile = htmlFile;
        this._rootFolder = rootFolder;
        this._firstPage = true;
        this._higherLocalLinkFound = false;
        this._absoluteLocalLinkFound = false;
        this._startPath = htmlFile;
        if (userWantsToImport) {
            this._htmlResourcesTable = new Hashtable();
            File destination = new File(this._rootFolder, htmlFile.getName());
            this._htmlResourcesTable.put(htmlFile, destination);
            this.parseTheHtml(htmlFile, this._rootFolder.getPath());
        } else {
            this._allLinks = new Vector();
            this.parseTheHtml(htmlFile);
        }
    }

    public File[] getAllLinks() {
        Object[] files = new File[this._allLinks.size()];
        this._allLinks.copyInto(files);
        return files;
    }

    public Hashtable getLinks() {
        return this._htmlResourcesTable;
    }

    public boolean isAbsoluteLocalLinkFound() {
        return this._absoluteLocalLinkFound;
    }

    public boolean isHigherLocalLinkFound() {
        return this._higherLocalLinkFound;
    }

    private void parseTheHtml(File HtmlFile) {
        block4: {
            final String sourcePath = HtmlFile.getParent() + File.separatorChar;
            if (HtmlFile.getName().toLowerCase().endsWith(".css")) {
                CSSParser aCssFile = new CSSParser(HtmlFile);
                String[] theCssLinks = aCssFile.getLinks();
                for (int i = 0; i < theCssLinks.length; ++i) {
                    this.buildTheResource(theCssLinks[i], sourcePath);
                }
                return;
            }
            HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){

                @Override
                public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
                    HTMLParser.this.buildTheResource(HTMLParser.this.parseAttributes(tag, attrSet, pos, sourcePath), sourcePath);
                }

                @Override
                public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
                    HTMLParser.this.buildTheResource(HTMLParser.this.parseAttributes(tag, attrSet, pos, sourcePath), sourcePath);
                }
            };
            try {
                FileReader reader = new FileReader(HtmlFile);
                new ParserDelegator().parse(reader, callback, true);
            }
            catch (Exception e) {
                if (!ReloadEditor.DEBUG) break block4;
                e.printStackTrace();
            }
        }
    }

    private String parseAttributes(HTML.Tag tag, MutableAttributeSet attrSet, int pos, String sourcePath) {
        String returnString = null;
        Enumeration<?> attributes = attrSet.getAttributeNames();
        while (attributes.hasMoreElements()) {
            Object o = attributes.nextElement();
            String attributename = o.toString();
            Iterator listElement = ReloadFileType.JAVASCRIPTEVENTS.iterator();
            while (listElement.hasNext()) {
                if (attributename.toLowerCase().compareTo(listElement.next().toString()) != 0) continue;
                String attributevalue = (String)attrSet.getAttribute(o);
                this.dealWithJavascriptEvent(attributevalue, sourcePath);
            }
            for (int attributeArrayIndex = 0; attributeArrayIndex < this._htmlAttributes.length; ++attributeArrayIndex) {
                String aLink;
                if (o != this._htmlAttributes[attributeArrayIndex] || (aLink = (String)attrSet.getAttribute(o)).toLowerCase().startsWith("http:") || aLink.toLowerCase().startsWith("https:") || aLink.toLowerCase().startsWith("mailto:")) continue;
                if (aLink.toLowerCase().startsWith("javascript:") || aLink.startsWith("#")) {
                    this.dealWithJavascriptEvent(aLink, sourcePath);
                    returnString = null;
                    continue;
                }
                if (aLink.toLowerCase().startsWith("file:")) {
                    this._absoluteLocalLinkFound = true;
                    returnString = null;
                    continue;
                }
                returnString = aLink;
            }
        }
        return returnString;
    }

    private void dealWithJavascriptEvent(String aLink, String sourcePath) {
        String[] javascriptBits = aLink.split("'");
        for (int scriptArrayIndex = 0; scriptArrayIndex < javascriptBits.length; ++scriptArrayIndex) {
            Iterator listElement = ReloadFileType.ALL_EXTENSIONS.iterator();
            while (listElement.hasNext()) {
                if (!javascriptBits[scriptArrayIndex].toLowerCase().endsWith(listElement.next().toString())) continue;
                this.buildTheResource(javascriptBits[scriptArrayIndex], sourcePath);
            }
        }
    }

    private void buildTheResource(String localLink, String sourcePath) {
        block9: {
            Object destinationCanonical = null;
            if (localLink != null) {
                URLDecoder _decoder = new URLDecoder();
                try {
                    File original = new File(URLDecoder.decode(sourcePath + localLink, "UTF-8"));
                    if (!original.exists()) break block9;
                    try {
                        File originalCanonical = new File(original.getCanonicalPath());
                        if (originalCanonical.getPath().startsWith(this._rootFolder.getPath())) {
                            boolean filePath = false;
                            filePath = this._allLinks.contains(originalCanonical);
                            if (!filePath) {
                                if (!originalCanonical.isDirectory()) {
                                    this._allLinks.add(originalCanonical);
                                }
                                Iterator listElement = ReloadFileType.EXTENSIONS_TO_PARSE.iterator();
                                while (listElement.hasNext()) {
                                    if (!localLink.toLowerCase().endsWith(listElement.next().toString())) continue;
                                    this._firstPage = false;
                                    this.parseTheHtml(original);
                                }
                            }
                            break block9;
                        }
                        this._higherLocalLinkFound = true;
                    }
                    catch (IOException e) {
                        System.out.println("A problem occured when trying to find all links in " + localLink + " This is probably due to the page having Absolute links to local files on your computer.  Please amend this page\n");
                    }
                }
                catch (Exception ex) {
                    if (!ReloadEditor.DEBUG) break block9;
                    System.out.println("Encoding exception: ");
                    ex.printStackTrace();
                }
            }
        }
    }

    private void parseTheHtml(final File HtmlFile, String destPath) {
        final String sourcePath = HtmlFile.getParent() + File.separatorChar;
        final String packagePath = destPath + File.separatorChar;
        if (HtmlFile.getName().toLowerCase().endsWith(".css")) {
            CSSParser aCssFile = new CSSParser(HtmlFile);
            String[] theCssLinks = aCssFile.getLinks();
            for (int i = 0; i < theCssLinks.length; ++i) {
                this.buildTheResource(theCssLinks[i], sourcePath, packagePath, HtmlFile);
            }
            return;
        }
        HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){

            @Override
            public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
                HTMLParser.this.buildTheResource(HTMLParser.this.parseAttributes(tag, attrSet, pos, sourcePath, packagePath, HtmlFile), sourcePath, packagePath, HtmlFile);
            }

            @Override
            public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
                HTMLParser.this.buildTheResource(HTMLParser.this.parseAttributes(tag, attrSet, pos, sourcePath, packagePath, HtmlFile), sourcePath, packagePath, HtmlFile);
            }
        };
        try {
            FileReader reader = new FileReader(HtmlFile.getAbsolutePath());
            new ParserDelegator().parse(reader, callback, true);
        }
        catch (Exception e) {
            System.out.println("Error: Unable to start parsing '" + e.toString() + "'");
        }
    }

    private void dealWithJavascriptEvent(String aLink, String sourcePath, String packagePath, File pageFrom) {
        String[] javascriptBits = aLink.split("'");
        for (int scriptArrayIndex = 0; scriptArrayIndex < javascriptBits.length; ++scriptArrayIndex) {
            Iterator listElement = ReloadFileType.ALL_EXTENSIONS.iterator();
            while (listElement.hasNext()) {
                if (!javascriptBits[scriptArrayIndex].toLowerCase().endsWith(listElement.next().toString())) continue;
                this.buildTheResource(javascriptBits[scriptArrayIndex], sourcePath, packagePath, pageFrom);
            }
        }
    }

    private String parseAttributes(HTML.Tag tag, MutableAttributeSet attrSet, int pos, String sourcePath, String packagePath, File pageFrom) {
        String returnString = null;
        Enumeration<?> attributes = attrSet.getAttributeNames();
        while (attributes.hasMoreElements()) {
            Object o = attributes.nextElement();
            String attributename = o.toString();
            Iterator listElement = ReloadFileType.JAVASCRIPTEVENTS.iterator();
            while (listElement.hasNext()) {
                if (attributename.toLowerCase().compareTo(listElement.next().toString()) != 0) continue;
                String attributevalue = (String)attrSet.getAttribute(o);
                this.dealWithJavascriptEvent(attributevalue, sourcePath, packagePath, pageFrom);
            }
            for (int attributeArrayIndex = 0; attributeArrayIndex < this._htmlAttributes.length; ++attributeArrayIndex) {
                String aLink;
                if (o != this._htmlAttributes[attributeArrayIndex] || (aLink = (String)attrSet.getAttribute(o)).toLowerCase().startsWith("http:") || aLink.toLowerCase().startsWith("https:") || aLink.toLowerCase().startsWith("mailto:")) continue;
                if (aLink.toLowerCase().startsWith("javascript:") || aLink.startsWith("#")) {
                    this.dealWithJavascriptEvent(aLink, sourcePath, packagePath, pageFrom);
                    returnString = null;
                    continue;
                }
                if (aLink.toLowerCase().startsWith("file:")) {
                    this._absoluteLocalLinkFound = true;
                    System.out.println("Warning: The link '" + aLink.toString() + "' in the file '" + pageFrom.getPath() + "' is an absolute link to a page on your hard drive.");
                    returnString = null;
                    continue;
                }
                returnString = aLink;
            }
        }
        return returnString;
    }

    private void buildTheResource(String localLink, String sourcePath, String packagePath, File pageFrom) {
        block9: {
            File destinationCanonical = null;
            if (localLink != null) {
                URLDecoder _decoder = new URLDecoder();
                try {
                    File original = new File(URLDecoder.decode(sourcePath + localLink, "UTF-8"));
                    File destination = new File(URLDecoder.decode(packagePath + localLink, "UTF-8"));
                    if (!original.exists()) break block9;
                    try {
                        File originalCanonical = new File(original.getCanonicalPath());
                        destinationCanonical = new File(destination.getCanonicalPath());
                        if (destinationCanonical.getPath().startsWith(this._rootFolder.getPath())) {
                            File filePath = (File)this._htmlResourcesTable.get(originalCanonical);
                            if (filePath == null) {
                                if (!originalCanonical.isDirectory()) {
                                    this._htmlResourcesTable.put(originalCanonical, destinationCanonical);
                                }
                                Iterator listElement = ReloadFileType.EXTENSIONS_TO_PARSE.iterator();
                                while (listElement.hasNext()) {
                                    if (!localLink.toLowerCase().endsWith(listElement.next().toString())) continue;
                                    this._firstPage = false;
                                    this.parseTheHtml(original, destinationCanonical.getParent());
                                }
                            }
                            break block9;
                        }
                        this._higherLocalLinkFound = true;
                        System.out.println("Warning: The link '" + destinationCanonical.getPath() + "' in the file '" + pageFrom.getPath() + "' is higher than the project folder, so it cannot be copied across.");
                    }
                    catch (IOException e) {
                        System.out.println("Error: A problem occured during parsing '" + e.toString() + "'");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("Error: Encoding exception in HTML document '" + e.toString() + "'");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTagText(String tagName) {
        String text = null;
        TagFinderParserCallback callback = new TagFinderParserCallback(tagName);
        try {
            FileReader reader = new FileReader(this._htmlFile);
            new ParserDelegator().parse(reader, callback, true);
            text = callback.text;
            return text;
        }
        catch (Exception e) {
            if (ReloadEditor.DEBUG) {
                e.printStackTrace();
            }
        }
        finally {
            return text;
        }
    }

    class TagFinderParserCallback
    extends HTMLEditorKit.ParserCallback {
        boolean tag_found;
        boolean done;
        String text = null;
        String _tagName;

        TagFinderParserCallback(String tagName) {
            this._tagName = tagName;
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
            if (!this.tag_found && tag.toString().equals(this._tagName)) {
                this.tag_found = true;
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            if (this.tag_found && !this.done) {
                this.text = new String(data);
                this.done = true;
            }
        }
    }
}

