/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.manifestview;

import org.jdom.Element;
import uk.ac.reload.dweezil.gui.widgets.ReloadFileTextField;
import uk.ac.reload.editor.ReloadElementBinding;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.gui.ReloadElementEditor;
import uk.ac.reload.moonunit.dom.ReloadDocumentListenerEvent;
import uk.ac.reload.moonunit.dom.ReloadSchemaDocument;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class ManifestElementEditor
extends ReloadElementEditor {
    protected boolean isTitleValue;
    protected Element _titleElement;

    @Override
    public void setElement(ReloadElementBinding elementBinding) {
        if (this._elementBinding != null) {
            this._elementBinding.getReloadDocument().removeReloadDocumentListener(this);
        }
        this._elementBinding = elementBinding;
        this._elementBinding.getReloadDocument().addReloadDocumentListener(this);
        Element element = this._elementBinding.getElement();
        String name = element.getName();
        if (name.equals("organization") || name.equals("item")) {
            if (this._elementBinding.getReloadDocument().isDocumentNamespace(element)) {
                this.isTitleValue = true;
                ReloadSchemaElement schemaElement = this._elementBinding.getSchemaElement();
                if (schemaElement != null) {
                    schemaElement = schemaElement.getChild("title");
                }
                this._titleElement = element.getChild("title", element.getNamespace());
                this.setupWidget(this._elementBinding.getReloadDocument(), this._titleElement, schemaElement);
            }
        } else {
            this.isTitleValue = false;
            this.setupWidget(this._elementBinding.getReloadDocument(), this._elementBinding.getElement(), this._elementBinding.getSchemaElement());
        }
    }

    @Override
    protected void setupWidget(ReloadSchemaDocument doc, Element element, ReloadSchemaElement schemaElement) {
        super.setupWidget(doc, element, schemaElement);
        if (this._reloadWidget != null && this._reloadWidget instanceof ReloadFileTextField && schemaElement.getName().equals("location") && doc instanceof ContentPackage) {
            ((ReloadFileTextField)this._reloadWidget).setRelativePath(((ContentPackage)doc).getProjectFolder());
        }
    }

    @Override
    public void elementChanged(ReloadDocumentListenerEvent event) {
        if (event.getSource() == this) {
            return;
        }
        if (this.isTitleValue && this._titleElement != null) {
            Element changed_element = event.getElement();
            if (this._titleElement == changed_element) {
                this.setText(this._titleElement);
            }
        } else {
            super.elementChanged(event);
        }
    }

    @Override
    protected synchronized void fireElementChanged(String text) {
        if (this.isTitleValue) {
            Element element = this._elementBinding.getElement();
            if (text.equals("")) {
                if (this._titleElement != null) {
                    this._elementBinding.getReloadDocument().removeElement(this, this._titleElement);
                    this._titleElement = null;
                }
            } else {
                if (this._titleElement == null) {
                    this._titleElement = new Element("title", element.getNamespace());
                    this._elementBinding.getReloadDocument().addElement(this, element, this._titleElement, false);
                }
                this._titleElement.setText(text);
            }
            this._elementBinding.getReloadDocument().changedElement(this, element);
        } else {
            super.fireElementChanged(text);
        }
    }
}

