/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.manifestview;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import slag.editor.SLAGEditor;
import slag.editor.SLAGSaveListner;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.gui.tree.DragTreeObject;
import uk.ac.reload.dweezil.gui.tree.ReloadDragTree;
import uk.ac.reload.dweezil.gui.tree.ReloadTreeNode;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.menu.ReloadMenuEvent;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorSchemaController;
import uk.ac.reload.editor.ReloadElementBinding;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.ContentPackageEditor;
import uk.ac.reload.editor.contentpackaging.ReloadResource;
import uk.ac.reload.editor.contentpackaging.SCORM1_2EditorDialog;
import uk.ac.reload.editor.contentpackaging.SCORM1_2Package;
import uk.ac.reload.editor.contentpackaging.SCORM1_3EditorDialog;
import uk.ac.reload.editor.contentpackaging.SCORM1_3SequencingEditorDialog;
import uk.ac.reload.editor.contentpackaging.manifestview.ManifestInfoPanel;
import uk.ac.reload.editor.contentpackaging.manifestview.ManifestTreeModel;
import uk.ac.reload.editor.contentpackaging.manifestview.ManifestTreeNode;
import uk.ac.reload.editor.contentpackaging.manifestview.ManifestTreeRenderer;
import uk.ac.reload.editor.gui.ReloadElementTreeNode;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.MetadataEditorDialog;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.dom.DomPath;
import uk.ac.reload.moonunit.dom.ReloadDocumentClipboard;
import uk.ac.reload.moonunit.dom.ReloadDocumentListener;
import uk.ac.reload.moonunit.dom.ReloadDocumentListenerEvent;
import uk.ac.reload.moonunit.dom.ReloadSchemaDocument;
import uk.ac.reload.moonunit.schema.ReloadSchemaAttribute;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;
import uk.ac.reload.moonunit.schema.ReloadVocabularyList;

public class ManifestTree
extends ReloadDragTree
implements TreeSelectionListener,
ReloadDocumentListener,
FocusListener {
    private static final String ADVANCED_SEQUENCING = "Advanced Sequencing";
    private static final String EDIT_SEQUENCING = "Edit Sequencing";
    protected ContentPackageEditor _cpEditor;
    protected ManifestInfoPanel _infoPanel;
    protected ManifestTreeModel _treeModel = new ManifestTreeModel();
    private ProxyEditQuizHandler _editQuizHandler;
    protected JPopupMenu _popupMenu;
    protected TreePath _currentTreePath;
    protected ReloadEditorSchemaController _schemaController;
    protected Menu_Edit _editMenu;
    protected ProxyDeleteHandler _deleteHandler;
    protected ProxyCutHandler _cutHandler;
    protected ProxyCopyHandler _copyHandler;
    protected ProxyPasteHandler _pasteHandler;
    protected ProxyMoveUpHandler _moveUpHandler;
    protected ProxyMoveDownHandler _moveDownHandler;
    protected ProxyLaunchFileHandler _launchFileHandler;
    protected ProxyEditMetadataHandler _editMetadataHandler;
    protected ProxyEditADLRMetadataHandler _editADLRMetadataHandler;
    protected ProxyEditSCORMHandler _editSCORMHandler;
    protected ProxyEditSequencingHandler _editSequencingHandler;
    protected ProxyEditADLNavigationHandler _editADLNavigationHandler;
    protected ProxyAddQuizHandler _addQuizHandler;
    protected ContentPackage _contentPackage;

    public ManifestTree(ContentPackageEditor cpEditor, ManifestInfoPanel infoPanel) {
        this.setModel(this._treeModel);
        this._cpEditor = cpEditor;
        this._infoPanel = infoPanel;
        this.addTreeSelectionListener(this);
        this.addFocusListener(this);
        this.setCellRenderer(new ManifestTreeRenderer());
        ToolTipManager.sharedInstance().registerComponent(this);
        this._popupMenu = new JPopupMenu();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ManifestTree.this.checkPopupTrigger(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ManifestTree.this.checkPopupTrigger(e);
                ManifestTree.this.popupSequenceingMenu(e);
            }
        });
        this._editMenu = MainMenu.sharedInstance.editMenu;
        this._editMenu.remapKeyStrokes(this);
        DropTarget dropTarget = new DropTarget(this, this);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public void setContentPackage(ContentPackage cp) {
        this._contentPackage = cp;
        this._schemaController = (ReloadEditorSchemaController)this._contentPackage.getReloadSchemaController();
        this._treeModel.setContentPackage(this._contentPackage);
        this.selectNode(this._treeModel.getRootNode());
        this._contentPackage.addReloadDocumentListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!e.isTemporary()) {
            this.updateMenus(this.getSelectionPath());
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.clearMenus();
        }
    }

    public void destroy() {
        this._contentPackage.removeReloadDocumentListener(this);
        this.clearMenus();
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath selPath = event.getPath();
        if (selPath != this._currentTreePath) {
            this.updateMenus(selPath);
            this.updateInfoPanel(selPath);
            this._currentTreePath = selPath;
        }
    }

    protected synchronized void updateInfoPanel(TreePath selPath) {
        if (this._infoPanel != null) {
            if (selPath == null) {
                this._infoPanel.clear();
                return;
            }
            Object selectedNode = selPath.getLastPathComponent();
            if (selectedNode instanceof ManifestTreeNode) {
                ManifestTreeNode treeNode = (ManifestTreeNode)selectedNode;
                ReloadElementBinding eb = treeNode.createReloadElementBinding();
                this._infoPanel.setElement(eb);
            }
        }
    }

    protected synchronized void updateMenus(TreePath selPath) {
        this.clearMenus();
        if (selPath == null) {
            return;
        }
        Object selectedNode = selPath.getLastPathComponent();
        if (selectedNode instanceof ManifestTreeNode) {
            String lastItemAdded = null;
            ManifestTreeNode treeNode = (ManifestTreeNode)selectedNode;
            Element element = treeNode.getElement();
            ReloadSchemaElement schemaElement = treeNode.getSchemaElement();
            String name = element.getName();
            this._cutHandler = new ProxyCutHandler(this._editMenu.actionCut, element, schemaElement);
            this._copyHandler = new ProxyCopyHandler(this._editMenu.actionCopy, element);
            this._pasteHandler = new ProxyPasteHandler(this._editMenu.actionPaste, element);
            this._deleteHandler = new ProxyDeleteHandler(this._editMenu.actionDelete, element, schemaElement);
            this._popupMenu.add(this._cutHandler.getMenuAction());
            this._popupMenu.add(this._copyHandler.getMenuAction());
            this._popupMenu.add(this._pasteHandler.getMenuAction());
            this._popupMenu.add(this._deleteHandler.getMenuAction());
            this._popupMenu.addSeparator();
            this._moveUpHandler = new ProxyMoveUpHandler(this._editMenu.actionMoveUp, element);
            this._popupMenu.add(this._moveUpHandler.getMenuAction());
            this._moveDownHandler = new ProxyMoveDownHandler(this._editMenu.actionMoveDown, element);
            this._popupMenu.add(this._moveDownHandler.getMenuAction());
            lastItemAdded = "Move Down";
            ManifestTreeNode seqNode = ManifestTree.findSequencingNodeAncestor(treeNode);
            Action_EditSequencing actionEditSequencing = null;
            if (seqNode != null) {
                ReloadSchemaElement seqSchemaElement = seqNode.getSchemaElement();
                Element itemElement = seqNode.getElement().getParentElement();
                if (itemElement.getName().equals("item") || itemElement.getName().equals("organization")) {
                    String editSequencing = EDIT_SEQUENCING;
                    actionEditSequencing = new Action_EditSequencing(itemElement, seqSchemaElement, editSequencing);
                    this._editSequencingHandler = new ProxyEditSequencingHandler(itemElement, seqSchemaElement);
                    this._editSequencingHandler.setEnabled(true);
                }
            }
            if ("resources".equals(element.getName())) {
                ReloadSchemaElement childSchema = schemaElement.getChild("resource", schemaElement.getNamespace());
                Action_AddQuiz actionAddQuiz = new Action_AddQuiz(element, childSchema, "Quiz");
                this._addQuizHandler = new ProxyAddQuizHandler(element, schemaElement);
                this._addQuizHandler.setEnabled(true);
                this._popupMenu.add(actionAddQuiz);
            }
            if (element.getName().equalsIgnoreCase("resource")) {
                for (Object obj : element.getChildren()) {
                    Element child = (Element)obj;
                    boolean isQuiz = false;
                    Attribute attr = child.getAttribute("href");
                    isQuiz = attr.getValue().contains("quiz.xml");
                    if (!isQuiz) continue;
                    Action_EditQuiz aeq = new Action_EditQuiz(element, schemaElement, "Edit Quiz", attr.getValue());
                    this._editQuizHandler = new ProxyEditQuizHandler(element, schemaElement);
                    this._editQuizHandler.setEnabled(true);
                    this._popupMenu.add(aeq);
                }
            }
            if (schemaElement != null && schemaElement.hasChildren()) {
                ReloadSchemaElement[] children = schemaElement.getChildren();
                ArrayList<Action_AddChildElement> advancedSequencingOptions = new ArrayList<Action_AddChildElement>();
                for (int i = 0; i < children.length; ++i) {
                    Action_AddChildElement actionAddElement;
                    ReloadSchemaElement childSchemaElement = children[i];
                    String childName = childSchemaElement.getName();
                    Namespace ns = childSchemaElement.getNamespace();
                    if (ns.getPrefix() == IMSDocumentHandler.IMSSS_NAMESPACE_PREFIX && childName.equalsIgnoreCase("sequencing")) {
                        String editSequencing = EDIT_SEQUENCING;
                        actionEditSequencing = new Action_EditSequencing(element, childSchemaElement, editSequencing);
                        this._editSequencingHandler = new ProxyEditSequencingHandler(element, childSchemaElement);
                        this._editSequencingHandler.setEnabled(true);
                        if (!this._treeModel.canAddNode(childSchemaElement)) continue;
                        advancedSequencingOptions.add(new Action_AddChildElement(element, childSchemaElement));
                        continue;
                    }
                    if (this._treeModel.canAddNode(childSchemaElement) && element.getNamespacePrefix().equals(IMSDocumentHandler.IMSSS_NAMESPACE_PREFIX)) {
                        advancedSequencingOptions.add(new Action_AddChildElement(element, childSchemaElement));
                        continue;
                    }
                    if (!this._treeModel.canAddNode(childSchemaElement) && (!element.isRootElement() || !childName.equals("manifest"))) continue;
                    if (lastItemAdded.equals("Move Down")) {
                        this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                        this._popupMenu.addSeparator();
                    }
                    if (name.equals("item") && childName.equals("item")) {
                        Element refElement = this._contentPackage.getReferencedElement(element);
                        Action_AddChildElement actionAddElement2 = new Action_AddChildElement(element, childSchemaElement);
                        if (refElement != null || element.getChild("presentation", IMSDocumentHandler.ADLNAV_NAMESPACE_13) != null) {
                            actionAddElement2.setEnabled(false);
                        }
                        this._popupMenu.add(actionAddElement2);
                        this._editMenu.addAdditionalItem(actionAddElement2);
                        lastItemAdded = name;
                        continue;
                    }
                    if (childName.equals("presentation")) {
                        actionAddElement = new Action_AddChildElement(element, childSchemaElement);
                        if (element.getChild("item", IMSDocumentHandler.IMSCP_NAMESPACE_13) != null) {
                            actionAddElement.setEnabled(false);
                        }
                        this._popupMenu.add(actionAddElement);
                        this._editMenu.addAdditionalItem(actionAddElement);
                        lastItemAdded = name;
                        continue;
                    }
                    actionAddElement = new Action_AddChildElement(element, childSchemaElement);
                    this._popupMenu.add(actionAddElement);
                    this._editMenu.addAdditionalItem(actionAddElement);
                    lastItemAdded = name;
                }
                if (actionEditSequencing != null) {
                    this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                    this._popupMenu.addSeparator();
                    this._popupMenu.add(actionEditSequencing);
                    this._editMenu.addAdditionalItem(actionEditSequencing);
                    lastItemAdded = EDIT_SEQUENCING;
                }
                if (advancedSequencingOptions.size() > 0) {
                    if (!lastItemAdded.equals(EDIT_SEQUENCING)) {
                        this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                        this._popupMenu.addSeparator();
                    }
                    JMenu newMenu = new JMenu(ADVANCED_SEQUENCING);
                    JMenu newMenu2 = new JMenu(ADVANCED_SEQUENCING);
                    for (int i = 0; i < advancedSequencingOptions.size(); ++i) {
                        newMenu.add((Action_AddChildElement)advancedSequencingOptions.get(i));
                        newMenu2.add((Action_AddChildElement)advancedSequencingOptions.get(i));
                    }
                    this._popupMenu.add(newMenu);
                    this._editMenu.addAdditionalItem(newMenu2);
                }
            }
            if (this._contentPackage.isMetadataElement(name)) {
                this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                this._popupMenu.addSeparator();
                Action_EditMetadata actionEditMD = new Action_EditMetadata(element);
                this._popupMenu.add(actionEditMD);
                this._editMenu.addAdditionalItem(actionEditMD);
                Action_EditMetadata actionEditHCMD = new Action_EditMetadata(element, true);
                this._popupMenu.add(actionEditHCMD);
                this._editMenu.addAdditionalItem(actionEditHCMD);
                Action_EditADLRMetadata actionEditADLRMD = new Action_EditADLRMetadata(element);
                this._popupMenu.add(actionEditADLRMD);
                this._editMenu.addAdditionalItem(actionEditADLRMD);
                this._editMetadataHandler = new ProxyEditMetadataHandler(element);
                this._editMetadataHandler.setEnabled(true);
                this._editADLRMetadataHandler = new ProxyEditADLRMetadataHandler(element);
                this._editADLRMetadataHandler.setEnabled(true);
            }
            if (name.equals("item") && this._contentPackage instanceof SCORM1_2Package) {
                if (schemaElement != null) {
                    this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                    this._popupMenu.addSeparator();
                    Action_EditSCORM actionEditSCORM = new Action_EditSCORM(element, schemaElement);
                    this._popupMenu.add(actionEditSCORM);
                    this._editMenu.addAdditionalItem(actionEditSCORM);
                    this._editSCORMHandler = new ProxyEditSCORMHandler(element, schemaElement);
                    this._editSCORMHandler.setEnabled(true);
                }
            } else if (name.equals("manifest") && this._contentPackage.isDocumentNamespace(element)) {
                this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                this._popupMenu.addSeparator();
                Action_ImportManifest actionImportManifest = new Action_ImportManifest(element);
                this._popupMenu.add(actionImportManifest);
                this._editMenu.addAdditionalItem(actionImportManifest);
                if (!element.isRootElement()) {
                    Action_ExportManifest actionExportManifest = new Action_ExportManifest(element);
                    this._popupMenu.add(actionExportManifest);
                    this._editMenu.addAdditionalItem(actionExportManifest);
                }
            }
            if (this._contentPackage.isReferencingElement(element)) {
                this._editMenu.addAdditionalItem(new JPopupMenu.Separator());
                this._popupMenu.addSeparator();
                Action_JumpToRefNode actionJumpNode = new Action_JumpToRefNode(element);
                this._editMenu.addAdditionalItem(actionJumpNode);
                this._popupMenu.add(actionJumpNode);
            }
            this._launchFileHandler = new ProxyLaunchFileHandler(element);
        }
    }

    protected synchronized void clearMenus() {
        this._popupMenu.removeAll();
        this._editMenu.removeAdditionalItems();
        if (this._cutHandler != null) {
            this._cutHandler.clearMenu();
        }
        if (this._copyHandler != null) {
            this._copyHandler.clearMenu();
        }
        if (this._pasteHandler != null) {
            this._pasteHandler.clearMenu();
        }
        if (this._deleteHandler != null) {
            this._deleteHandler.clearMenu();
        }
        if (this._moveUpHandler != null) {
            this._moveUpHandler.clearMenu();
        }
        if (this._moveDownHandler != null) {
            this._moveDownHandler.clearMenu();
        }
        if (this._launchFileHandler != null) {
            this._launchFileHandler.clearMenu();
        }
        if (this._editMetadataHandler != null) {
            this._editMetadataHandler.clearMenu();
        }
        if (this._editSCORMHandler != null) {
            this._editSCORMHandler.clearMenu();
        }
    }

    protected void checkPopupTrigger(MouseEvent e) {
        TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
        if (e.isPopupTrigger()) {
            if (selPath == null) {
                return;
            }
            this.setSelectionPath(selPath);
            this._popupMenu.show(this, e.getX(), e.getY());
        }
    }

    private void popupSequenceingMenu(MouseEvent e) {
        ManifestTreeNode treeNode;
        Object selectedNode;
        TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
        if (selPath != null && e.getClickCount() == 2 && (selectedNode = selPath.getLastPathComponent()) != null && selectedNode instanceof ManifestTreeNode && !"organizations".equals((treeNode = (ManifestTreeNode)selectedNode).getName())) {
            ReloadSchemaElement schemaElement = null;
            Element element = null;
            while (treeNode != null && !this.isValidNodeForSequencingEditor(treeNode)) {
                treeNode = (ManifestTreeNode)treeNode.getParent();
            }
            if (treeNode != null) {
                element = treeNode.getElement();
                ReloadSchemaElement tempSchema = treeNode.getSchemaElement();
                schemaElement = this.findSequenceSchemaElement(tempSchema);
                if (schemaElement != null && element != null) {
                    this.editSequencing(element, schemaElement);
                }
            }
        }
    }

    private ReloadSchemaElement findSequenceSchemaElement(ReloadSchemaElement tempSchema) {
        ReloadSchemaElement schemaElement = null;
        for (ReloadSchemaElement obj : tempSchema.getChildren()) {
            ReloadSchemaElement childSchemaElement = obj;
            if (!childSchemaElement.getName().equals("sequencing")) continue;
            schemaElement = childSchemaElement;
            break;
        }
        return schemaElement;
    }

    private boolean isValidNodeForSequencingEditor(ManifestTreeNode treeNode) {
        return treeNode.getName().equals("item") || treeNode.getName().equals("organization");
    }

    protected void editMetadata(final Element mdElement, final boolean isHealthcare) {
        Thread thread = new Thread(){
            MetadataEditorDialog mdDialog;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ManifestTree.this._editMetadataHandler != null) {
                        ManifestTree.this._editMetadataHandler.setEnabled(false);
                    }
                    ReloadEditor.getInstance().setCursor(ReloadUIManager.WAIT_CURSOR);
                    this.mdDialog = new MetadataEditorDialog(mdElement, ManifestTree.this._contentPackage, isHealthcare ? 1 : 0);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            mdDialog.show();
                        }
                    });
                }
                catch (Exception ex) {
                    if (ReloadEditor.DEBUG) {
                        ex.printStackTrace();
                    }
                    if (this.mdDialog != null) {
                        this.mdDialog.dispose();
                    }
                    ErrorDialogBox.showWarning("Error in Metadata", "Could not open Metadata Editor", ex);
                }
                finally {
                    ReloadEditor.getInstance().setCursor(ReloadUIManager.DEFAULT_CURSOR);
                }
            }
        };
        thread.start();
    }

    protected void editADLRMetadata(final Element mdElement) {
        Thread thread = new Thread(){
            MetadataEditorDialog mdDialog;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ManifestTree.this._editMetadataHandler != null) {
                        ManifestTree.this._editMetadataHandler.setEnabled(false);
                    }
                    ReloadEditor.getInstance().setCursor(ReloadUIManager.WAIT_CURSOR);
                    this.mdDialog = new MetadataEditorDialog(mdElement, ManifestTree.this._contentPackage, true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            mdDialog.show();
                        }
                    });
                }
                catch (Exception ex) {
                    if (ReloadEditor.DEBUG) {
                        ex.printStackTrace();
                    }
                    if (this.mdDialog != null) {
                        this.mdDialog.dispose();
                    }
                    ErrorDialogBox.showWarning("Error in Metadata", "Could not open Metadata Editor", ex);
                }
                finally {
                    ReloadEditor.getInstance().setCursor(ReloadUIManager.DEFAULT_CURSOR);
                }
            }
        };
        thread.start();
    }

    protected void editSCORM(final Element itemElement, final ReloadSchemaElement schemaElement) {
        Thread thread = new Thread(){
            SCORM1_2EditorDialog editor;

            @Override
            public void run() {
                if (ManifestTree.this._editSCORMHandler != null) {
                    ManifestTree.this._editSCORMHandler.setEnabled(false);
                }
                this.editor = new SCORM1_2EditorDialog(ManifestTree.this._contentPackage, itemElement, schemaElement);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editor.show();
                    }
                });
            }
        };
        thread.start();
    }

    protected void editSequencing(final Element itemElement, final ReloadSchemaElement schemaElement) {
        Thread thread = new Thread(){
            SCORM1_3SequencingEditorDialog editor;

            @Override
            public void run() {
                String title = "Sequencing Options";
                String id = itemElement.getAttributeValue("identifier");
                if (id != null && id.length() > 0) {
                    title = id;
                }
                List children = itemElement.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    if (!((Element)children.get(i)).getName().equalsIgnoreCase("title")) continue;
                    title = ((Element)children.get(i)).getText();
                }
                if (ManifestTree.this._editSequencingHandler != null) {
                    ManifestTree.this._editSequencingHandler.setEnabled(false);
                }
                this.editor = new SCORM1_3SequencingEditorDialog(ManifestTree.this._contentPackage, itemElement, schemaElement, title);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editor.show();
                    }
                });
            }
        };
        thread.start();
    }

    protected void editADLNavigation(final Element itemElement, final ReloadSchemaElement schemaElement) {
        Thread thread = new Thread(){
            SCORM1_3EditorDialog editor;

            @Override
            public void run() {
                if (ManifestTree.this._editSequencingHandler != null) {
                    ManifestTree.this._editSequencingHandler.setEnabled(false);
                }
                this.editor = new SCORM1_3EditorDialog(ManifestTree.this._contentPackage, itemElement, schemaElement);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editor.show();
                    }
                });
            }
        };
        thread.start();
    }

    @Override
    public void elementAdded(ReloadDocumentListenerEvent event) {
        ManifestTreeNode newNode;
        Element element = event.getElement();
        Element parent = element.getParentElement();
        ReloadTreeNode parentNode = this.getNode(parent);
        if (parentNode != null && (newNode = this.addNode(parentNode, element)) != null && event.doSelect()) {
            this.selectNode(newNode);
        }
    }

    private ManifestTreeNode addNode(DefaultMutableTreeNode parentNode, Element element) {
        ManifestTreeNode newNode = null;
        int index = this.getInsertNodePosition(parentNode, element);
        if (index != -1) {
            newNode = new ManifestTreeNode(element);
            this._treeModel.insertNodeInto(newNode, parentNode, index);
            for (Element child : element.getChildren()) {
                this.addNode(newNode, child);
            }
        }
        return newNode;
    }

    protected int getInsertNodePosition(DefaultMutableTreeNode parentNode, Element element) {
        Element child;
        if (!this._treeModel.doShowNode(element)) {
            return -1;
        }
        int index = 0;
        List children = element.getParentElement().getChildren();
        for (int i = 0; i < children.size() && (child = (Element)children.get(i)) != element; ++i) {
            if (!this._treeModel.doShowNode(child)) continue;
            ++index;
        }
        if (index > parentNode.getChildCount()) {
            index = parentNode.getChildCount();
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    public static ManifestTreeNode findSequencingNodeAncestor(ManifestTreeNode treeNode) {
        if (treeNode != null) {
            String name = treeNode.getName();
            name.toLowerCase();
            if (name.equals("resource") || name.equals("metadata") || name.equals("item") || name.equals("organization") || name.equals("manifest")) {
                return null;
            }
            if (name.equals("sequencing")) {
                return treeNode;
            }
            return ManifestTree.findSequencingNodeAncestor((ManifestTreeNode)treeNode.getParent());
        }
        return null;
    }

    @Override
    public void elementRemoved(ReloadDocumentListenerEvent event) {
        Element element = event.getElement();
        ReloadTreeNode nodeToDelete = this.getNode(element);
        if (nodeToDelete != null) {
            if (nodeToDelete.isNodeDescendant(this.getSelectedNode())) {
                DefaultMutableTreeNode prevNode = nodeToDelete.getPreviousSibling();
                if (prevNode == null) {
                    prevNode = (DefaultMutableTreeNode)nodeToDelete.getParent();
                }
                this._treeModel.removeNodeFromParent(nodeToDelete);
                this.selectNode(prevNode);
            } else {
                this._treeModel.removeNodeFromParent(nodeToDelete);
                this.updateMenus(this.getSelectionPath());
            }
        }
    }

    @Override
    public void elementChanged(ReloadDocumentListenerEvent event) {
        final ReloadTreeNode node = this.getNode(event.getElement());
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManifestTree.this._treeModel.nodeChanged(node);
                }
            });
        }
    }

    @Override
    public void documentSaved(ReloadSchemaDocument doc) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        ReloadElementBinding eb;
        int action = event.getDragAction();
        if ((action & 3) == 0) {
            return;
        }
        ReloadElementTreeNode node = (ReloadElementTreeNode)this.getDragSourceTreeNode(event);
        if (node != null && this._contentPackage.canDragElement((eb = node.createReloadElementBinding()).getElement(), action)) {
            DragTreeObject dragObject = new DragTreeObject(eb, this);
            Point ptDragOrigin = event.getDragOrigin();
            TreePath path = this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
            if (path == null) {
                return;
            }
            BufferedImage imgGhost = this.getDragImage(path, ptDragOrigin);
            event.startDrag(DragSource.DefaultCopyNoDrop, imgGhost, new Point(5, 5), dragObject, this);
        }
    }

    @Override
    public boolean isDropOK(DropTargetDragEvent event) {
        ReloadElementTreeNode targetNode = (ReloadElementTreeNode)this.getDragOverTreeNode(event);
        if (targetNode == null) {
            return false;
        }
        DropTargetDropEvent tempDTDropEvent = new DropTargetDropEvent(event.getDropTargetContext(), event.getLocation(), 1, 0);
        Transferable transferable = tempDTDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(DragTreeObject.flavor)) {
            int action = this.getCorrectDropContext(event);
            if ((action & 1) != 0 || (action & 2) != 0) {
                try {
                    Object userObject = transferable.getTransferData(DragTreeObject.flavor);
                    if (userObject instanceof ReloadResource[]) {
                        return this._contentPackage.acceptsReloadResources(targetNode.getElement());
                    }
                    if (userObject instanceof ReloadElementBinding) {
                        return this._contentPackage.acceptElement(((ReloadElementBinding)userObject).getElement(), targetNode.getElement(), action);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent event) {
        Point location = event.getLocation();
        TreePath treePath = this.getPathForLocation(location.x, location.y);
        if (treePath == null) {
            return;
        }
        ReloadElementTreeNode targetNode = (ReloadElementTreeNode)treePath.getLastPathComponent();
        Transferable transferable = event.getTransferable();
        if (transferable.isDataFlavorSupported(DragTreeObject.flavor)) {
            event.acceptDrop(this.getCorrectDropContext(event));
            Element newElement = null;
            int numResources = 0;
            try {
                Object userObject = transferable.getTransferData(DragTreeObject.flavor);
                int action = this.getCorrectDropContext(event);
                this.setCursor(ReloadUIManager.WAIT_CURSOR);
                if (userObject instanceof ReloadResource[]) {
                    Element refElement;
                    Element targetElement = targetNode.getElement();
                    if (targetElement.getName().equals("item") && (refElement = this._contentPackage.getReferencedElement(targetElement)) != null) {
                        String msg = "You cannot drop a Resource onto an Item that already contains a reference to another Resource or Manifest.";
                        ErrorDialogBox.showWarning(msg, "Item Contains Reference", null);
                        event.rejectDrop();
                        return;
                    }
                    ReloadResource[] resourceArray = (ReloadResource[])userObject;
                    if (targetElement.getName().equals("resource")) {
                    } else {
                        newElement = this._contentPackage.addReloadResources(resourceArray, targetNode.getElement());
                        ReloadResource[] tempArray = resourceArray[0].getChildren();
                        if (tempArray != null) {
                            numResources = tempArray.length;
                        }
                        this.selectNodeByObject(newElement);
                    }
                } else if (userObject instanceof ReloadElementBinding) {
                    this._contentPackage.shiftElement(((ReloadElementBinding)userObject).getElement(), targetNode.getElement(), action);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                this.setCursor(ReloadUIManager.DEFAULT_CURSOR);
            }
            this.hiliteNode(this.prevHilitedNode, false);
            event.getDropTargetContext().dropComplete(true);
            Element lastResourceElementAdded = this._contentPackage.getLastResourceElementAdded();
            if (lastResourceElementAdded != null && numResources == 0) {
                String value = null;
                Namespace ns = null;
                DomPath domPath = DomPath.getDomPath(lastResourceElementAdded);
                ReloadSchemaElement schemaElement = (ReloadSchemaElement)this._contentPackage.getReloadSchemaController().getReloadSchemaNode(domPath);
                ns = Namespace.getNamespace(IMSDocumentHandler.ADLCP_NAMESPACE_PREFIX, IMSDocumentHandler.ADLCP_NAMESPACE_URI_13);
                ReloadSchemaAttribute attribute = null;
                String scormType = "scormType";
                if (schemaElement.hasAttribute(scormType)) {
                    attribute = schemaElement.getAttribute(scormType, ns);
                }
                if (attribute != null) {
                    Object object;
                    ReloadVocabularyList vl = attribute.getVocabularyList();
                    Object[] list = null;
                    if (vl != null) {
                        list = vl.getList();
                    }
                    if (list != null) {
                        object = JOptionPane.showInputDialog(null, "Please select a value for '" + attribute.getName() + "'.\nYou may change this value later by highlighting the\nresource then clicking under 'Attribute' below in the\nbox next to '" + attribute.getName() + "'.\n*Clicking 'Cancel' or 'X' will result in the resource\n not being added to the package.", "Input", 1, null, list, list[0]);
                        if (object != null) {
                            value = object.toString();
                        }
                    } else {
                        object = JOptionPane.showInputDialog(null, "Please select a value for '" + attribute.getName() + "'.\nYou may change this value later by highlighting the\nresource then clicking under 'Attribute' below in the\nbox next to '" + attribute.getName() + "'.\n*Clicking 'Cancel' or 'X' will result in the resource\n not being added to the package", "Input", 1);
                        if (object != null) {
                            value = object.toString();
                            value.trim();
                        }
                    }
                    if (value != null && value.length() > 0) {
                        Attribute att = attribute.createAttribute();
                        att.setValue(value);
                        lastResourceElementAdded.setAttribute(att);
                        this._contentPackage.fireElementChanged(new ReloadDocumentListenerEvent(this, this._contentPackage, lastResourceElementAdded, false));
                    } else {
                        this._contentPackage.removeElement(this, lastResourceElementAdded);
                        this._contentPackage.removeElement(this, newElement);
                    }
                }
                ns = lastResourceElementAdded.getNamespace();
                attribute = null;
                String type = "type";
                value = null;
                if (schemaElement.hasAttribute(type)) {
                    attribute = schemaElement.getAttribute(type);
                }
                if (attribute != null) {
                    Object object;
                    ReloadVocabularyList vl = attribute.getVocabularyList();
                    Object[] list = null;
                    list = vl != null ? vl.getList() : new String[]{"webcontent", "text/html"};
                    if (list != null) {
                        object = JOptionPane.showInputDialog(null, "Please select a value for '" + attribute.getName() + "'.\nYou may change this value later by highlighting the\nresource then clicking under 'Attribute' below in the\nbox next to '" + attribute.getName() + "'.\n*Clicking 'Cancel' or 'X' will result in the resource\n not being added to the package.", "Input", 1, null, list, list[0]);
                        if (object != null) {
                            value = object.toString();
                        }
                    } else {
                        object = JOptionPane.showInputDialog(null, "Please select a value for '" + attribute.getName() + "'.\nYou may change this value later by highlighting the\nresource then clicking under 'Attribute' below in the\nbox next to '" + attribute.getName() + "'.\n*Clicking 'Cancel' or 'X' will result in the resource\n not being added to the package", "Input", 1);
                        if (object != null) {
                            value = object.toString();
                            value.trim();
                        }
                    }
                    if (value != null && value.length() > 0) {
                        Attribute att = attribute.createAttribute();
                        att.setValue(value);
                        lastResourceElementAdded.setAttribute(att);
                        this._contentPackage.fireElementChanged(new ReloadDocumentListenerEvent(this, this._contentPackage, lastResourceElementAdded, false));
                    } else {
                        this._contentPackage.removeElement(this, lastResourceElementAdded);
                        this._contentPackage.removeElement(this, newElement);
                    }
                }
                this._contentPackage.clearLastResourceElementAdded();
            }
            if (numResources > 0) {
                String msg = "Please ensure a value for 'scormType' and a value for 'type' is supplied for each resource added. Otherwise, the content package will not validate in the SRTE. To specify 'scormType' and 'type', highlight a resource then click below in the box labeled 'scormType' or 'type'. ";
                ErrorDialogBox.showWarning(msg, "Multiple Resources Added to Package", null);
            }
        } else {
            event.rejectDrop();
        }
    }

    @Override
    public int getCorrectDropContext(DropTargetDragEvent event) {
        return super.getCorrectDropContext(event);
    }

    @Override
    public int getCorrectDropContext(DropTargetDropEvent event) {
        return super.getCorrectDropContext(event);
    }

    class ProxyLaunchFileHandler
    extends ProxyAction {
        String url;

        public ProxyLaunchFileHandler(Element element) {
            super(MainMenu.sharedInstance.actionViewFile);
            this.url = ManifestTree.this._contentPackage.getURL(element);
            this.setEnabled(this.url != null);
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            if (this.url != null) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        ReloadUtils.launchFile(ProxyLaunchFileHandler.this.url);
                    }
                };
                thread.start();
            }
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyEditADLNavigationHandler
    extends ProxyAction {
        Element _element;
        ReloadSchemaElement _schemaElement;

        public ProxyEditADLNavigationHandler(Element element, ReloadSchemaElement schemaElement) {
            super(MainMenu.sharedInstance.actionEditSCORM);
            this._element = element;
            this._schemaElement = schemaElement;
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            ManifestTree.this.editADLNavigation(this._element, this._schemaElement);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyEditSequencingHandler
    extends ProxyAction {
        Element _element;
        ReloadSchemaElement _schemaElement;

        public ProxyEditSequencingHandler(Element element, ReloadSchemaElement schemaElement) {
            super(MainMenu.sharedInstance.actionEditSCORM);
            this._element = element;
            this._schemaElement = schemaElement;
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            ManifestTree.this.editSequencing(this._element, this._schemaElement);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyEditQuizHandler
    extends ProxyAction {
        Element _element;
        ReloadSchemaElement _schemaElement;

        public ProxyEditQuizHandler(Element element, ReloadSchemaElement schemaElement) {
            super(MainMenu.sharedInstance.actionEditSCORM);
            this._element = element;
            this._schemaElement = schemaElement;
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyAddQuizHandler
    extends ProxyAction {
        Element _element;
        ReloadSchemaElement _schemaElement;

        public ProxyAddQuizHandler(Element element, ReloadSchemaElement schemaElement) {
            super(MainMenu.sharedInstance.actionEditSCORM);
            this._element = element;
            this._schemaElement = schemaElement;
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyEditSCORMHandler
    extends ProxyAction {
        Element _element;
        ReloadSchemaElement _schemaElement;

        public ProxyEditSCORMHandler(Element element, ReloadSchemaElement schemaElement) {
            super(MainMenu.sharedInstance.actionEditSCORM);
            this._element = element;
            this._schemaElement = schemaElement;
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            ManifestTree.this.editSCORM(this._element, this._schemaElement);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyEditMetadataHandler
    extends ProxyAction {
        Element _element;
        private boolean mIsHealthcare;

        public ProxyEditMetadataHandler(Element element) {
            super(MainMenu.sharedInstance.actionEditMetadata);
            this.mIsHealthcare = false;
            this._element = element;
        }

        public ProxyEditMetadataHandler(Element element, boolean isHealthcare) {
            this(element);
            this.mIsHealthcare = isHealthcare;
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            ManifestTree.this.editMetadata(this._element, this.mIsHealthcare);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyEditADLRMetadataHandler
    extends ProxyAction {
        Element _element;

        public ProxyEditADLRMetadataHandler(Element element) {
            super(MainMenu.sharedInstance.actionEditMetadata);
            this._element = element;
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            ManifestTree.this.editADLRMetadata(this._element);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyPasteHandler
    extends ProxyAction {
        Element element;

        public ProxyPasteHandler(MenuAction proxyMenuAction, Element element) {
            super(proxyMenuAction);
            this.element = element;
            this.setEnabled(ManifestTree.this._contentPackage.canPasteFromClipboard(element));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            if (ManifestTree.this._contentPackage.canPasteFromClipboard(this.element)) {
                Element clipBoardElement = ReloadDocumentClipboard.getElement();
                ManifestTree.this._contentPackage.shiftElement(clipBoardElement, this.element, 1);
                ManifestTree.this.updateMenus(ManifestTree.this.getSelectionPath());
            }
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyCopyHandler
    extends ProxyAction {
        Element element;

        public ProxyCopyHandler(MenuAction proxyMenuAction, Element element) {
            super(proxyMenuAction);
            this.element = element;
            this.setEnabled(ManifestTree.this._contentPackage.canCopyElement(element));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            ReloadDocumentClipboard.addCopiedElement(this.element);
            ManifestTree.this.updateMenus(ManifestTree.this.getSelectionPath());
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyCutHandler
    extends ProxyAction {
        Element element;

        public ProxyCutHandler(MenuAction proxyMenuAction, Element element, ReloadSchemaElement schemaElement) {
            super(proxyMenuAction);
            this.element = element;
            this.setEnabled(ManifestTree.this._contentPackage.canCutElement(element, schemaElement));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            ManifestTree.this._contentPackage.cutElementUndoable(ManifestTree.this, this.element);
            ReloadDocumentClipboard.addCutElement(this.element);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyDeleteHandler
    extends ProxyAction {
        Element element;

        public ProxyDeleteHandler(MenuAction proxyMenuAction, Element element, ReloadSchemaElement schemaElement) {
            super(proxyMenuAction);
            this.element = element;
            this.setEnabled(ManifestTree.this._contentPackage.canDeleteElement(element, schemaElement));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            ManifestTree.this._contentPackage.deleteElementUndoable(ManifestTree.this, this.element);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyMoveDownHandler
    extends ProxyAction {
        Element element;

        public ProxyMoveDownHandler(MenuAction proxyMenuAction, Element element) {
            super(proxyMenuAction);
            this.element = element;
            this.setEnabled(ManifestTree.this._contentPackage.canMoveElementDown(element));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            ManifestTree.this._contentPackage.moveElementDown(ManifestTree.this, this.element, true);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class ProxyMoveUpHandler
    extends ProxyAction {
        Element element;

        public ProxyMoveUpHandler(MenuAction proxyMenuAction, Element element) {
            super(proxyMenuAction);
            this.element = element;
            this.setEnabled(ManifestTree.this._contentPackage.canMoveElementUp(element));
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            ManifestTree.this._contentPackage.moveElementUp(ManifestTree.this, this.element, true);
        }

        public void clearMenu() {
            this.removeAllListeners();
            this.setEnabled(false);
        }
    }

    class Action_JumpToRefNode
    extends AbstractAction {
        Element element;

        public Action_JumpToRefNode(Element element) {
            super("Find reference", ReloadUIManager.getIcon(ReloadEditor.ICON_JUMP));
            this.element = element;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Element ref_element = ManifestTree.this._contentPackage.getReferencedElement(this.element);
            if (ref_element != null) {
                ManifestTree.this.selectNodeByObject(ref_element);
            }
        }
    }

    class Action_ExportManifest
    extends AbstractAction {
        Element element;

        public Action_ExportManifest(Element element) {
            super("Export Manifest...", ManifestTree.this._schemaController.getLeafIcon(element));
            this.element = element;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ManifestTree.this._cpEditor.exportManifest(Action_ExportManifest.this.element);
                }
            };
            thread.start();
        }
    }

    class Action_ImportManifest
    extends AbstractAction {
        Element element;

        public Action_ImportManifest(Element element) {
            super("Import Existing Manifest", ManifestTree.this._schemaController.getLeafIcon(element));
            this.element = element;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ManifestTree.this._cpEditor.importManifest(Action_ImportManifest.this.element);
                }
            };
            thread.start();
        }
    }

    class Action_EditADLNavigation
    extends AbstractAction {
        Element _element;
        ReloadSchemaElement _schemaElement;

        public Action_EditADLNavigation(Element element, ReloadSchemaElement schemaElement, String text) {
            super(text, ReloadUIManager.getIcon(ReloadEditor.ICON_BLANK));
            this._element = element;
            this._schemaElement = schemaElement;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ManifestTree.this.editADLNavigation(this._element, this._schemaElement);
        }
    }

    class Action_EditQuiz
    extends AbstractAction
    implements SLAGSaveListner {
        private Element mElement;
        private ReloadSchemaElement mSchemaElement;
        private String mPath;

        public Action_EditQuiz(Element element, ReloadSchemaElement schemaElement, String name, String path) {
            super(name, ReloadUIManager.getIcon(ReloadEditor.ICON_BLANK));
            this.mElement = element;
            this.mSchemaElement = schemaElement;
            this.mPath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SLAGEditor editor = null;
            try {
                File save = new File(ManifestTree.this._contentPackage.getProjectFolder().getCanonicalPath(), this.mPath);
                editor = new SLAGEditor(save.getAbsolutePath().replace("html", "xml"), "content", ManifestTree.this._contentPackage.getProjectFolder().getCanonicalPath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            editor.addSaveListner(this);
            editor.setVisible(true);
        }

        @Override
        public void saveFinished(Object sender, String saveLocation, String quizTitle) {
        }
    }

    class Action_AddQuiz
    extends Action_AddChildElement
    implements SLAGSaveListner {
        public Action_AddQuiz(Element element, ReloadSchemaElement childSchemaElelent, String name) {
            super(element, childSchemaElelent, name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SLAGEditor editor = null;
            try {
                editor = new SLAGEditor("content", ManifestTree.this._contentPackage.getProjectFolder().getCanonicalPath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            editor.addSaveListner(this);
            editor.setVisible(true);
        }

        @Override
        public void saveFinished(Object sender, String saveLocation, String quizTitle) {
            File output = new File(saveLocation, "quiz.html");
            ManifestTree.this._contentPackage.addReloadResource(new ReloadResource(output), this.parentElement);
        }

        private ReloadResource[] getResourcesFromDirectory(File directory) {
            ArrayList<ReloadResource> resources = new ArrayList<ReloadResource>();
            if (directory.isDirectory()) {
                for (String child : directory.list()) {
                    File childFile = new File(directory, child);
                    if (childFile.isDirectory()) {
                        for (ReloadResource res : this.getResourcesFromDirectory(childFile)) {
                            resources.add(res);
                        }
                        continue;
                    }
                    resources.add(new ReloadResource(childFile));
                }
            }
            return resources.toArray(new ReloadResource[resources.size()]);
        }
    }

    class Action_EditSequencing
    extends AbstractAction {
        Element _element;
        ReloadSchemaElement _schemaElement;

        public Action_EditSequencing(Element element, ReloadSchemaElement schemaElement, String text) {
            super(text, null);
            this._element = element;
            this._schemaElement = schemaElement;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ManifestTree.this.editSequencing(this._element, this._schemaElement);
        }
    }

    class Action_EditSCORM
    extends AbstractAction {
        Element _element;
        ReloadSchemaElement _schemaElement;

        public Action_EditSCORM(Element element, ReloadSchemaElement schemaElement) {
            super("Edit SCORM...", ReloadUIManager.getIcon(ReloadEditor.ICON_ADL));
            this._element = element;
            this._schemaElement = schemaElement;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ManifestTree.this.editSCORM(this._element, this._schemaElement);
        }
    }

    class Action_EditMetadata
    extends AbstractAction {
        Element _element;
        private boolean mUseHealthCare;

        public Action_EditMetadata(Element element, boolean useHC) {
            super(useHC ? "Edit Healthcare Metadata..." : "Edit Metadata...", ReloadUIManager.getIcon(ReloadEditor.ICON_MD));
            this.mUseHealthCare = false;
            this._element = element;
            this.mUseHealthCare = useHC;
        }

        public Action_EditMetadata(Element element) {
            this(element, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ManifestTree.this.editMetadata(this._element, this.mUseHealthCare);
        }
    }

    class Action_EditADLRMetadata
    extends AbstractAction {
        Element _element;

        public Action_EditADLRMetadata(Element element) {
            super("Edit ADL-R Metadata...", ReloadUIManager.getIcon(ReloadEditor.ICON_MD));
            this._element = element;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ManifestTree.this.editADLRMetadata(this._element);
        }
    }

    public class Action_AddChildElement
    extends AbstractAction {
        protected Element parentElement;
        protected ReloadSchemaElement childSchemaElement;
        protected String name;

        public Action_AddChildElement(Element parentElement, ReloadSchemaElement childSchemaElement) {
            this(parentElement, childSchemaElement, null);
        }

        public Action_AddChildElement(Element parentElement, ReloadSchemaElement childSchemaElement, String n) {
            this.parentElement = parentElement;
            this.childSchemaElement = childSchemaElement;
            this.name = n;
            if (this.name == null) {
                this.name = ManifestTree.this._schemaController.getElementFriendlyName(childSchemaElement.getDomPath());
            }
            if (this.name == null) {
                this.name = childSchemaElement.getName();
            }
            this.putValue("Name", "Add " + this.name);
            this.putValue("SmallIcon", ManifestTree.this._schemaController.getLeafIcon(childSchemaElement));
            this.setEnabled(ManifestTree.this._contentPackage.canAddElement(parentElement, childSchemaElement));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Element element = ManifestTree.this._contentPackage.addElementBySchemaUndoable(ManifestTree.this, this.parentElement, this.childSchemaElement, true);
        }
    }
}

