/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.manifestview;

import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.gui.tree.ReloadTreeModel;
import uk.ac.reload.editor.contentpackaging.ContentPackage;
import uk.ac.reload.editor.contentpackaging.manifestview.ManifestTreeNode;
import uk.ac.reload.editor.prefs.ReloadEditorPrefs;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class ManifestTreeModel
extends ReloadTreeModel {
    protected ContentPackage _contentPackage;

    public void setContentPackage(ContentPackage cp) {
        this._contentPackage = cp;
        this.root = new ManifestTreeNode(this._contentPackage);
        this.buildChildren((ManifestTreeNode)this.root);
        this.reload();
    }

    public void buildChildren(ManifestTreeNode node) {
        for (Element child : node.getElement().getChildren()) {
            if (!this.doShowNode(child)) continue;
            ManifestTreeNode newNode = new ManifestTreeNode(child);
            node.add(newNode);
            this.buildChildren(newNode);
        }
    }

    protected boolean doShowNode(Element element) {
        return this.doShowNode(element.getName(), element.getNamespace());
    }

    protected boolean doShowNode(ReloadSchemaElement schemaElement) {
        return this.doShowNode(schemaElement.getName(), schemaElement.getNamespace());
    }

    protected boolean doShowNode(String elementName, Namespace ns) {
        if (this._contentPackage.isMetadataRoot(elementName)) {
            return false;
        }
        if (elementName.equals("title") && ns.equals(this._contentPackage.getSchemaNamespace())) {
            return false;
        }
        if (ns.equals(IMSDocumentHandler.ADLCP_NAMESPACE_12)) {
            if (!elementName.equals("location")) {
                boolean hideSCORM = ReloadEditorPrefs.getInstance().getBooleanValue("hide_scorm");
                return !hideSCORM;
            }
            return true;
        }
        if (elementName.equals("resources")) {
            boolean hideResources = ReloadEditorPrefs.getInstance().getBooleanValue("hide_resources");
            return !hideResources;
        }
        return true;
    }

    protected boolean canAddNode(Element element) {
        return this.canAddNode(element.getName(), element.getNamespace());
    }

    protected boolean canAddNode(ReloadSchemaElement schemaElement) {
        String name = schemaElement.getName();
        if ((name.equals("schema") || name.equals("schemaversion")) && !schemaElement.getParent().getParent().getName().equals("manifest")) {
            return false;
        }
        return this.canAddNode(schemaElement.getName(), schemaElement.getNamespace());
    }

    protected boolean canAddNode(String elementName, Namespace ns) {
        if (elementName.equals("manifest") && ns.equals(this._contentPackage.getSchemaNamespace())) {
            return false;
        }
        if (elementName.equals("organizations") && ns.equals(this._contentPackage.getSchemaNamespace())) {
            return false;
        }
        if (elementName.equals("resources") && ns.equals(this._contentPackage.getSchemaNamespace())) {
            return false;
        }
        return this.doShowNode(elementName, ns);
    }
}

