/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.resourceview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadProgressMonitor;
import uk.ac.reload.dweezil.gui.ReloadToolBar;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.ProxyAction;
import uk.ac.reload.dweezil.menu.ReloadMenuEvent;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.contentpackaging.ReloadResource;
import uk.ac.reload.editor.contentpackaging.resourceview.CPResourcesTree;
import uk.ac.reload.editor.contentpackaging.resourceview.ReloadResourceChooser;
import uk.ac.reload.editor.contentpackaging.resourceview.ResourceImporter;
import uk.ac.reload.editor.contentpackaging.resourceview.ResourceRemover;
import uk.ac.reload.editor.menu.MainMenu;
import uk.ac.reload.editor.menu.MenuAction_ImportResources;
import uk.ac.reload.editor.menu.MenuAction_NewFolder;
import uk.ac.reload.editor.menu.MenuAction_Refresh;
import uk.ac.reload.editor.menu.MenuAction_RemoveResources;
import uk.ac.reload.editor.menu.MenuAction_ViewFile;

public class CPResourcesPanel
extends JPanel {
    protected CPResourcesTree _resourcesTree;
    protected File _rootFolder;
    protected ProxyImportHandler _proxyImportHandler;
    protected ProxyImportHandler _proxyImportHandlerLocal;
    protected ProxyRefreshHandler _proxyRefreshHandlerLocal;
    protected ProxyRemoveResourceHandler _proxyRemoveResourceHandlerLocal;
    protected ProxyViewFileHandler _proxyViewFileHandlerLocal;
    protected ProxyNewFolderHandler _proxyNewFolderHandler;

    public CPResourcesPanel() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(0, 0));
        MenuAction_ImportResources _importMenuAction = new MenuAction_ImportResources();
        _importMenuAction.setEnabled(true);
        this._proxyImportHandlerLocal = new ProxyImportHandler(_importMenuAction);
        this._proxyImportHandler = new ProxyImportHandler(MainMenu.sharedInstance.actionImport);
        this._proxyRefreshHandlerLocal = new ProxyRefreshHandler();
        this._proxyRemoveResourceHandlerLocal = new ProxyRemoveResourceHandler();
        this._proxyViewFileHandlerLocal = new ProxyViewFileHandler();
        this._proxyNewFolderHandler = new ProxyNewFolderHandler();
        ReloadToolBar _toolBar = new ReloadToolBar();
        _toolBar.add(this._proxyImportHandlerLocal.getMenuAction());
        _toolBar.add(this._proxyNewFolderHandler.getMenuAction());
        _toolBar.add(this._proxyRemoveResourceHandlerLocal.getMenuAction());
        _toolBar.add(this._proxyRefreshHandlerLocal.getMenuAction());
        _toolBar.add(this._proxyViewFileHandlerLocal.getMenuAction());
        this.add((Component)_toolBar, "North");
        this._resourcesTree = new CPResourcesTree(this);
        this.add((Component)new JScrollPane(this._resourcesTree), "Center");
    }

    public void setFileView(File rootFolder) {
        this._rootFolder = rootFolder;
        this._resourcesTree.setFileView(rootFolder);
    }

    public void destroy() {
        this._proxyImportHandler.removeListener();
        this._proxyImportHandlerLocal.removeListener();
        this._proxyNewFolderHandler.removeListener();
        this._proxyRefreshHandlerLocal.removeListener();
        this._proxyRemoveResourceHandlerLocal.removeListener();
        this._proxyViewFileHandlerLocal.removeListener();
    }

    public void setFocusGained() {
        this._resourcesTree.setFocusGained();
        this._proxyImportHandler.addListener();
    }

    public void setFocusLost() {
        this._resourcesTree.setFocusLost();
        this._proxyImportHandler.setEnabled(false);
        this._proxyImportHandler.removeListener();
    }

    public void updateMenus(ReloadResource resource) {
        this._proxyRemoveResourceHandlerLocal.setEnabled(!resource.equals(this._rootFolder));
        this._proxyViewFileHandlerLocal.update(resource);
        this._proxyNewFolderHandler.update(resource);
        this._proxyImportHandler.update(resource);
        this._proxyImportHandlerLocal.update(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importResources(ReloadResource folder) {
        ReloadResourceChooser fileChooserOption = new ReloadResourceChooser();
        int returnVal = fileChooserOption.showOpenDialog(ReloadEditor.getInstance());
        if (returnVal != 0) {
            return;
        }
        File[] files = fileChooserOption.getSelectedFilesAndStore();
        ReloadProgressMonitor progressMonitor = null;
        try {
            this._proxyImportHandler.setEnabled(false);
            this._proxyImportHandlerLocal.setEnabled(false);
            progressMonitor = new ReloadProgressMonitor(ReloadEditor.getInstance(), "Import Resources", "Importing...", "", true, ReloadUIManager.getIcon(ReloadEditor.ICON_APP16));
            ResourceImporter importRes = new ResourceImporter(files, (File)folder, fileChooserOption.isCheckboxChecked(), progressMonitor);
            if (importRes.getHasUserImportedFiles()) {
                this.refreshResourceTree();
            }
        }
        catch (Exception ex) {
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            ErrorDialogBox.showWarning("Import Resources", "Error importing", ex);
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.close();
            }
            this._proxyImportHandler.setEnabled(true);
            this._proxyImportHandlerLocal.setEnabled(true);
        }
    }

    private void removeTheResources() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResourceRemover removeRes = new ResourceRemover();
                            removeRes.removeFiles(CPResourcesPanel.this._resourcesTree);
                        }
                    });
                }
                catch (Exception ex) {
                    if (ReloadEditor.DEBUG) {
                        ex.printStackTrace();
                    }
                    ErrorDialogBox.showWarning("Remove Resources", "Error deleting", ex);
                    CPResourcesPanel.this.refreshResourceTree();
                }
            }
        };
        thread.start();
    }

    public void refreshResourceTree() {
        this._resourcesTree.refresh();
    }

    class ProxyNewFolderHandler
    extends ProxyAction {
        ReloadResource _resource;

        public ProxyNewFolderHandler() {
            super(new MenuAction_NewFolder());
        }

        public void update(ReloadResource resource) {
            this.setEnabled(resource.isDirectory());
            this._resource = resource;
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            File file;
            String s;
            if (this._resource != null && (s = JOptionPane.showInputDialog(ReloadEditor.getInstance(), "Folder Name", "New Folder", -1)) != null && !(file = new File(this._resource, s)).exists()) {
                file.mkdir();
                CPResourcesPanel.this.refreshResourceTree();
            }
        }
    }

    class ProxyViewFileHandler
    extends ProxyAction {
        ReloadResource _resource;

        public ProxyViewFileHandler() {
            super(new MenuAction_ViewFile());
        }

        public void update(ReloadResource resource) {
            this.setEnabled(resource.isFile());
            this._resource = resource;
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            if (this._resource != null) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        ReloadUtils.launchFile(ProxyViewFileHandler.this._resource);
                    }
                };
                thread.start();
            }
        }
    }

    class ProxyRefreshHandler
    extends ProxyAction {
        public ProxyRefreshHandler() {
            super(new MenuAction_Refresh());
            this.setEnabled(true);
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    CPResourcesPanel.this.setCursor(ReloadUIManager.WAIT_CURSOR);
                    CPResourcesPanel.this._proxyRefreshHandlerLocal.setEnabled(false);
                    CPResourcesPanel.this.refreshResourceTree();
                    CPResourcesPanel.this._proxyRefreshHandlerLocal.setEnabled(true);
                    CPResourcesPanel.this.setCursor(ReloadUIManager.DEFAULT_CURSOR);
                }
            };
            thread.start();
        }
    }

    class ProxyRemoveResourceHandler
    extends ProxyAction {
        public ProxyRemoveResourceHandler() {
            super(new MenuAction_RemoveResources());
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            CPResourcesPanel.this.removeTheResources();
        }
    }

    class ProxyImportHandler
    extends ProxyAction {
        ReloadResource _resource;

        public ProxyImportHandler(MenuAction menuAction) {
            super(menuAction);
        }

        public void update(ReloadResource resource) {
            this.setEnabled(resource.isDirectory());
            this._resource = resource;
        }

        @Override
        public void menuActionPerformed(ReloadMenuEvent event) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    if (ProxyImportHandler.this._resource != null) {
                        CPResourcesPanel.this.importResources(ProxyImportHandler.this._resource);
                    }
                }
            };
            thread.start();
        }
    }
}

