/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.resourceview;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.ReloadProgressMonitor;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.gui.tree.DragTreeObject;
import uk.ac.reload.dweezil.gui.tree.ReloadDragTree;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.contentpackaging.ReloadResource;
import uk.ac.reload.editor.contentpackaging.resourceview.CPResourcesPanel;
import uk.ac.reload.editor.contentpackaging.resourceview.CPResourcesTreeModel;
import uk.ac.reload.editor.contentpackaging.resourceview.CPResourcesTreeNode;
import uk.ac.reload.editor.contentpackaging.resourceview.CPResourcesTreeRenderer;
import uk.ac.reload.editor.contentpackaging.resourceview.ResourceImporter;

public class CPResourcesTree
extends ReloadDragTree
implements TreeSelectionListener {
    protected CPResourcesTreeModel _treeModel;
    protected CPResourcesPanel _resourcesPanel;
    protected JPopupMenu _popupMenu;

    public CPResourcesTree(CPResourcesPanel resourcesPanel) {
        this._resourcesPanel = resourcesPanel;
        this._treeModel = new CPResourcesTreeModel();
        this.setModel(this._treeModel);
        this.addTreeSelectionListener(this);
        this.setCellRenderer(new CPResourcesTreeRenderer());
        ToolTipManager.sharedInstance().registerComponent(this);
        this._popupMenu = this.createPopupMenu();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                CPResourcesTree.this.checkPopupTrigger(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CPResourcesTree.this.checkPopupTrigger(e);
            }
        });
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        DropTarget dropTarget = new DropTarget(this, this);
    }

    public void setFileView(File rootFolder) {
        this._treeModel.setFileView(rootFolder);
        this.selectNode(this._treeModel.getRootNode());
    }

    public void setFocusGained() {
        this.updateMenus(this.getSelectionPath());
    }

    public void setFocusLost() {
    }

    public void refresh() {
        this.refresh((CPResourcesTreeNode)this.getSelectedNode());
    }

    protected void refresh(CPResourcesTreeNode targetNode) {
        ReloadResource res;
        if (targetNode == null) {
            this._treeModel.refresh();
            return;
        }
        ReloadResource currentFile = targetNode.getReloadResource();
        this._treeModel.refresh();
        CPResourcesTreeNode selectednode = null;
        Enumeration<TreeNode> nodes = ((DefaultMutableTreeNode)this.treeModel.getRoot()).preorderEnumeration();
        while (nodes.hasMoreElements() && !(res = (selectednode = (CPResourcesTreeNode)nodes.nextElement()).getReloadResource()).equals(currentFile)) {
            selectednode = null;
        }
        if (selectednode != null) {
            this.expandNode(selectednode, true);
            this.selectNode(selectednode);
        } else {
            this.selectNode(this._treeModel.getRootNode());
        }
    }

    public ReloadResource[] getSelectedResourcesToDelete() {
        Vector<ReloadResource> v = new Vector<ReloadResource>();
        TreePath[] paths = this.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            CPResourcesTreeNode fileSysEntity = (CPResourcesTreeNode)paths[i].getLastPathComponent();
            if (fileSysEntity.isRoot()) continue;
            ReloadResource aFileToDelete = fileSysEntity.getReloadResource();
            v.add(aFileToDelete);
        }
        Object[] resources = new ReloadResource[v.size()];
        v.copyInto(resources);
        return resources;
    }

    public void removeTreeResource(Object object) {
        this._treeModel.removeNodeFromParent(this.getNode(object));
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        this.updateMenus(event.getPath());
    }

    protected synchronized void updateMenus(TreePath selPath) {
        if (selPath == null) {
            return;
        }
        Object selectedNode = selPath.getLastPathComponent();
        if (selectedNode instanceof CPResourcesTreeNode) {
            CPResourcesTreeNode treeNode = (CPResourcesTreeNode)selectedNode;
            ReloadResource resource = treeNode.getReloadResource();
            this._resourcesPanel.updateMenus(resource);
        }
    }

    protected void checkPopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger()) {
            TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            this.setSelectionPath(selPath);
            this._popupMenu.show(this, e.getX(), e.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(this._resourcesPanel._proxyImportHandlerLocal.getMenuAction());
        popupMenu.add(this._resourcesPanel._proxyNewFolderHandler.getMenuAction());
        popupMenu.add(this._resourcesPanel._proxyRemoveResourceHandlerLocal.getMenuAction());
        popupMenu.add(this._resourcesPanel._proxyViewFileHandlerLocal.getMenuAction());
        return popupMenu;
    }

    protected void addFiles(final File[] files, final CPResourcesTreeNode targetNode) {
        final ReloadResource targetFolder = targetNode.getReloadResource();
        if (!targetFolder.isDirectory()) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                ReloadProgressMonitor progressMonitor = new ReloadProgressMonitor(ReloadEditor.getInstance(), "Import Resources", "Copying...", "", true, ReloadUIManager.getIcon(ReloadEditor.ICON_APP16));
                ResourceImporter importRes = new ResourceImporter(files, targetFolder, false, progressMonitor);
                progressMonitor.close();
                CPResourcesTree.this.refresh(targetNode);
            }
        };
        thread.start();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        if ((event.getDragAction() & 3) == 0) {
            return;
        }
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            Vector<ReloadResource> v = new Vector<ReloadResource>();
            for (int i = 0; i < paths.length; ++i) {
                CPResourcesTreeNode node = (CPResourcesTreeNode)paths[i].getLastPathComponent();
                v.add(node.getReloadResource());
            }
            if (!v.isEmpty()) {
                Object[] resources = new ReloadResource[v.size()];
                v.copyInto(resources);
                DragTreeObject dragObject = new DragTreeObject(resources, this);
                Point ptDragOrigin = event.getDragOrigin();
                TreePath path = this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
                if (path == null) {
                    return;
                }
                BufferedImage imgGhost = this.getDragImage(path, ptDragOrigin);
                event.startDrag(DragSource.DefaultCopyNoDrop, imgGhost, new Point(5, 5), dragObject, this);
            }
        }
    }

    public void _dragGestureRecognized(DragGestureEvent event) {
        if ((event.getDragAction() & 3) == 0) {
            return;
        }
        CPResourcesTreeNode node = (CPResourcesTreeNode)this.getDragSourceTreeNode(event);
        if (node != null) {
            ReloadResource resource = node.getReloadResource();
            DragTreeObject dragObject = new DragTreeObject(resource, this);
            Point ptDragOrigin = event.getDragOrigin();
            TreePath path = this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
            if (path == null) {
                return;
            }
            BufferedImage imgGhost = this.getDragImage(path, ptDragOrigin);
            event.startDrag(DragSource.DefaultCopyNoDrop, imgGhost, new Point(5, 5), dragObject, this);
        }
    }

    @Override
    public boolean isDropOK(DropTargetDragEvent event) {
        CPResourcesTreeNode targetNode = (CPResourcesTreeNode)this.getDragOverTreeNode(event);
        if (targetNode == null) {
            return false;
        }
        ReloadResource file = targetNode.getReloadResource();
        if (!file.isDirectory()) {
            return false;
        }
        DataFlavor[] flavors = event.getCurrentDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent event) {
        Point location = event.getLocation();
        TreePath treePath = this.getPathForLocation(location.x, location.y);
        if (treePath == null) {
            return;
        }
        CPResourcesTreeNode targetNode = (CPResourcesTreeNode)treePath.getLastPathComponent();
        Transferable transferable = event.getTransferable();
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            event.acceptDrop(this.getCorrectDropContext(event));
            try {
                Object userObject = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (userObject instanceof AbstractList) {
                    AbstractList list = (AbstractList)userObject;
                    Object[] files = list.toArray();
                    this.addFiles((File[])files, targetNode);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.hiliteNode(this.prevHilitedNode, false);
            event.getDropTargetContext().dropComplete(true);
        } else {
            event.rejectDrop();
        }
    }
}

