/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.resourceview;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.contentpackaging.ReloadResource;
import uk.ac.reload.editor.contentpackaging.resourceview.CPResourcesTreeNode;

public class CPResourcesTreeRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof CPResourcesTreeNode) {
            CPResourcesTreeNode selNode = (CPResourcesTreeNode)value;
            if (selNode.isHiLited) {
                selected = true;
            }
            String name = selNode.getName();
            if (selNode.getParent() == null) {
                this.openIcon = this.closedIcon = ReloadUIManager.getIcon(ReloadEditor.ICON_RESOURCES);
                this.leafIcon = this.closedIcon;
                this.setToolTipText("Content Package Resource Pool");
            } else {
                ReloadResource file = selNode.getReloadResource();
                if (file.isDirectory()) {
                    this.closedIcon = ReloadUIManager.getIcon(ReloadEditor.ICON_FOLDER_CLOSED);
                    this.openIcon = ReloadUIManager.getIcon(ReloadEditor.ICON_FOLDER_OPEN);
                    this.leafIcon = this.closedIcon;
                    this.setToolTipText("Folder");
                } else {
                    this.openIcon = this.closedIcon = file.getResourceIcon();
                    this.leafIcon = this.closedIcon;
                    this.setToolTipText(file.getFriendlyName());
                }
            }
        }
        return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }
}

