/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.resourceview;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import uk.ac.reload.dweezil.DweezilConstants;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadProgressMonitor;
import uk.ac.reload.dweezil.gui.ReloadYesAllNoDialog;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadFileType;
import uk.ac.reload.editor.contentpackaging.htmlparser.HTMLParser;

public class ResourceImporter
implements DweezilConstants {
    protected boolean _yesToAll;
    protected boolean _cancelOperation;
    private boolean _userHasImportedFile;
    private ReloadProgressMonitor _progressMonitor;

    public ResourceImporter(File aFile, File destination, boolean obtainDependencies, ReloadProgressMonitor progressMonitor) {
        this._progressMonitor = progressMonitor;
        this._yesToAll = false;
        this.decideImportType(aFile, destination, obtainDependencies);
    }

    public ResourceImporter(File[] files, File destination, boolean obtainDependencies, ReloadProgressMonitor progressMonitor) {
        this._progressMonitor = progressMonitor;
        this._yesToAll = false;
        for (int i = 0; i < files.length; ++i) {
            this.decideImportType(files[i], destination, obtainDependencies);
        }
    }

    private void decideImportType(File aFile, File destination, boolean obtainDependencies) {
        boolean pageToParseFound = ReloadFileType.isParseableFile(aFile);
        if (pageToParseFound && obtainDependencies) {
            this.importHtmlFile(aFile, destination);
        } else if (aFile.isDirectory()) {
            this.importFolder(aFile, destination);
        } else if (aFile.isFile()) {
            this.importSingleResource(aFile, destination);
        }
    }

    public boolean getHasUserImportedFiles() {
        return this._userHasImportedFile;
    }

    private void importFolder(File theFolder, File destinationPath) {
        if (!theFolder.isDirectory()) {
            return;
        }
        if (theFolder.equals(destinationPath)) {
            return;
        }
        File destinationFolder = new File(destinationPath, theFolder.getName());
        if (!destinationFolder.exists()) {
            destinationFolder.mkdirs();
        }
        this.copyTheFilesAndFolders(theFolder.listFiles(), destinationFolder);
    }

    private void copyTheFilesAndFolders(File[] allTheFiles, File destinationPath) {
        File file;
        int i;
        if (this.isCancelled()) {
            return;
        }
        for (i = 0; i < allTheFiles.length; ++i) {
            file = allTheFiles[i];
            if (!file.isDirectory()) continue;
            File destinationFolder = new File(destinationPath, file.getName());
            if (!destinationFolder.exists()) {
                destinationFolder.mkdir();
            }
            this.copyTheFilesAndFolders(file.listFiles(), destinationFolder);
        }
        for (i = 0; i < allTheFiles.length; ++i) {
            file = allTheFiles[i];
            if (file.isDirectory()) continue;
            this.importSingleResource(file, destinationPath);
        }
    }

    private void importSingleResource(File originalFile, File destination) {
        if (this.isCancelled()) {
            return;
        }
        File destinationFile = new File(destination, originalFile.getName());
        try {
            if (destinationFile.exists() && !this._yesToAll) {
                int answer = this.getUserResponse(destinationFile);
                if (answer == 1) {
                    this._yesToAll = true;
                }
                if (answer == 0 || answer == 1) {
                    ResourceImporter.copyFile(originalFile, destinationFile);
                    this._userHasImportedFile = true;
                } else if (answer == 3 || answer == -1) {
                    this._cancelOperation = true;
                }
            } else {
                ResourceImporter.copyFile(originalFile, destinationFile);
                this._userHasImportedFile = true;
            }
        }
        catch (Exception ex) {
            if (ReloadEditor.DEBUG) {
                ex.printStackTrace();
            }
            ErrorDialogBox.showWarning("Import Resources", "Error importing", ex);
        }
    }

    private void importHtmlFile(File theFile, File destFolder) {
        HTMLParser htmlParser = new HTMLParser(theFile, destFolder, true);
        if (htmlParser.isHigherLocalLinkFound()) {
            this.showMessageDialog("One of the pages you requested to import has links that are higher in the folder structure than the project folder." + CR + "Please see the Status Window for more information.", "Import Warning");
        }
        if (htmlParser.isAbsoluteLocalLinkFound()) {
            this.showMessageDialog("One of the pages you requested to import has absolute links  to pages on your hard drive." + CR + "Please see the Status Window for more information.", "Import Warning");
        }
        Hashtable allLinks = htmlParser.getLinks();
        Enumeration keys = allLinks.keys();
        while (keys.hasMoreElements()) {
            if (this.isCancelled()) {
                return;
            }
            File originalFile = (File)keys.nextElement();
            File destinationFile = (File)allLinks.get(originalFile);
            destinationFile.getParentFile().mkdirs();
            if (destinationFile.isDirectory()) continue;
            try {
                if (destinationFile.exists() && !this._yesToAll) {
                    int answer = this.getUserResponse(destinationFile);
                    if (answer == 1) {
                        this._yesToAll = true;
                    }
                    if (answer == 0 || answer == 1) {
                        ResourceImporter.copyFile(originalFile, destinationFile);
                        this._userHasImportedFile = true;
                        continue;
                    }
                    if (answer != 3 && answer != -1) continue;
                    this._cancelOperation = true;
                    return;
                }
                ResourceImporter.copyFile(originalFile, destinationFile);
                this._userHasImportedFile = true;
            }
            catch (Exception ex) {
                if (ReloadEditor.DEBUG) {
                    ex.printStackTrace();
                }
                ErrorDialogBox.showWarning("Import Resources", "Error importing", ex);
            }
        }
    }

    private int getUserResponse(File res) {
        ReloadYesAllNoDialog dialog = new ReloadYesAllNoDialog();
        String fileOrFolder = res.isDirectory() ? "Folder " : "File ";
        String message = fileOrFolder + res.getName() + " already exists. " + CR + "Do you wish to overwrite?";
        String title = "Import Resources";
        return dialog.getUserResponse(ReloadEditor.getInstance(), message, title);
    }

    protected void showMessageDialog(String msg, String title) {
        JOptionPane.showMessageDialog(ReloadEditor.getInstance(), msg, title, 2);
    }

    public static void copyFile(File from, File to) {
        try {
            int i;
            byte[] buffer = new byte[256];
            FileInputStream is = new FileInputStream(from);
            FileOutputStream os = new FileOutputStream(to);
            while ((i = is.read(buffer)) >= 0) {
                os.write(buffer, 0, i);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
        }
    }

    private boolean isCancelled() {
        boolean progressCancelled = false;
        if (this._progressMonitor != null) {
            progressCancelled = this._progressMonitor.isCanceled();
        }
        return this._cancelOperation || progressCancelled;
    }
}

