/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.resourceview;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import uk.ac.reload.dweezil.DweezilConstants;
import uk.ac.reload.dweezil.gui.ReloadYesAllNoDialog;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.contentpackaging.ReloadResource;
import uk.ac.reload.editor.contentpackaging.resourceview.CPResourcesTree;
import uk.ac.reload.editor.contentpackaging.resourceview.CPResourcesTreeNode;

public class ResourceRemover
implements DweezilConstants {
    private Vector fileVector = new Vector();
    private Vector folderVector = new Vector();

    public void removeFiles(CPResourcesTree theTree) {
        ReloadResource[] resources = theTree.getSelectedResourcesToDelete();
        boolean yesToAll = false;
        for (int i = 0; i < resources.length; ++i) {
            ReloadResource aFile = resources[i];
            if (!yesToAll) {
                int answer = this.getUserResponse(aFile);
                if (answer == 1) {
                    yesToAll = true;
                }
                if (answer == 0 || answer == 1) {
                    if (aFile.isDirectory()) {
                        this.findSubFolders(aFile, theTree);
                        continue;
                    }
                    this.fileVector.add(aFile);
                    continue;
                }
                if (answer != 3 && answer != -1) continue;
                this.fileVector.clear();
                this.folderVector.clear();
                return;
            }
            if (aFile.isDirectory()) {
                this.findSubFolders(aFile, theTree);
                continue;
            }
            this.fileVector.add(aFile);
        }
        this.cleanup(theTree);
        theTree.setSelectionRow(0);
    }

    private int getUserResponse(ReloadResource res) {
        ReloadYesAllNoDialog dialog = new ReloadYesAllNoDialog();
        String fileOrFolder = res.isDirectory() ? "folder and all its contents" : "file";
        String message = res.getAbsoluteFile().toString() + CR + "Are you sure you want to delete this " + fileOrFolder + "?";
        String title = "Delete Resources";
        return dialog.getUserResponse(ReloadEditor.getInstance(), message, title);
    }

    private void cleanup(CPResourcesTree theTree) {
        for (ReloadResource aFileResource : this.fileVector) {
            if (aFileResource.exists()) {
                aFileResource.delete();
            }
            if (aFileResource.exists() || theTree.getNode(aFileResource) == null) continue;
            theTree.removeTreeResource(aFileResource);
        }
        this.fileVector.clear();
        for (ReloadResource aFolderResource : this.folderVector) {
            if (aFolderResource.exists()) {
                aFolderResource.delete();
            }
            if (aFolderResource.exists() || theTree.getNode(aFolderResource) == null) continue;
            theTree.removeTreeResource(aFolderResource);
        }
        this.folderVector.clear();
    }

    private void findSubFolders(ReloadResource afolder, CPResourcesTree theTree) {
        if (afolder != null) {
            CPResourcesTreeNode folderchild = (CPResourcesTreeNode)theTree.getNode(afolder);
            Enumeration<TreeNode> e = folderchild.children();
            while (e.hasMoreElements()) {
                CPResourcesTreeNode node = (CPResourcesTreeNode)e.nextElement();
                ReloadResource aresource = (ReloadResource)node.getUserObject();
                if (aresource == null) continue;
                if (aresource.exists() && aresource.isDirectory()) {
                    this.findSubFolders(aresource, theTree);
                    continue;
                }
                this.fileVector.add(aresource);
            }
            this.folderVector.add(afolder);
        }
    }
}

