/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.editor.ReloadElementBinding;
import uk.ac.reload.moonunit.dom.DomPath;
import uk.ac.reload.moonunit.dom.ReloadDocumentListener;
import uk.ac.reload.moonunit.dom.ReloadDocumentListenerEvent;
import uk.ac.reload.moonunit.dom.ReloadSchemaDocument;
import uk.ac.reload.moonunit.schema.ReloadSchemaAttribute;
import uk.ac.reload.moonunit.schema.ReloadVocabularyList;

public class ReloadAttributeEditor
extends JPanel
implements ReloadDocumentListener {
    protected JTable table;
    protected AbstractTableModel tableModel;
    protected ReloadElementBinding _elementBinding;

    public ReloadAttributeEditor() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.setBorder(null);
        this.tableModel = this.createTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(140);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultEditor(Object.class, this.createTableCellEditor());
        AttributeCellRenderer cellRenderer = new AttributeCellRenderer();
        this.table.setDefaultRenderer(Object.class, cellRenderer);
        JScrollPane sp = new JScrollPane(this.table);
        this.add((Component)sp, "Center");
    }

    public void setElement(ReloadElementBinding elementBinding) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (this._elementBinding != null) {
            this._elementBinding.getReloadDocument().removeReloadDocumentListener(this);
        }
        this._elementBinding = elementBinding;
        this._elementBinding.getReloadDocument().addReloadDocumentListener(this);
        this.tableModel.fireTableDataChanged();
    }

    public void destroy() {
        if (this._elementBinding != null) {
            this._elementBinding.getReloadDocument().removeReloadDocumentListener(this);
        }
    }

    protected TableCellEditor createTableCellEditor() {
        return new AttributeCellEditor();
    }

    protected AbstractTableModel createTableModel() {
        return new AttributeTableModel();
    }

    @Override
    public void elementChanged(ReloadDocumentListenerEvent event) {
        Element changed_element;
        if (event.getSource() == this) {
            return;
        }
        Element element = this._elementBinding.getElement();
        if (element != null && element == (changed_element = event.getElement())) {
            this.repaint();
        }
    }

    @Override
    public void elementRemoved(ReloadDocumentListenerEvent event) {
    }

    @Override
    public void elementAdded(ReloadDocumentListenerEvent event) {
    }

    @Override
    public void documentSaved(ReloadSchemaDocument doc) {
    }

    public Attribute getAttribute(int attIndex) {
        List list;
        Attribute att = null;
        ReloadSchemaAttribute reloadSchemaAttribute = this.getSchemaAttribute(attIndex);
        if (reloadSchemaAttribute != null && this._elementBinding.getElement() != null) {
            String attName = reloadSchemaAttribute.getName();
            if (reloadSchemaAttribute.isExternalNamespace()) {
                Namespace ns = reloadSchemaAttribute.getNamespace();
                att = this._elementBinding.getElement().getAttribute(attName, ns);
            } else {
                att = this._elementBinding.getElement().getAttribute(attName);
            }
        } else if (this._elementBinding.getElement() != null && attIndex < (list = this._elementBinding.getElement().getAttributes()).size()) {
            att = (Attribute)list.get(attIndex);
        }
        return att;
    }

    public String getAttributeFriendlyName(int attIndex) {
        String fname = "";
        ReloadSchemaAttribute reloadSchemaAttribute = this.getSchemaAttribute(attIndex);
        if (reloadSchemaAttribute != null) {
            fname = this._elementBinding.getReloadSchemaController().getElementFriendlyName(reloadSchemaAttribute.getDomPath());
            if (fname == null) {
                fname = reloadSchemaAttribute.getName();
            }
        } else {
            Attribute att = this.getAttribute(attIndex);
            if (att != null && (fname = this._elementBinding.getReloadSchemaController().getElementFriendlyName(DomPath.getDomPath(att))) == null) {
                fname = att.getName();
            }
        }
        return fname;
    }

    public String getAttributeToolTip(int attIndex) {
        String tip = null;
        ReloadSchemaAttribute reloadSchemaAttribute = this.getSchemaAttribute(attIndex);
        if (reloadSchemaAttribute != null) {
            tip = this._elementBinding.getReloadSchemaController().getElementTip(reloadSchemaAttribute.getDomPath());
        } else {
            Attribute att = this.getAttribute(attIndex);
            if (att != null) {
                tip = this._elementBinding.getReloadSchemaController().getElementTip(DomPath.getDomPath(att));
            }
        }
        return tip;
    }

    public ReloadVocabularyList getAttributeVocabulary(int attIndex) {
        ReloadVocabularyList vocab = null;
        ReloadSchemaAttribute reloadSchemaAttribute = this.getSchemaAttribute(attIndex);
        if (reloadSchemaAttribute != null) {
            vocab = this._elementBinding.getReloadSchemaController().getVocabularyList(reloadSchemaAttribute);
        }
        return vocab;
    }

    public ReloadSchemaAttribute getSchemaAttribute(int attIndex) {
        return this._elementBinding.getSchemaElement() == null ? null : this._elementBinding.getSchemaElement().getAttributeAtIndex(attIndex);
    }

    protected class AttributeCellRenderer
    extends DefaultTableCellRenderer {
        protected AttributeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String tip = ReloadAttributeEditor.this.getAttributeToolTip(row);
            this.setToolTipText(tip);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    protected class AttributeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JComboBox comboBox;
        protected JTextField textField = new JTextField();
        protected DefaultCellEditor editor;
        protected DefaultCellEditor textEditor;
        protected DefaultCellEditor comboEditor;

        public AttributeCellEditor() {
            this.textField.setBorder(new LineBorder(Color.black));
            this.textEditor = new DefaultCellEditor(this.textField);
            this.comboBox = new JComboBox();
            this.comboBox.setBorder(null);
            this.comboEditor = new DefaultCellEditor(this.comboBox);
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ReloadVocabularyList vocab = ReloadAttributeEditor.this.getAttributeVocabulary(row);
            if (vocab != null) {
                this.editor = this.comboEditor;
                this.comboBox.setModel(new DefaultComboBoxModel<String>(vocab.getList()));
                this.comboBox.setEditable(true);
            } else {
                this.editor = this.textEditor;
            }
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    protected class AttributeTableModel
    extends AbstractTableModel {
        String[] cNames = new String[]{"Attribute", "Value"};

        protected AttributeTableModel() {
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            if (columnIndex == 1) {
                String oldValue;
                ReloadSchemaDocument doc = ReloadAttributeEditor.this._elementBinding.getReloadDocument();
                Element element = ReloadAttributeEditor.this._elementBinding.getElement();
                if (element == null) {
                    element = ReloadAttributeEditor.this._elementBinding.createElement(this);
                }
                if (element == null) {
                    return;
                }
                Attribute att = ReloadAttributeEditor.this.getAttribute(rowIndex);
                String string = oldValue = att == null ? null : att.getValue();
                if (!aValue.equals(oldValue)) {
                    ReloadSchemaAttribute reloadSchemaAttribute;
                    if (aValue.equals("")) {
                        if (att != null) {
                            element.removeAttribute(att);
                            doc.changedElement(ReloadAttributeEditor.this, element);
                        }
                        return;
                    }
                    if (att == null && (reloadSchemaAttribute = ReloadAttributeEditor.this.getSchemaAttribute(rowIndex)) != null) {
                        att = doc.addAttribute(ReloadAttributeEditor.this, element, reloadSchemaAttribute);
                    }
                    if (att != null) {
                        att.setValue((String)aValue);
                        doc.changedElement(ReloadAttributeEditor.this, element);
                    }
                }
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ReloadAttributeEditor.this.getAttributeFriendlyName(rowIndex);
                }
                case 1: {
                    Attribute att = ReloadAttributeEditor.this.getAttribute(rowIndex);
                    return att == null ? null : att.getValue();
                }
            }
            return "";
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.cNames[columnIndex];
        }

        @Override
        public int getRowCount() {
            if (ReloadAttributeEditor.this._elementBinding != null) {
                if (ReloadAttributeEditor.this._elementBinding.getSchemaElement() != null) {
                    ReloadSchemaAttribute[] atts = ReloadAttributeEditor.this._elementBinding.getSchemaElement().getAttributes();
                    return atts.length;
                }
                if (ReloadAttributeEditor.this._elementBinding.getElement() != null) {
                    List list = ReloadAttributeEditor.this._elementBinding.getElement().getAttributes();
                    return list.size();
                }
            }
            return 0;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }
    }
}

