/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import uk.ac.reload.editor.ReloadElementBinding;
import uk.ac.reload.editor.gui.ReloadAttributeEditor;
import uk.ac.reload.editor.gui.ReloadElementEditor;
import uk.ac.reload.editor.simplesequencing.SimpleSequencingTabsPane;

public class ReloadElementAttributePanel
extends JPanel {
    public ReloadElementEditor _elementPanel;
    protected ReloadAttributeEditor _attrPanel;
    protected JSplitPane _splitPane;
    protected SimpleSequencingTabsPane _ssPane;

    public ReloadElementAttributePanel() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this._elementPanel = this.createElementEditor();
        this._attrPanel = this.createAttributeEditor();
        this._splitPane = new JSplitPane(0);
        this._splitPane.setOneTouchExpandable(true);
        this._splitPane.setTopComponent(this._elementPanel);
        this._splitPane.setBottomComponent(this._attrPanel);
        this.add((Component)this._splitPane, "Center");
    }

    public void initView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReloadElementAttributePanel.this._splitPane.setDividerLocation(0.4);
            }
        });
    }

    protected ReloadElementEditor createElementEditor() {
        return new ReloadElementEditor();
    }

    protected ReloadAttributeEditor createAttributeEditor() {
        return new ReloadAttributeEditor();
    }

    public ReloadElementEditor getElementEditor() {
        return this._elementPanel;
    }

    public ReloadAttributeEditor getAttributeEditor() {
        return this._attrPanel;
    }

    public JSplitPane getSplitpane() {
        return this._splitPane;
    }

    public void setElement(ReloadElementBinding elementBinding) {
        this._elementPanel.setElement(elementBinding);
        this._attrPanel.setElement(elementBinding);
    }

    public void clear() {
    }

    public void destroy() {
        this._elementPanel.destroy();
        this._attrPanel.destroy();
    }
}

