/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.widgets.ReloadTextPane;
import uk.ac.reload.dweezil.gui.widgets.ReloadWidget;
import uk.ac.reload.editor.ReloadElementBinding;
import uk.ac.reload.editor.gui.ReloadWidgetFactory;
import uk.ac.reload.moonunit.dom.ReloadDocumentListener;
import uk.ac.reload.moonunit.dom.ReloadDocumentListenerEvent;
import uk.ac.reload.moonunit.dom.ReloadSchemaDocument;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class ReloadElementEditor
extends JPanel
implements ReloadDocumentListener,
DocumentListener {
    protected ReloadElementBinding _elementBinding;
    protected ReloadWidget _reloadWidget;
    protected JPanel padPanel;
    protected boolean allowNotification = true;

    public ReloadElementEditor() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.padPanel = new JPanel();
    }

    public void setElement(ReloadElementBinding elementBinding) {
        if (this._elementBinding != null) {
            this._elementBinding.getReloadDocument().removeReloadDocumentListener(this);
        }
        this._elementBinding = elementBinding;
        this._elementBinding.getReloadDocument().addReloadDocumentListener(this);
        this.setupWidget(this._elementBinding.getReloadDocument(), this._elementBinding.getElement(), this._elementBinding.getSchemaElement());
    }

    protected void setupWidget(ReloadSchemaDocument doc, Element element, ReloadSchemaElement schemaElement) {
        boolean enabled;
        if (this._reloadWidget != null) {
            this._reloadWidget.removeDocumentListener(this);
        }
        this.removeAll();
        boolean bl = enabled = schemaElement == null ? true : schemaElement.isValue();
        if (enabled) {
            this._reloadWidget = ReloadWidgetFactory.getWidget(doc.getReloadSchemaController(), schemaElement);
            if (this._reloadWidget.isSingleLine()) {
                this.add((Component)((Object)this._reloadWidget), "North");
                this.add((Component)this.padPanel, "Center");
            } else if (this._reloadWidget instanceof ReloadTextPane) {
                JScrollPane scrollPane = new JScrollPane((Component)((Object)this._reloadWidget));
                this.add((Component)scrollPane, "Center");
            } else {
                this.add((Component)((Object)this._reloadWidget), "Center");
            }
            this.setText(element);
            this._reloadWidget.addDocumentListener(this);
        }
    }

    protected void setText(Element element) {
        this.allowNotification = false;
        if (this._reloadWidget != null) {
            this._reloadWidget.setTextValue(element == null ? "" : element.getText().trim());
        }
        this.allowNotification = true;
    }

    public void insertText(String text) {
        if (this._reloadWidget != null) {
            this._reloadWidget.insertTextValue(text);
        }
    }

    public void setFocus() {
        if (this._reloadWidget != null) {
            ((Component)((Object)this._reloadWidget)).requestFocus();
        }
    }

    public void destroy() {
        if (this._elementBinding != null) {
            this._elementBinding.getReloadDocument().removeReloadDocumentListener(this);
        }
        if (this._reloadWidget != null) {
            this._reloadWidget.removeDocumentListener(this);
        }
    }

    protected synchronized void fireElementChanged(String text) {
        Element element = this._elementBinding.getElement();
        if (element == null) {
            element = this._elementBinding.createElement(this);
        }
        if (element != null) {
            element.setText(text);
            this._elementBinding.getReloadDocument().changedElement(this, element);
        }
    }

    @Override
    public void elementChanged(ReloadDocumentListenerEvent event) {
        Element changed_element;
        if (event.getSource() == this) {
            return;
        }
        Element element = this._elementBinding.getElement();
        if (element != null && element == (changed_element = event.getElement())) {
            this.setText(element);
        }
    }

    @Override
    public void elementRemoved(ReloadDocumentListenerEvent event) {
    }

    @Override
    public void elementAdded(ReloadDocumentListenerEvent event) {
    }

    @Override
    public void documentSaved(ReloadSchemaDocument doc) {
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        if (this.allowNotification && this._reloadWidget != null) {
            this.fireElementChanged(this._reloadWidget.getTextValue());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        if (this.allowNotification && this._reloadWidget != null) {
            this.fireElementChanged(this._reloadWidget.getTextValue());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        if (this.allowNotification && this._reloadWidget != null) {
            this.fireElementChanged(this._reloadWidget.getTextValue());
        }
    }
}

