/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import uk.ac.reload.editor.ReloadElementBinding;
import uk.ac.reload.editor.gui.ReloadElementAttributePanel;
import uk.ac.reload.editor.gui.ReloadTipPanel;

public class ReloadInfoPanel
extends JPanel {
    protected JPanel _mainPanel;
    protected ReloadTipPanel _tipPanel;
    protected ReloadElementAttributePanel _elementAttPanel;

    public ReloadInfoPanel() {
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(0, 0));
        this._mainPanel = this.setupMainPanel();
        this._elementAttPanel = this.createElementAttributePanel();
        this._mainPanel.add(this._elementAttPanel);
        this._tipPanel = new ReloadTipPanel();
        this._mainPanel.add(this._tipPanel);
        this.add((Component)this._mainPanel, "Center");
    }

    public void initView() {
        this._elementAttPanel.initView();
    }

    protected ReloadElementAttributePanel createElementAttributePanel() {
        return new ReloadElementAttributePanel();
    }

    protected JPanel setupMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(1, 2));
        mainPanel.setOpaque(false);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return mainPanel;
    }

    public void setElement(ReloadElementBinding elementBinding) {
        this._tipPanel.setTip(elementBinding.getReloadSchemaController(), elementBinding.getSchemaElement());
        this._elementAttPanel.setElement(elementBinding);
        this.validate();
        this.repaint();
    }

    public void clear() {
        this._tipPanel.clear();
        this._elementAttPanel.clear();
    }

    public void destroy() {
        this._elementAttPanel.destroy();
    }
}

