/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.moonunit.dom.DomPath;
import uk.ac.reload.moonunit.schema.ReloadSchemaController;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class ReloadTipPanel
extends JPanel {
    protected JLabel _nameLabel;
    protected JLabel _tipLabel;

    public ReloadTipPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._nameLabel = new JLabel();
        this._nameLabel.setForeground(Color.BLUE);
        this._nameLabel.setFont(ReloadUIManager.boldFont12);
        this._nameLabel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this._nameLabel, "North");
        this._tipLabel = new JLabel();
        this._tipLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this._tipLabel.setVerticalAlignment(1);
        this.add((Component)this._tipLabel, "Center");
    }

    public void clear() {
        this._nameLabel.setText("");
        this._tipLabel.setText("");
    }

    public void setTip(ReloadSchemaController schemaController, ReloadSchemaElement schemaElement) {
        if (schemaElement != null) {
            DomPath domPath = schemaElement.getDomPath();
            String fname = schemaController.getElementFriendlyName(domPath);
            if (fname == null) {
                fname = schemaElement.getName();
            }
            this._nameLabel.setText(" " + fname);
            String tip = schemaController.getElementTip(domPath);
            if (tip == null) {
                this._tipLabel.setText("");
            } else {
                this._tipLabel.setText("<html><font color=blue>" + tip + "</font><br>");
            }
        } else {
            this._nameLabel.setText("");
            this._tipLabel.setText("");
        }
    }
}

