/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import javax.swing.JComponent;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.gui.widgets.ReloadFileTextField;
import uk.ac.reload.dweezil.gui.widgets.ReloadListBox;
import uk.ac.reload.dweezil.gui.widgets.ReloadNumberField;
import uk.ac.reload.dweezil.gui.widgets.ReloadTextField;
import uk.ac.reload.dweezil.gui.widgets.ReloadTextPane;
import uk.ac.reload.dweezil.gui.widgets.ReloadWidget;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.moonunit.schema.ReloadSchemaController;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;
import uk.ac.reload.moonunit.schema.ReloadVocabularyList;

public final class ReloadWidgetFactory {
    private ReloadWidgetFactory() {
    }

    public static ReloadWidget getWidget(ReloadSchemaController schemaController, ReloadSchemaElement schemaElement) {
        if (schemaElement == null) {
            return ReloadWidgetFactory.getReloadTextField();
        }
        JComponent component = null;
        ReloadVocabularyList vocab = schemaController.getVocabularyList(schemaElement);
        if (vocab != null) {
            component = ReloadWidgetFactory.getReloadListBox();
            component.setListData(vocab.getList());
            return component;
        }
        String name = schemaElement.getName();
        String widget_type = schemaController.getWidgetType(schemaElement.getDomPath());
        component = widget_type != null ? (widget_type.equals("textpane") ? ReloadWidgetFactory.getReloadTextPane() : (widget_type.equals("numberfield") ? ReloadWidgetFactory.getReloadNumberField() : (widget_type.equals("filechooser") ? ReloadWidgetFactory.getReloadFileTextField() : ReloadWidgetFactory.getReloadTextField()))) : ReloadWidgetFactory.getReloadTextField();
        int maxLength = -1;
        String value = schemaController.getFacetValue(schemaElement, "maxLength");
        if (value != null) {
            maxLength = Integer.parseInt(value);
        }
        component.setMaxLength(maxLength);
        return component;
    }

    public static ReloadTextField getReloadTextField() {
        return new ReloadTextField();
    }

    public static ReloadListBox getReloadListBox() {
        return new ReloadListBox();
    }

    public static ReloadTextPane getReloadTextPane() {
        return new ReloadTextPane();
    }

    public static ReloadNumberField getReloadNumberField() {
        return new ReloadNumberField();
    }

    public static ReloadFileTextField getReloadFileTextField() {
        return new ReloadFileTextField(ReloadFileTextField.FILE_TYPE, "Select File", ReloadUIManager.getIcon(ReloadEditor.ICON_OPEN));
    }
}

