/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.menu;

import java.awt.Toolkit;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import uk.ac.reload.dweezil.gui.ReloadInternalFrame;
import uk.ac.reload.dweezil.gui.ReloadToolBar;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.menu.MenuAction_About;
import uk.ac.reload.editor.menu.MenuAction_CascadeWindow;
import uk.ac.reload.editor.menu.MenuAction_Convert2004;
import uk.ac.reload.editor.menu.MenuAction_DebugSchema;
import uk.ac.reload.editor.menu.MenuAction_EditMetadata;
import uk.ac.reload.editor.menu.MenuAction_EditSCORM;
import uk.ac.reload.editor.menu.MenuAction_Exit;
import uk.ac.reload.editor.menu.MenuAction_Help;
import uk.ac.reload.editor.menu.MenuAction_ImportResources;
import uk.ac.reload.editor.menu.MenuAction_LookAndFeel;
import uk.ac.reload.editor.menu.MenuAction_New;
import uk.ac.reload.editor.menu.MenuAction_NewMetadata1_2;
import uk.ac.reload.editor.menu.MenuAction_NewMetadata1_3;
import uk.ac.reload.editor.menu.MenuAction_NewMetadata1_3_ADLR;
import uk.ac.reload.editor.menu.MenuAction_NewMetadata1_3_HC;
import uk.ac.reload.editor.menu.MenuAction_NewSCORM1_2Package;
import uk.ac.reload.editor.menu.MenuAction_NewSCORM1_3Package;
import uk.ac.reload.editor.menu.MenuAction_NewTemplate;
import uk.ac.reload.editor.menu.MenuAction_Open;
import uk.ac.reload.editor.menu.MenuAction_Prefs;
import uk.ac.reload.editor.menu.MenuAction_RecentOpen;
import uk.ac.reload.editor.menu.MenuAction_Save;
import uk.ac.reload.editor.menu.MenuAction_SaveAs;
import uk.ac.reload.editor.menu.MenuAction_StatusWindow;
import uk.ac.reload.editor.menu.MenuAction_ThirdToFourth;
import uk.ac.reload.editor.menu.MenuAction_TileHorizontalWindow;
import uk.ac.reload.editor.menu.MenuAction_TileVerticalWindow;
import uk.ac.reload.editor.menu.MenuAction_Validate;
import uk.ac.reload.editor.menu.MenuAction_ViewCP;
import uk.ac.reload.editor.menu.MenuAction_ViewFile;
import uk.ac.reload.editor.menu.MenuAction_ViewRTE;
import uk.ac.reload.editor.menu.MenuAction_ZipIt;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.prefs.ReloadEditorPrefs;
import uk.ac.reload.moonunit.IMSDocumentHandler;

public class MainMenu
extends JMenuBar {
    public static MainMenu sharedInstance = new MainMenu();
    public MenuAction_Save actionSave = new MenuAction_Save();
    public MenuAction_SaveAs actionSaveAs = new MenuAction_SaveAs();
    public MenuAction_ImportResources actionImport = new MenuAction_ImportResources();
    public MenuAction_EditMetadata actionEditMetadata = new MenuAction_EditMetadata();
    public MenuAction_EditSCORM actionEditSCORM = new MenuAction_EditSCORM();
    public MenuAction_ZipIt actionZipIt = new MenuAction_ZipIt();
    public MenuAction_Convert2004 actionConvert = new MenuAction_Convert2004();
    public MenuAction_ViewFile actionViewFile = new MenuAction_ViewFile();
    public MenuAction_ViewCP actionViewCP = new MenuAction_ViewCP();
    public MenuAction_Validate validatePackage = new MenuAction_Validate();
    public MenuAction_ViewRTE actionViewRTE = new MenuAction_ViewRTE();
    public MenuAction_ThirdToFourth thirdToFourthConversion = new MenuAction_ThirdToFourth();
    private ReloadToolBar toolBar;
    private int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public JMenu fileMenu;
    public Menu_Edit editMenu;
    public JMenu debugMenu;
    public JMenu optionsMenu;
    public JMenu viewMenu;
    public JMenu windowMenu;
    public JMenu helpMenu;

    private MainMenu() {
        this.createMenuBar();
        this.toolBar = this.createToolBar();
    }

    public void addInternalFrame(ReloadInternalFrame frame) {
        this.windowMenu.add(frame.getMenuItem());
    }

    public void removeInternalFrame(ReloadInternalFrame frame) {
        this.windowMenu.remove(frame.getMenuItem());
    }

    private void createMenuBar() {
        this.fileMenu = this.createFileMenu();
        this.editMenu = new Menu_Edit();
        this.add(this.editMenu);
        if (ReloadEditor.DEBUG) {
            this.debugMenu = this.createDebugMenu();
        }
        this.optionsMenu = this.createOptionsMenu();
        this.viewMenu = this.createViewMenu();
        this.windowMenu = this.createWindowMenu();
        this.helpMenu = this.createHelpMenu();
    }

    private JMenu createFileMenu() {
        JMenu jmenu = this.add(new JMenu("File"));
        jmenu.setMnemonic('f');
        JMenu newMenu = new JMenu("New");
        newMenu.setMnemonic('n');
        newMenu.setIcon(ReloadUIManager.getIcon(ReloadEditor.ICON_NEW));
        jmenu.add(newMenu);
        JMenuItem item = newMenu.add(new MenuAction_NewMetadata1_2());
        item.setMnemonic('m');
        item = newMenu.add(new MenuAction_NewMetadata1_3());
        item.setMnemonic('m');
        item = newMenu.add(new MenuAction_NewMetadata1_3_HC());
        item.setMnemonic('h');
        item = newMenu.add(new MenuAction_NewMetadata1_3_ADLR());
        item.setMnemonic('r');
        item = newMenu.add(new MenuAction_NewSCORM1_2Package());
        item.setMnemonic('p');
        item = newMenu.add(new MenuAction_NewSCORM1_3Package(false));
        item.setMnemonic('p');
        item = newMenu.add(new MenuAction_NewSCORM1_3Package(true));
        item.setMnemonic('p');
        item = newMenu.add(new MenuAction_NewTemplate());
        item.setMnemonic('t');
        item = jmenu.add(new MenuAction_Open());
        item.setMnemonic('o');
        item = jmenu.add(this.actionImport);
        item.setMnemonic('r');
        jmenu.addSeparator();
        item = jmenu.add(this.actionSave);
        item.setMnemonic('s');
        item.setAccelerator(KeyStroke.getKeyStroke(83, this.keyMask));
        item = jmenu.add(this.actionSaveAs);
        item.setAccelerator(KeyStroke.getKeyStroke(83, 1 + this.keyMask));
        jmenu.addSeparator();
        item = jmenu.add(this.actionZipIt);
        item.setMnemonic('z');
        jmenu.add(this.thirdToFourthConversion);
        this.thirdToFourthConversion.setEnabled(false);
        item = jmenu.add(this.actionConvert);
        item.setMnemonic('v');
        jmenu.addSeparator();
        final JMenu recentMenu = new JMenu("Recent Files");
        recentMenu.setMnemonic('r');
        jmenu.add(recentMenu);
        recentMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                recentMenu.removeAll();
                String[] s = ReloadEditorPrefs.getInstance().getFileHistory();
                for (int i = 0; i < s.length; ++i) {
                    File file = new File(s[i]);
                    recentMenu.add(new MenuAction_RecentOpen(i + 1, file));
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        jmenu.addSeparator();
        item = jmenu.add(new MenuAction_Exit());
        item.setMnemonic('x');
        return jmenu;
    }

    private JMenu createDebugMenu() {
        JMenu jmenu = this.add(new JMenu("Debug"));
        jmenu.setMnemonic('d');
        jmenu.add(new JMenuItem(new MenuAction_DebugSchema(IMSDocumentHandler.IMSMD_121, "IMS Metadata 1.2.1 Schema")));
        jmenu.add(new JMenuItem(new MenuAction_DebugSchema(IMSDocumentHandler.IMSMD_122, "IMS Metadata 1.2.2 Schema")));
        jmenu.add(new JMenuItem(new MenuAction_DebugSchema(IMSDocumentHandler.LOM_10, "LOM Metadata 1.0 Schema")));
        jmenu.addSeparator();
        jmenu.add(new JMenuItem(new MenuAction_DebugSchema(IMSDocumentHandler.IMSCP_112, "IMS Content Packaging 1.1.2 Schema")));
        jmenu.add(new JMenuItem(new MenuAction_DebugSchema(IMSDocumentHandler.IMSCP_113, "IMS Content Packaging 1.1.3 Schema")));
        jmenu.addSeparator();
        jmenu.add(new JMenuItem(new MenuAction_DebugSchema(IMSDocumentHandler.ADLCP_120_112, "ADL SCORM 1.2 (CP 1.1.2) Schema")));
        jmenu.add(new JMenuItem(new MenuAction_DebugSchema(IMSDocumentHandler.ADLCP_120_113, "ADL SCORM 1.2 (CP 1.1.3) Schema")));
        jmenu.add(new JMenuItem(new MenuAction_DebugSchema(IMSDocumentHandler.ADLCP_130_4th, "ADL SCORM 2004 schema")));
        jmenu.add(this.validatePackage);
        jmenu.addSeparator();
        jmenu.add(new JMenuItem(new MenuAction_DebugSchema(IMSDocumentHandler.IMSSS_100, "IMS Simple Sequencing 1.0 Schema")));
        return jmenu;
    }

    private JMenu createOptionsMenu() {
        JMenu jmenu = this.add(new JMenu("Options"));
        jmenu.setMnemonic('o');
        JMenuItem item = jmenu.add(new MenuAction_Prefs());
        JMenu subMenu = new JMenu("Look & Feel");
        this.addLookAndFeels(subMenu);
        jmenu.add(subMenu);
        return jmenu;
    }

    private JMenu createViewMenu() {
        JMenu jmenu = this.add(new JMenu("View"));
        jmenu.setMnemonic('v');
        JMenuItem item = jmenu.add(this.actionViewFile);
        item.setMnemonic('f');
        item = jmenu.add(this.actionViewCP);
        item.setMnemonic('i');
        item = jmenu.add(this.actionViewRTE);
        item.setMnemonic('r');
        jmenu.addSeparator();
        item = jmenu.add(new MenuAction_StatusWindow());
        return jmenu;
    }

    protected void addLookAndFeels(JMenu menu) {
        ButtonGroup bg = new ButtonGroup();
        UIManager.LookAndFeelInfo[] lfs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lfs.length; ++i) {
            UIManager.LookAndFeelInfo lfInfo = lfs[i];
            JCheckBoxMenuItem jcb = new JCheckBoxMenuItem(new MenuAction_LookAndFeel(lfInfo));
            JMenuItem item = menu.add(jcb);
            bg.add(item);
            if (!UIManager.getLookAndFeel().getName().equals(lfInfo.getName())) continue;
            jcb.setSelected(true);
        }
    }

    private JMenu createWindowMenu() {
        JMenu jmenu = this.add(new JMenu("Window"));
        jmenu.setMnemonic('w');
        JMenuItem item = jmenu.add(new MenuAction_CascadeWindow());
        jmenu.setMnemonic('c');
        item = jmenu.add(new MenuAction_TileHorizontalWindow());
        jmenu.setMnemonic('t');
        item = jmenu.add(new MenuAction_TileVerticalWindow());
        jmenu.setMnemonic('v');
        jmenu.addSeparator();
        return jmenu;
    }

    private JMenu createHelpMenu() {
        JMenu jmenu = this.add(new JMenu("Help"));
        jmenu.setMnemonic('h');
        JMenuItem item = jmenu.add(new MenuAction_Help());
        item.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jmenu.addSeparator();
        item = jmenu.add(new MenuAction_About());
        item.setMnemonic('a');
        return jmenu;
    }

    private ReloadToolBar createToolBar() {
        ReloadToolBar tBar = new ReloadToolBar();
        MenuAction_New actionNew = new MenuAction_New();
        tBar.add(actionNew);
        MenuAction_Open actionOpen = new MenuAction_Open();
        tBar.add(actionOpen);
        tBar.add(this.actionSave);
        tBar.addSeparator();
        tBar.add(this.editMenu.actionUndo);
        tBar.add(this.editMenu.actionRedo);
        tBar.addSeparator();
        tBar.add(this.editMenu.actionCut);
        tBar.add(this.editMenu.actionCopy);
        tBar.add(this.editMenu.actionPaste);
        tBar.add(this.editMenu.actionDelete);
        tBar.addSeparator();
        tBar.add(this.editMenu.actionMoveUp);
        tBar.add(this.editMenu.actionMoveDown);
        tBar.addSeparator();
        tBar.add(this.actionEditMetadata);
        tBar.add(this.actionEditSCORM);
        tBar.addSeparator();
        tBar.add(this.actionZipIt);
        tBar.add(this.actionViewFile);
        tBar.add(this.actionViewCP);
        tBar.add(this.actionViewRTE);
        tBar.add(this.validatePackage);
        return tBar;
    }

    public ReloadToolBar getReloadToolBar() {
        return this.toolBar;
    }
}

