/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.menu;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.adl.validator.Validator;
import org.adl.validator.util.Result;
import org.adl.validator.util.ResultCollection;
import org.adl.validator.util.ValidatorMessage;

public class ManifestTester {
    private static String mPackageProfileType = "";
    private static List mFilePathList = new ArrayList();
    private static int mNumOfFailures = 0;
    private static int mNumTested = 0;

    public static String validatePackage(String[] iArgs) {
        return ManifestTester.executeTest(iArgs);
    }

    protected static String executeTest(String[] iArgs) {
        mNumOfFailures = 0;
        mNumTested = 0;
        mFilePathList = new ArrayList();
        boolean paramatersCorrect = ManifestTester.processParameters(iArgs);
        if (!paramatersCorrect) {
            ManifestTester.showHelp();
            return "";
        }
        Iterator fileIter = mFilePathList.iterator();
        String resultOutput = "";
        while (fileIter.hasNext()) {
            File currFile = new File(fileIter.next().toString());
            if (currFile.isDirectory()) {
                File[] dirFiles = currFile.listFiles();
                boolean validatedFile = false;
                for (int i = 0; i < dirFiles.length; ++i) {
                    if (dirFiles[i].isDirectory() || !ManifestTester.checkExtension(dirFiles[i].getAbsolutePath(), true)) continue;
                    validatedFile = true;
                    ResultCollection results = ManifestTester.validate(dirFiles[i].getAbsolutePath());
                    resultOutput = ManifestTester.formatResults(dirFiles[i].getAbsolutePath(), results);
                    return resultOutput;
                }
                if (validatedFile) continue;
                System.out.println("**************************************");
                System.out.println("Manifest Test Subject : " + currFile.getAbsolutePath());
                System.out.println("**************************************<br/>");
                System.out.println("ERROR: No files were found in [" + currFile.getAbsolutePath() + "]");
                System.out.println("Please provide a directory containing PIF(.zip) Content Package files<br/>");
                continue;
            }
            if (ManifestTester.checkExtension(currFile.getAbsolutePath(), false)) {
                ResultCollection results = ManifestTester.validate(currFile.getAbsolutePath());
                resultOutput = ManifestTester.formatResults(currFile.getAbsolutePath(), results);
                return resultOutput;
            }
            System.out.println("**************************************");
            System.out.println("Manifest Test Subject : " + currFile.getAbsolutePath());
            System.out.println("**************************************<br/>");
            System.out.println("ERROR: The file [" + currFile.getAbsolutePath() + "] is invalid");
            System.out.println("Please provide a PIF(.zip) Content Package or imsmanifest.xml file<br/>");
        }
        resultOutput = ManifestTester.printSummary();
        return resultOutput;
    }

    protected static boolean checkExtension(String iExt, boolean iFolder) {
        if (iExt.indexOf(".") != -1 && iExt.length() >= 4) {
            String ext = iExt.substring(iExt.lastIndexOf("."));
            String fileNameWithExt = iExt.substring(iExt.lastIndexOf("\\"));
            if (ext.equalsIgnoreCase(".zip")) {
                return true;
            }
            return !iFolder && fileNameWithExt.equalsIgnoreCase("\\imsmanifest.xml");
        }
        return false;
    }

    protected static String formatResults(String iFilePath, ResultCollection iResults) {
        StringBuffer mResults = new StringBuffer();
        mResults.append("**************************************<br/>");
        mResults.append("Manifest Test Subject : " + iFilePath + "<br/>");
        mResults.append("**************************************<br/><br/>");
        Iterator resIter = iResults.getPackageResultsCollection().iterator();
        boolean testFails = false;
        while (resIter.hasNext()) {
            List failures;
            Result res = (Result)resIter.next();
            if (res.getOverallStatusMessage().size() <= 0 && ManifestTester.getFailures(res).size() <= 0) continue;
            if (!res.getOverallStatusMessage().isEmpty()) {
                Iterator subIter = res.getOverallStatusMessage().iterator();
                while (subIter.hasNext()) {
                    mResults.append(subIter.next().toString() + "<br/>");
                }
            }
            if ((failures = ManifestTester.getFailures(res)).size() > 0) {
                mResults.append("*******************************************************************<br/>");
            }
            Iterator failureIter = failures.iterator();
            while (failureIter.hasNext()) {
                String tempMsg = failureIter.next().toString();
                mResults.append("\t<span style='color:red;'>" + tempMsg + "</span><br/>");
                if (!tempMsg.startsWith("FAILED")) continue;
                testFails = true;
            }
        }
        if (testFails) {
            ++mNumOfFailures;
            mResults.append("<br/>The Manifest Test Subject Did Not Pass All Checkpoints<br/>");
        } else {
            mResults.append("<br/>The Manifest Test Subject Passed All Checkpoints<br/>");
        }
        return mResults.toString();
    }

    protected static ResultCollection validate(String iFilePath) {
        ++mNumTested;
        Validator mSCORMValidator = new Validator(iFilePath, mPackageProfileType, true);
        ArrayList<String> checkerList = new ArrayList<String>();
        checkerList.add("org.adl.validator.packagechecker.checks.IMSManifestAtRootChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.WellformednessChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.SubmanifestChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.ManifestRootElementChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.RequiredFilesChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.SchemaValidationChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.ApplicationProfileChecker");
        mSCORMValidator.setCheckerList(checkerList);
        mSCORMValidator.validate();
        return mSCORMValidator.getResultCollection();
    }

    protected static boolean processParameters(String[] iArgs) {
        mPackageProfileType = "";
        mFilePathList = new ArrayList();
        boolean doneWithFiles = false;
        for (int i = 0; i < iArgs.length; ++i) {
            if (iArgs[i].equalsIgnoreCase("-h") || iArgs[i].equalsIgnoreCase("-help")) {
                return false;
            }
            if (!doneWithFiles && iArgs[i].charAt(0) != '-') {
                mFilePathList.add(iArgs[i]);
                continue;
            }
            if (iArgs[i].equalsIgnoreCase("-r")) {
                doneWithFiles = true;
                if (!mPackageProfileType.equals("")) {
                    return false;
                }
                mPackageProfileType = "resource";
                continue;
            }
            System.out.println("ERROR: Invalid option: [" + iArgs[i] + "]");
            System.out.println("");
            return false;
        }
        if (mPackageProfileType.equals("")) {
            mPackageProfileType = "contentaggregation";
        }
        if (mFilePathList.size() == 0) {
            System.out.println("ERROR: No filename(s) provided");
            System.out.println("");
            return false;
        }
        return true;
    }

    private static String printSummary() {
        StringBuffer mSummary = new StringBuffer();
        mSummary.append("**************************************<br/>");
        mSummary.append("Total Files Tested : " + mNumTested + "<br/>");
        mSummary.append("Total Passed : " + (mNumTested - mNumOfFailures) + "<br/>");
        mSummary.append("Total Failed : " + mNumOfFailures + "<br/>");
        mSummary.append("**************************************<br/>");
        return mSummary.toString();
    }

    private static List getFailures(Result iResult) {
        Result res = iResult;
        ArrayList<String> failList = new ArrayList<String>();
        for (ValidatorMessage msg : res.getPackageCheckerMessages()) {
            if (msg.getMessageType() != 3 && msg.getMessageType() != 1 && msg.getMessageType() != 9) continue;
            failList.add(msg.toString());
        }
        return failList;
    }

    protected static void showHelp() {
        System.out.println("Usage: java -jar adlvalidator.jar [filenames...] [options]");
        System.out.println("    or java -jar adlvalidator.jar [filenames...]");
        System.out.println("");
        System.out.println("Where filenames include:");
        System.out.println("\tThe path of a PIF(.zip) Content Package");
        System.out.println("\tThe path of a non-PIF(.xml) Content Package manifest file");
        System.out.println("\tThe path of a directory containing PIF(.zip) Content Package files");
        System.out.println("");
        System.out.println("Where options include:");
        System.out.println("\t-r\t\tValidate against the Resource SCORM Application Profile");
        System.out.println("\t-h | -help\tDisplay help information (No filename is required)");
        System.out.println("");
        System.out.println("When no options are provided, the Content Package(s) will be validated");
        System.out.println("against the Content Aggregation SCORM Application Profile");
        System.out.println("");
        System.out.println("Multiple filenames can be provided to allow sequential validation of");
        System.out.println("multiple Content Packages or Content Package manifests");
    }
}

