/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.menu;

import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import uk.ac.reload.dweezil.menu.ReloadMenu;
import uk.ac.reload.editor.menu.MenuAction_Copy;
import uk.ac.reload.editor.menu.MenuAction_Cut;
import uk.ac.reload.editor.menu.MenuAction_Delete;
import uk.ac.reload.editor.menu.MenuAction_MoveDown;
import uk.ac.reload.editor.menu.MenuAction_MoveUp;
import uk.ac.reload.editor.menu.MenuAction_Paste;
import uk.ac.reload.editor.menu.MenuAction_Redo;
import uk.ac.reload.editor.menu.MenuAction_Undo;

public class Menu_Edit
extends ReloadMenu {
    public MenuAction_Undo actionUndo;
    public MenuAction_Redo actionRedo;
    public MenuAction_Cut actionCut;
    public MenuAction_Copy actionCopy;
    public MenuAction_Paste actionPaste;
    public MenuAction_Delete actionDelete;
    public MenuAction_MoveUp actionMoveUp;
    public MenuAction_MoveDown actionMoveDown;

    public Menu_Edit() {
        super("Edit");
        this.setMnemonic('e');
        this.actionUndo = new MenuAction_Undo();
        this.actionRedo = new MenuAction_Redo();
        this.actionCut = new MenuAction_Cut();
        this.actionCopy = new MenuAction_Copy();
        this.actionPaste = new MenuAction_Paste();
        this.actionDelete = new MenuAction_Delete();
        this.actionMoveUp = new MenuAction_MoveUp();
        this.actionMoveDown = new MenuAction_MoveDown();
        int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuItem item = this.add(this.actionUndo);
        item.setAccelerator(KeyStroke.getKeyStroke(90, keyMask));
        item = this.add(this.actionRedo);
        item.setAccelerator(KeyStroke.getKeyStroke(90, 1 + keyMask));
        this.addSeparator();
        item = this.add(this.actionCut);
        item.setAccelerator(KeyStroke.getKeyStroke(88, keyMask));
        item = this.add(this.actionCopy);
        item.setAccelerator(KeyStroke.getKeyStroke(67, keyMask));
        item = this.add(this.actionPaste);
        item.setAccelerator(KeyStroke.getKeyStroke(86, keyMask));
        item = this.add(this.actionDelete);
        item.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.addSeparator();
        item = this.add(this.actionMoveUp);
        item.setAccelerator(KeyStroke.getKeyStroke(38, 8));
        item = this.add(this.actionMoveDown);
        item.setAccelerator(KeyStroke.getKeyStroke(40, 8));
    }

    public void remapKeyStrokes(JComponent component) {
        int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        component.getInputMap().put(KeyStroke.getKeyStroke(88, keyMask), "CUT");
        component.getActionMap().put("CUT", this.actionCut);
        component.getInputMap().put(KeyStroke.getKeyStroke(67, keyMask), "COPY");
        component.getActionMap().put("COPY", this.actionCopy);
        component.getInputMap().put(KeyStroke.getKeyStroke(86, keyMask), "PASTE");
        component.getActionMap().put("PASTE", this.actionPaste);
    }
}

