/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata;

import java.io.File;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.dweezil.util.DweezilXMLException;
import uk.ac.reload.dweezil.util.XMLUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.moonunit.IMSDocumentHandler;
import uk.ac.reload.moonunit.dom.ReloadDocumentClipboard;
import uk.ac.reload.moonunit.dom.ReloadSchemaDocument;
import uk.ac.reload.moonunit.dom.metadata.AbstractMetadata;
import uk.ac.reload.moonunit.schema.ReloadSchema;
import uk.ac.reload.moonunit.schema.ReloadSchemaElement;

public class Metadata
extends ReloadSchemaDocument
implements AbstractMetadata {
    static final String[] md_comments = new String[]{"This is a Reload version " + ReloadEditor.VERSION + " Metadata document", "Spawned from the Reload Metadata Generator - http://www.adlnet.gov"};
    protected boolean _isStandalone;

    public Metadata(boolean isStandalone) {
        this._isStandalone = isStandalone;
    }

    public Metadata(File file, Document doc, MetadataSchemaController schemaController) {
        this(true);
        this._file = file;
        this._doc = doc;
        this._controller = schemaController;
    }

    public Metadata(Element mdElement, MetadataSchemaController schemaController) {
        this(false);
        this._doc = new Document();
        this._doc.setRootElement(mdElement);
        this._controller = schemaController;
    }

    public void newDocument(MetadataSchemaController controller) {
        this._doc = new Document();
        this._controller = controller;
        if (this._isStandalone) {
            this.addComments(this._doc);
        }
        ReloadSchema mdSchema = this._controller.getReloadSchema();
        Element root = this.addElementBySchema(this, null, mdSchema.getRootElement(), true);
        this._doc.setRootElement(root);
        if (this._isStandalone) {
            this.addRootDeclarations(root);
        }
        this.setDirty(false);
    }

    @Override
    public String getTargetRootElementName() {
        return "lom";
    }

    @Override
    public String[] getComments() {
        return md_comments;
    }

    private void addRootDeclarations(Element root) {
        ReloadSchema mdSchema = this.getReloadSchemaController().getReloadSchema();
        root.addNamespaceDeclaration(IMSDocumentHandler.XSI_Namespace);
    }

    public void importMetadata(Document doc, MetadataSchemaController controller) throws ReloadEditorException {
        Element root = doc.getRootElement();
        root.setAttributes(null);
        Namespace ns = root.getNamespace();
        if (ns != null) {
            IMSDocumentHandler.replaceNamespaces(root, ns, this.getSchemaNamespaceEmbedded());
        }
        this._doc = doc;
        this._controller = controller;
    }

    public void exportMetadata(File file) throws ReloadEditorException {
        if (!this.isStandalone() && this._doc != null) {
            Document newDoc = new Document();
            this.addComments(newDoc);
            Element root = (Element)this._doc.getRootElement().clone();
            Namespace ns = root.getNamespace();
            if (ns != null) {
                IMSDocumentHandler.replaceNamespaces(root, ns, Namespace.getNamespace(ns.getURI()));
            }
            newDoc.setRootElement(root);
            this.addRootDeclarations(root);
            try {
                XMLUtils.write2XMLFile(newDoc, file);
            }
            catch (DweezilXMLException ex) {
                throw new ReloadEditorException(ex);
            }
            Object var2_2 = null;
        }
    }

    public boolean isStandalone() {
        return this._isStandalone;
    }

    @Override
    public Namespace getSchemaNamespace() {
        if (this._isStandalone) {
            return super.getSchemaNamespace();
        }
        return this.getSchemaNamespaceEmbedded();
    }

    public Namespace getSchemaNamespaceStandalone() {
        return super.getSchemaNamespace();
    }

    public Namespace getSchemaNamespaceEmbedded() {
        if (((MetadataSchemaController)this._controller).getMetadataVersion().equals(IMSDocumentHandler.LOM_10)) {
            return Namespace.getNamespace(IMSDocumentHandler.LOM_NAMESPACE_PREFIX, this.getSchemaNamespaceStandalone().getURI());
        }
        return Namespace.getNamespace(IMSDocumentHandler.IMSMD_NAMESPACE_PREFIX, this.getSchemaNamespaceStandalone().getURI());
    }

    @Override
    public boolean canCopyElement(Element element) {
        return !element.isRootElement();
    }

    @Override
    public boolean canCutElement(Element element, ReloadSchemaElement schemaElement) {
        return this.canDeleteElement(element, schemaElement);
    }

    @Override
    public boolean canPasteFromClipboard(Element element) {
        Element clipboardElement = ReloadDocumentClipboard.getElement();
        return clipboardElement != null && this.isAllowedChild(element, clipboardElement);
    }
}

