/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.metadata;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.ReloadComboBox;
import uk.ac.reload.dweezil.menu.ReloadUndoMenuManager;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.menu.Menu_Edit;
import uk.ac.reload.editor.metadata.Metadata;
import uk.ac.reload.editor.metadata.MetadataHelperProfile;
import uk.ac.reload.editor.metadata.MetadataSchemaController;
import uk.ac.reload.editor.metadata.formview.MetadataFormPanel;
import uk.ac.reload.editor.metadata.tableview.MetadataTablePanel;
import uk.ac.reload.moonunit.IMSDocumentHandler;

public class MetadataEditor
extends JPanel {
    protected Metadata _metadata;
    protected MetadataPrefsPanel _prefsPanel;
    protected MetadataFormPanel _shortFormPanel;
    protected MetadataFormPanel _longFormPanel;
    protected MetadataTablePanel _tablePanel;
    protected JTabbedPane _tabPane;
    protected Menu_Edit _editMenu;
    protected ReloadUndoMenuManager _undoMenuManager;
    private boolean _isADLRMetadata;
    private Element _Target = null;

    public MetadataEditor(Menu_Edit editMenu) {
        this._editMenu = editMenu;
        this._isADLRMetadata = false;
        this.setLayout(new BorderLayout());
        this._longFormPanel = new MetadataFormPanel(this);
        this._shortFormPanel = new MetadataFormPanel(this);
        this._tablePanel = new MetadataTablePanel(editMenu);
        this._prefsPanel = new MetadataPrefsPanel();
    }

    public void SaveClassifications() {
        if (this._shortFormPanel != null) {
            this._shortFormPanel.SaveClassificationData();
        }
        this._longFormPanel.SaveClassificationData();
    }

    public MetadataEditor(Menu_Edit editMenu, boolean isADLRMetadata) {
        this._editMenu = editMenu;
        this._isADLRMetadata = isADLRMetadata;
        this.setLayout(new BorderLayout());
        this._longFormPanel = new MetadataFormPanel(this);
        this._shortFormPanel = new MetadataFormPanel(this);
        this._tablePanel = new MetadataTablePanel(editMenu);
        this._prefsPanel = new MetadataPrefsPanel();
    }

    public Metadata getMetadata() {
        return this._metadata;
    }

    public void newDocument(boolean standalone, MetadataSchemaController schemaController) throws ReloadEditorException {
        this._metadata = new Metadata(standalone);
        this._metadata.newDocument(schemaController);
        this.init(this._metadata);
    }

    public void setDocument(File file, Document doc, MetadataSchemaController schemaController) throws ReloadEditorException {
        this._metadata = new Metadata(file, doc, schemaController);
        this.init(this._metadata);
    }

    public void setMetadataElement(Element mdElement, MetadataSchemaController schemaController) {
        this._metadata = new Metadata(mdElement, schemaController);
        this.init(this._metadata);
    }

    public void importMetadata(Document doc, MetadataSchemaController schemaController) throws ReloadEditorException {
        this._metadata.importMetadata(doc, schemaController);
        this._metadata.setDirty(true);
        this.init(this._metadata);
    }

    public void exportMetadata(File file) throws ReloadEditorException {
        if (this._metadata != null) {
            this._metadata.exportMetadata(file);
        }
    }

    private void init(Metadata metadata) {
        JPanel p = new JPanel(new BorderLayout());
        if (this._isADLRMetadata) {
            p.add((Component)new JScrollPane(this._shortFormPanel), "Center");
        }
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)new JScrollPane(this._longFormPanel), "Center");
        this._tabPane = new JTabbedPane();
        this.add((Component)this._tabPane, "Center");
        if (metadata.getSchemaNamespace().getURI().equals(IMSDocumentHandler.LOM_NAMESPACE_URI_10) & this._isADLRMetadata) {
            this._shortFormPanel.setSCORM2004Document(metadata);
            this._tabPane.addTab("Short Form (Required Fields)", null, p, "Short Form View");
        }
        this._tabPane.addTab("Full Form", null, p2, "Full Form View");
        this._tabPane.addTab("Tree View", null, this._tablePanel, "Tree View");
        this._longFormPanel.setDocument(metadata);
        this._tablePanel.setDocument(metadata);
        if (this._undoMenuManager != null) {
            this._undoMenuManager.destroy();
        }
        this._undoMenuManager = new ReloadUndoMenuManager(this._editMenu.actionUndo, this._editMenu.actionRedo);
        metadata.setUndoHandler(this._undoMenuManager.getUndoHandler());
    }

    public void initView() {
        this._tablePanel.initView();
    }

    public ReloadUndoMenuManager getUndoManager() {
        return this._undoMenuManager;
    }

    public void loadProfile(MetadataHelperProfile mdProfile) {
        ((MetadataSchemaController)this.getMetadata().getReloadSchemaController()).setHelperProfile(mdProfile);
        if (this._metadata != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MetadataEditor.this._longFormPanel.destroy();
                    MetadataEditor.this._longFormPanel.setDocument(MetadataEditor.this._metadata);
                    MetadataEditor.this._tablePanel.refresh();
                }
            });
        }
    }

    public void saveMandatoryElements(Element root) {
        String version = ((MetadataSchemaController)this._metadata.getReloadSchemaController()).getMetadataVersion();
        if (root != null && version.equals(IMSDocumentHandler.LOM_10)) {
            this.findElement(root, "metaMetadata");
            if (this._Target == null) {
                this._Target = new Element("metaMetadata", IMSDocumentHandler.LOM_NAMESPACE_PREFIX, IMSDocumentHandler.LOM_NAMESPACE_URI_10);
                root.addContent(this._Target);
            }
            List children = this._Target.getChildren();
            boolean child_1 = false;
            boolean child_2 = false;
            for (int i = 0; i < children.size(); ++i) {
                if (((Element)children.get(i)).getName().equalsIgnoreCase("metadataSchema") && ((Element)children.get(i)).getText().equalsIgnoreCase("LOMv1.0")) {
                    child_1 = true;
                    continue;
                }
                if (!((Element)children.get(i)).getName().equalsIgnoreCase("metadataSchema") || !((Element)children.get(i)).getText().equalsIgnoreCase("ADL-Rv1.0")) continue;
                child_2 = true;
            }
            if (!child_1) {
                Element child = new Element("metadataSchema", IMSDocumentHandler.LOM_NAMESPACE_PREFIX, IMSDocumentHandler.LOM_NAMESPACE_URI_10);
                child.addContent("LOMv1.0");
                this._Target.addContent(child);
            }
            if (!child_2) {
                Element child = new Element("metadataSchema", IMSDocumentHandler.LOM_NAMESPACE_PREFIX, IMSDocumentHandler.LOM_NAMESPACE_URI_10);
                child.addContent("ADL-Rv1.0");
                this._Target.addContent(child);
            }
        }
    }

    protected void findElement(Element root, String target) {
        if (root.getName().equalsIgnoreCase(target)) {
            this._Target = root;
        }
        List children = root.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            this.findElement((Element)children.get(i), target);
        }
    }

    public void destroy() {
        try {
            if (this._undoMenuManager != null) {
                this._undoMenuManager.destroy();
            }
            this._longFormPanel.destroy();
            this._shortFormPanel.destroy();
            this._tablePanel.destroy();
            this._metadata.destroy();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class MetadataPrefsPanel
    extends JPanel {
        ReloadComboBox profileCombobox;

        MetadataPrefsPanel() {
            this.setLayout(new FlowLayout(0));
            this.add(new JLabel("Profile: "));
            this.profileCombobox = new ReloadComboBox(false);
            this.add(this.profileCombobox);
            Object[] profiles = MetadataHelperProfile.getMetadataHelperProfiles();
            this.profileCombobox.setItems(profiles);
        }

        public void init(Metadata metadata) {
            MetadataHelperProfile mdProfile = (MetadataHelperProfile)((MetadataSchemaController)metadata.getReloadSchemaController()).getReloadHelperProfile();
            this.profileCombobox.setSelectedItem(mdProfile);
            this.profileCombobox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetadataHelperProfile profile = (MetadataHelperProfile)MetadataPrefsPanel.this.profileCombobox.getSelectedItem();
                    MetadataEditor.this.loadProfile(profile);
                }
            });
        }
    }
}

